"use strict";
const Base = require("../base");
const LANG = require("../../language"); // 插件语言库
const LANG_T = antSword["language"]["toastr"]; // 通用通知提示
// 内存shell模块
class MemShellManage extends Base {
  createForm(cell) {
    switch (this.shelltype) {
      case "jspjs":
      case "jsp":
        var str = [
          {
            type: "radio",
            name: "ServiceAction",
            label: LANG["core"]["memshell_manage"]["form"]["listAllService"],
            checked: "1",
            value: "listAllService",
            position: "label-right",
          },
          {
            type: "radio",
            name: "ServiceAction",
            label: LANG["core"]["memshell_manage"]["form"]["deleteServlet"],
            value: "deleteServlet",
            position: "label-right",
            list: [
              {
                type: "input",
                name: "ServletName",
                label: "ServletName",
              },
            ],
          },
          {
            type: "radio",
            name: "ServiceAction",
            label: LANG["core"]["memshell_manage"]["form"]["deleteFilter"],
            value: "deleteFilter",
            position: "label-right",
            list: [
              {
                type: "input",
                name: "FilterName",
                label: "FilterName",
              },
            ],
          },{
            type: "radio",
            name: "ServiceAction",
            label: LANG["core"]["memshell_manage"]["form"]["deleteWs"],
            value: "deleteWs",
            position: "label-right",
            list: [
              {
                type: "input",
                name: "WsName",
                label: "Ws-Pattern",
              },
            ],
          },
          { type: "settings", labelWidth: 100, inputWidth: 200 },
        ];
        break;
      case "aspxcsharp":
      case "aspx":
        var str = [
          {
            type: "radio",
            name: "ServiceAction",
            label: LANG["core"]["memshell_manage"]["form"]["listAllService"],
            checked: "1",
            value: "listAllService",
            position: "label-right",
          },
          {
            type: "radio",
            name: "ServiceAction",
            label: LANG["core"]["memshell_manage"]["form"]["deleteVPP"],
            value: "deleteVPP",
            position: "label-right",
            list: [
              {
                type: "input",
                name: "VPPClassName",
                label: LANG["core"]["memshell_manage"]["form"]["VPPClassName"],
              },
              {
                type: "input",
                name: "VPPUrlPath",
                label: LANG["core"]["memshell_manage"]["form"]["VPPUrlPath"],
              },
            ],
          },
          { type: "settings", labelWidth: 100, inputWidth: 200 },
        ];
        break;
    }

    var form = cell.attachForm(str);
    this.form = form;
  }
  getArgs() {
    let args = {};
    let ServiceAction = this.form.getCheckedValue("ServiceAction");
    switch (this.shelltype) {
      case "jspjs":
      case "jsp":
        args["targetAction"] = ServiceAction;
        switch (ServiceAction) {
          case "listAllService":
            break;
          case "deleteServlet":
            args["targetServiceName"] = this.form.getItemValue("ServletName");
            break;
          case "deleteFilter":
            args["targetServiceName"] = this.form.getItemValue("FilterName");
            break;
            case "deleteWs":
              args["targetServiceName"] = this.form.getItemValue("WsName");
              break;
               
          default:
            break;
        }
        break;
      case "aspxcsharp":
      case "aspx":
        this.parammode = 2;
        switch (ServiceAction) {
          case "listAllService":
            break;
          case "deleteVPP":
            args["ClassName"] = this.form.getItemValue("VPPClassName");
            args["UrlPath"] = this.form.getItemValue("VPPUrlPath");
            break;
          default:
            break;
        }
        break;
    }

    console.log(args);

    return args;
  }
  exploit() {
    let self = this;
    self.core = this.top.core;
    let args = this.getArgs(); //获取参数
    let data = this.genPayload(args);
    let cellB = this.layout.cells("b");
    self.core
      .request(data)
      .then((_ret) => {
        let res = antSword.unxss(_ret["text"], false); //过滤xss
        if (res === "") {
          res = "output is empty.";
        }
        self.safeHTML(cellB, res);
        toastr.success(LANG["success"], LANG_T["success"]);
      })
      .catch((e) => {
        console.log(JSON.stringify(e));
        toastr.error(e.constructor === Object ? JSON.stringify(e) : e, "Error");
      });
  }
}

module.exports = MemShellManage;
