"use strict";

const Base = require("../base");
const LANG = require("../../language"); // 插件语言库
const LANG_T = antSword["language"]["toastr"]; // 通用通知提示
class ExecPayload extends Base {
  createToolbar(cell) {
    // 初始化exploit按钮，监听onClick事件
    let self = this;
    let toolbar = cell.attachToolbar();

    toolbar.loadStruct(
      '<toolbar><item type="button" id="exploit" text="exploit" title="" /><item type="button" id="add-body" text="add-body" title="" /></toolbar>',
      function () { }
    );
    if (this.precheck() == false) {
      //如果precheck不通过，按钮将变成灰色。
      toolbar.disableItem("exploit");
    }
    this.toolbar = toolbar;
  }

  createForm(cell) {
    let self = this;
    var str = [
      { type: "input", 
      name: "payload", 
      label: "Payload", 
      rows: "5", 
      labelWidth: 50, 
      labelAlign: "left", 
      inputWidth: 700, 
      inputHeight: 200, 
      required: true }
    ];
    var form = cell.attachForm(str);
    // 添加Body
    let _bodyCount = 0;

    const _addBody = (name = '', value = '') => {
      _bodyCount++;
      form.addItem('body', {
        type: "fieldset",
        label: `#${_bodyCount}`,
        inputWidth: 480,
        list: [{
          type: "input",
          name: `body-${_bodyCount}_name`,
          inputWidth: 350,
          labelWidth: 50,
          label: "Name",
          value: name
        }, {
          type: "input",
          name: `body-${_bodyCount}_value`,
          inputWidth: 350,
          labelWidth: 50,
          label: "Value",
          value: value
        }]
      })
    }
    self.toolbar.attachEvent("onClick", function (id) {
      switch (id) {
        case 'exploit':
          try {
            self.exploit();
          } catch (e) {
            console.log(e);
            toastr.error(e.constructor === Object ? JSON.stringify(e) : e, "Error");
          }
          break;
        case 'add-body':
          _addBody();
          break;
      }
    });
    this.form=form;

    this.showTips();
  }

  showTips() {
    let tips = "";
    switch (this.shelltype) {
      case "aspx":
        tips = `Jscript代码`;
        break;
      case "jsp":
        tips = `base64格式的编译后的class文件`;
        break;
      case "php":
        tips = `PHP 代码`;
      default:
        break;
    }

    this.editor.session.setValue(tips);
  }
  exploit() {
    let self = this;
    self.core = this.top.core;


    let data = {
      _: self.form.getItemValue("payload"),
    };
    let http=self.form.getValues();
    for (let _ in http) {
      if (_.endsWith('value') || !http[_]|| _=='payload') {
        continue
      }
      let _tmp = _.split('-');
      if (_tmp[0] === 'header') {
        data[http[_]] = http[_.replace(/name$/, 'value')];
      } else {
        data[http[_]] = http[_.replace(/name$/, 'value')];
      }
    }
    console.log(data)

    self.core
      .request(data)
      .then((_ret) => {
        let res = antSword.unxss(_ret["text"], false); //过滤xss
        if (res === "") {
          res = "output is empty.";
        }
        this.editor.session.setValue(res); //回显内容到输出结果
        this.editor.setReadOnly(true);
        toastr.success(LANG["success"], LANG_T["success"]);
      })
      .catch((e) => {
        console.log(JSON.stringify(e));
        toastr.error(e.constructor === Object ? JSON.stringify(e) : e, "Error");
      });
  }
}
module.exports = ExecPayload;
