"use strict";

const Base = require("../base");
const LANG = require("../../language"); // 插件语言库
const LANG_T = antSword["language"]["toastr"]; // 通用通知提示
class JarLoader extends Base {
  precheck() {
    if (this.shelltype == "jsp"||this.shelltype == "jspjs") {
      return true;
    }
    return false;
  }
  createForm(cell) {
    let self = this;
    var str = [
      {
        type: "radio",
        name: "load_type",
        label: LANG["core"]["jar_loader"]["form"]["load_by_memory"],
        value: "load_by_memory",
        position: "label-right",
        list: [
          {
            type: "input",
            name: "local_file_path",
            label: LANG["core"]["jar_loader"]["form"]["local_file_path"],
            labelAlign: "left",
            inputWidth: 400,
            labelWidth: 80,
            position: "label-left",
          },
          {
            type: "button",
            name: "select_file",
            value: LANG["core"]["jar_loader"]["form"]["select_file"],
          },
        ],
      },
      {
        type: "radio",
        name: "load_type",
        label: LANG["core"]["jar_loader"]["form"]["load_by_file"],
        value: "load_by_file",
        position: "label-right",
        list: [
          {
            type: "input",
            name: "remote_file_path",
            label: LANG["core"]["jar_loader"]["form"]["remote_file_path"],
            labelAlign: "left",
            inputWidth: 400,
            labelWidth: 80,
            position: "label-left",
          },
        ],
      },
    ];
    var form = cell.attachForm(str);
    form.attachEvent("onButtonClick", function (name, command) {
      const { dialog } = require("electron").remote;
      dialog.showOpenDialog(
        {
          title: "选择Jar文件",
          //默认路径,默认选择的文件
          // defaultPath: "calc.jar",
          //过滤文件后缀
          filters: [
            {
              name: "Jar",
              extensions: ["jar"],
            },
            { name: "All Files", extensions: ["*"] },
          ],
        },
        (result) => {
          console.log(result);
          self.form.setItemValue("local_file_path", result[0]);
        }
      );
    });
    this.form = form;
    this.showTips();
  }
  showTips(){
    let tips=`## 简介
加载Jar到JVM内存中。可用于上传数据库驱动等。
    
## 内存加载
直接通过HTTP包将Jar打入目标内存，仅需选择本地需要上传的Jar文件即可，期间文件不落地。但是Tomcat默认POST最大上传大小为2M，如果超过了此大小请选择手动上传模式。

## 手动上传
先手动将Jar上传到目标服务器上，然后通过路径加载。

`
    this.editor.session.setValue(tips);
  }

  getArgs() {
    let args = {};
    let load_type = this.form.getCheckedValue("load_type");
    if (load_type == "load_by_memory") {
      this.payloadtype = "load_by_memory";
      this.parammode = 2;
      let local_file_path = this.form.getItemValue("local_file_path");
      console.log(local_file_path);
      let jarClassData = this.file2base64(local_file_path);
      // var zlib = require("zlib");
      // let compressed = zlib.deflateSync(Buffer.from(jarClassData, "base64"), {
      //   level: 9, // 0~9
      //   memLevel: 5,
      // });
      // jarClassData = compressed.toString("base64");
      // console.log(jarClassData);
      args["jarClassData"] = jarClassData;
    } else if (load_type == "load_by_file") {
      this.payloadtype = "load_by_file";
      this.parammode = 1;
      args["targetjarPath"] = this.form.getItemValue("remote_file_path");
    }
    return args;
  }
  file2base64(file) {
    const fs = require("fs");
    const path = require("path");
    let filePath = path.resolve(file);
    let data = fs.readFileSync(filePath);
    data = Buffer.from(data).toString("base64");
    return data;
  }
}
module.exports = JarLoader;
