<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Contracts\Console\PromptsForMissingInput;
use App\Models\ClientApiLog;

class ClearApiLogCommand extends Command implements PromptsForMissingInput
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'api:clear-log';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $APiLogs = ClientApiLog::whereDate('created_at','<',now()->subDays(30));
        $this->info('Total Deleted : '.$APiLogs->count());
        $APiLogs->delete();
        $this->info('Complete Delete Process');
    }
}
