<?php

namespace App\Http\Controllers\V1;

use App\Models\User;
use Illuminate\Http\File;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ClientApiLog;
use Rap2hpoutre\FastExcel\FastExcel;
use Illuminate\Support\Facades\Storage;

class ApiController extends Controller
{
    public function commonJsonReturn($message = null): array
    {
        return [
            'version' => '1.0',
            'message' => $message ? $message : 'You api is successfully called',
            'status' => 'suceess',
        ];
    }

    public function apiLogRequest($ClientCollection)
    {
        $log = new ClientApiLog();
        $log->client_id = $ClientCollection->client_id;
        $log->collection_id = $ClientCollection->collection_id;
        $log->request_ip = $this->getIp();
        $log->request_at = now();
        $log->status = 2;
        $log->save();

        return $log;
    }

    public function apiLogResponse($log)
    {
        $log->response_at = now();
        $log->status = 1;
        $log->save();

        return $log;
    }

    public function getIp(){
        foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $key){
            if (array_key_exists($key, $_SERVER) === true){
                foreach (explode(',', $_SERVER[$key]) as $ip){
                    $ip = trim($ip); // just to be safe
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false){
                        return $ip;
                    }
                }
            }
        }
        return request()->ip(); // it will return the server IP if the client IP is not found using this method.
    }

}
