<?php

namespace App\Http\Controllers\V1;

use App\Jobs\GwCsvExportJob;
use Illuminate\Http\Request;
use App\Models\ClientCollection;
use App\Http\Controllers\Controller;
use App\Http\Resources\GwStationResource;
use App\Models\ClientCollectionParameter;
use App\Http\Controllers\V1\QueryTraits\GwApiQuery;

class GwApiController extends ApiController
{
    use GwApiQuery;

    public function getGwJson(Request $request)
    {
        $ClientCollection = ClientCollection::whereHas('ClientToken', function ($query) {
            return $query->where('api_client_tokens.token', request()->bearerToken());
        })->active()->where('collection_id', 1)->first();

        if(!$ClientCollection) {
            return response()->json([
                                'message' => 'You are not authorized to access this API',
                                'status' => 'Unauthorized'
                            ], 403);
        }

        $RequestData = [];

        if($request->has('date')) {
            $RequestData['date'] = $request->date;
        } else {
            if($request->has('from_date')) {
                $RequestData['from_date'] = $request->from_date;
            }

            if($request->has('to_date')) {
                $RequestData['to_date'] = $request->to_date;
            }
        }

        if($request->has('station_id')) {
            $RequestData['identifier'] = $request->station_id;
        } elseif($request->has('station')) {
            $RequestData['identifier'] = $request->station;
        } elseif($request->has('identifier')) {
            $RequestData['identifier'] = $request->identifier;
        }

        if($request->has('per_page')) {
            $RequestData['per_page'] = $request->per_page;
        }

        $ClientCollectionParameter = ClientCollectionParameter::with('CollectionParameter')->where('collection_id', $ClientCollection->collection_id)->where('client_id', $ClientCollection->client_id)->get();

        foreach ($ClientCollectionParameter as $key => $value) {
            if(isset($RequestData['per_page']) && $value->CollectionParameter->name == 'max_per_page') {
                if($RequestData['per_page'] > $value->value) {
                    return response()->json([
                        'message' => 'Your per page limit is '.$value->value,
                        'status' => 'errors'
                    ], 422);
                }

            }

            if(isset($RequestData['from_date']) && $value->CollectionParameter->name == 'start_date') {
                if(now()->parse($RequestData['from_date'])->format('Y-m-d') < now()->parse($value->value)->format('Y-m-d')) {
                    return response()->json([
                        'message' => 'Your from date limit is '.$value->value,
                        'status' => 'errors'
                    ], 422);
                }
            }

            if(isset($RequestData['to_date']) && $value->CollectionParameter->name == 'end_date') {
                if(now()->parse($RequestData['to_date'])->format('Y-m-d') >= now()->parse($value->value)->format('Y-m-d')) {
                    return response()->json([
                        'message' => 'Your to date limit is '.$value->value,
                        'status' => 'errors'
                    ], 422);
                }
            }
        }

        return GwStationResource::collection($this->getGwAllDataQuery($RequestData, $ClientCollection->id, true))->additional($this->commonJsonReturn('You ground water data json format is successfully'));
    }

    public function getGwCsv(Request $request)
    {
        $ClientCollection = ClientCollection::whereHas('ClientToken', function ($query) {
            return $query->where('api_client_tokens.token', request()->bearerToken());
        })->active()->where('collection_id', 2)->first();

        if(!$ClientCollection) {
            return response()->json([
                                'message' => 'You are not authorized to access this API',
                                'status' => 'Unauthorized'
                            ], 403);
        }

        $RequestData = [];

        if($request->has('date')) {
            $RequestData['date'] = $request->date;
        } else {
            if($request->has('from_date')) {
                $RequestData['from_date'] = $request->from_date;
            }

            if($request->has('to_date')) {
                $RequestData['to_date'] = $request->to_date;
            }
        }

        if($request->has('station_id')) {
            $RequestData['identifier'] = $request->station_id;
        } elseif($request->has('station')) {
            $RequestData['identifier'] = $request->station;
        } elseif($request->has('identifier')) {
            $RequestData['identifier'] = $request->identifier;
        }

        if($request->has('per_page')) {
            $RequestData['per_page'] = $request->per_page;
        }

        $ClientCollectionParameter = ClientCollectionParameter::with('CollectionParameter')->where('collection_id', $ClientCollection->collection_id)->where('client_id', $ClientCollection->client_id)->get();

        foreach ($ClientCollectionParameter as $key => $value) {
            if(isset($RequestData['per_page']) && $value->CollectionParameter->name == 'max_per_page') {
                if($RequestData['per_page'] > $value->value) {
                    return response()->json([
                        'message' => 'Your per page limit is '.$value->value,
                        'status' => 'errors'
                    ], 422);
                }

            }

            if(isset($RequestData['from_date']) && $value->CollectionParameter->name == 'start_date') {
                if(now()->parse($RequestData['from_date'])->format('Y-m-d') < now()->parse($value->value)->format('Y-m-d')) {
                    return response()->json([
                        'message' => 'Your from date limit is '.$value->value,
                        'status' => 'errors'
                    ], 422);
                }
            }

            if(isset($RequestData['to_date']) && $value->CollectionParameter->name == 'end_date') {
                if(now()->parse($RequestData['to_date'])->format('Y-m-d') >= now()->parse($value->value)->format('Y-m-d')) {
                    return response()->json([
                        'message' => 'Your to date limit is '.$value->value,
                        'status' => 'errors'
                    ], 422);
                }
            }
        }

        GwCsvExportJob::dispatch($RequestData, $ClientCollection->id);
        return response()->json($this->commonJsonReturn('Your ground water data is successfully export to ftp'), 200);
    }
}
