<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\ClientToken;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class BearerTokenCheck
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $token = $request->bearerToken();

        if(!$token) {
            return response()->json([
                                'message' => 'You are not authorized to access this API',
                                'status' => 'Unauthorized'
                            ], 403);
        }

        // $allowToken = [
        //     'd6e237ea6cb8f73f43700d50cb919a84c4de9feb9757435ef17809a5b06272c5',
        //     '3b1dbc3f5f8e5fc746ad57a496b6ca36a465e3e45a5167731317d2c178bafb37',
        //     'df126d1fd82df4282c09ae1790cc9c72695a8896e5f33d51bf03dc3eef94d510',
        //     '6c93a40eb070f296059c45bdde94c2ecd8c0a0c1aa8f54086f451aa06e2f910d',
        //     '121212'
        // ];

        // if(!in_array($token, $allowToken)) {
        //     return response()->json([
        //                         'message' => 'Your token is not valid',
        //                         'status' => 'Unauthorized'
        //                     ], 200);
        // }


        if(!ClientToken::where('token', $token)->exists()) {
            return response()->json([
                                'message' => 'Your token is not valid',
                                'status' => 'Unauthorized'
                            ], 200);
        }

        return $next($request);
    }
}
