<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OdManualDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'station_id' => $this->station_id,
            'station_name' => $this->Station->station_name,
            'date' => $this->dis_dt->format('d/m/Y'),
            'discharge' => $this->obs_discharge_value,
        ];

    }
}
