<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OsdManualDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'station_id' => $this->station_id,
            'station_name' => $this->Station->station_name,
            'date' => $this->sed_dt->format('d/m/Y'),
            'sussanddis' => $this->sand_kg . ' (Field)',
            'measurement_unit_of_sussanddis' => 'kg/sec',
            'finedis' => $this->max_sand_conc,
            'measurement_unit_of_finedis' => 'ppm',
            'maxsandconc' => $this->fine_kg . ' (RRI)',
            'measurement_unit_of_maxsandconc' => 'kg/sec',
        ];

    }
}
