<?php
namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class RainfallStationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     *
     */

    //  {

    //     "id": 60,
    //     "name": "Amalshid",
    //     "basin": "Meghna Basin",
    //     "division": "Sylhet",
    //     "district": "Sylhet",
    //     "upazilla": "Zakiganj",
    //     "union": "Bara Thakuri",
    //     "lat": "24.869149",
    //     "long": "92.475560",
    //     "status": 1,
    //     "unit": "mm"

    // }

    public function toArray(Request $request): array
    {
        return [
            'id_db' => $this->ffwc_sl_no,
            'station_id' => $this->station_id,
            "sms_id" => $this->ffwc_keyword,
            'name' => $this->ffwc_station_name,
            'basin' => $this->ffwc_basin,
            'division' => $this->ffwc_sub_measure_div,
            'district' => $this->district_name,
            'upazilla' => $this->upzl_name,
            'union' => $this->union_name,
            'lat' => $this->latitude,
            'long' => $this->longitude,
            // 'forecast observation' => '',
            // 'diterministic forecast station' => '',
            'medium_range_station' => '',
            'status' => 1,
            'measurement_unit' => 'mm',
        ];
    }
}
