<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class RfManualDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'station_id' => $this->station_id,
            'station_name' => $this->station_name,
            'date' => $this->rf_date->format('d/m/Y'),
            'rain_fall' => $this->rain_fall,
            'measurement_unit' => 'mm',
        ];

    }
}
