<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SwByTypeManualStation extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     *
     */

    public function toArray(Request $request): array
    {
        $returnData = [
            'station_id' => $this->station_id,
            'station_name' => $this->station_name,
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,
        ];

        if ($request->has('data_type') && $request->data_type == 'wl') {
            $returnData['tidal_status'] = $this->tidal_sts == 'T' ? 'Tidal' : 'Non-Tidal';
        }

        return $returnData;

    }
}
