<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SwManualStation extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     *
     */

    public function toArray(Request $request): array
    {
        return [
            'station_id' => $this->station_id,
            'station_name' => $this->station_name,
            'river_name' => $this->river_name,
            'upzilla_name' => $this->upzl_name,
            'district_name' => $this->district_name,
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,
            'danger_level' => $this->danger_level,
            'tidal_status' => $this->tidal_sts == 'T' ? 'Tidal' : 'Non-Tidal',
        ];
    }
}
