<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SwStationManualResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
                'station_id' => $this->Station->station_id,
                'station_name' => $this->Station->station_name,
                'river_name' => $this->Station->river_name,
                'datetime' => $this->swl_date->format('Y-m-d H:i:s'),
                'danger_level' => $this->Station->danger_level,
                'longitude' => $this->Station->longitude,
                'latitude' => $this->Station->latitude,
                'data_type' => $this->dataType($this->data_type),
                'value' => $this->wl,
            ];
    }

    public function dataType($type)
    {
        if($type == 'L') {
            return 'Low';
        } elseif($type == 'H') {
            return 'High';
        } else {
            return 'Regular';
        }
    }
}
