<?php

namespace App\Pages\Himsapi\Datatable;

use App\Models\ClientApiLog;
use App\Traits\WithSweetAlert;
use Illuminate\Database\Eloquent\Builder;

use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Columns\LinkColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\DateRangeFilter;
use Rappasoft\LaravelLivewireTables\Views\Columns\ButtonGroupColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberRangeFilter;


class ApiLogTable extends DataTableComponent
{
    use WithSweetAlert;

    // protected $model = ClientApiLog::class;

    protected $index = 0;
    public function builder(): Builder
    {
        return ClientApiLog::query(); // Select some things
    }
    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setSearchThrottle(1000);
        $this->setFilterLayoutSlideDown();  
        $this->setTheadAttributes([
            'default' => true,
            'class' => '',
            'style' => 'background-color:#c1dfff;',
          ]);    
        

    }

    public function filters(): array
    {

        return [

            DateRangeFilter::make('Verified Period'),
            NumberFilter::make('Amount')

            ->config([
                'min' => 0,
                'max' => 10,
            ])

            ->filter(function (Builder $builder, string $value) {

                $builder->where('id', '<', $value);

            }),
            NumberRangeFilter::make('Success Rate')

            ->options(
                [
                    'min' => 0,
                    'max' => 100,
                ]
            )

            ->config([
                'minRange' => 0,
                'maxRange' => 100,
                'suffix' => 'TK',
            ])

            ->filter(function (Builder $builder, array $values) {
                $builder->where('id', '>=', intval($values['min']))
                ->where('id', '<=', intval($values['max']));
            }),

        ];

    }

    public function columns(): array
    {
        return [
            Column::make("Id", "id")->format(fn () => ++$this->index +  ($this->getPage() - 1) * $this->perPage),
            Column::make("Client Name", "client.name")->sortable()->searchable(),
            Column::make("Client Email", "client.email")->sortable()->searchable(),
            Column::make("Collection Name", "collection.title")->sortable()->searchable(),
            
            Column::make("Request Ip", "request_ip")->sortable()->searchable(),
            // Column::make("Request type", "request_type")->sortable()->searchable(),
            Column::make("Request at", "request_at")->sortable()->searchable(),
            Column::make("Response at", "response_at")->sortable()->searchable(),
            // Column::make("FTP Id", "api_client_ftp_id")->sortable()->searchable(),
            // Column::make("FTP upload requestat", "ftp_upload_request_at")->sortable()->searchable(),
            // Column::make("FTP upload response at", "ftp_upload_response_at")->sortable()->searchable(),
            Column::make("Status", "status")
            ->format(
                fn ($value, $row, Column $column) => view('components.option-view', ['status' => 'api_log_status','value' => $value])
            )->sortable()->searchable(),
           
        ];
    }
}
