<?php

namespace App\Pages\Himsapi\Datatable;

use App\Models\Client;
use App\Traits\WithSweetAlert;
use Illuminate\Database\Eloquent\Builder;

use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Columns\LinkColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\DateRangeFilter;
use Rappasoft\LaravelLivewireTables\Views\Columns\ButtonGroupColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberRangeFilter;

class BwdbFileShareTable extends DataTableComponent
{
    use WithSweetAlert;

    // protected $model = Client::class;
    protected $index = 0;
    public function builder(): Builder
    {
        return Client::query(); // Select some things
    }

    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setSearchThrottle(1000);
        $this->setFilterLayoutSlideDown();
        $this->setTheadAttributes([
            'default' => true,
            'class' => '',
            'style' => 'background-color:#c1dfff;',
          ]);
      


    }

    public function columns(): array
    {
        return [
            Column::make("Id", "id")->format(fn() => ++$this->index +  ($this->getPage() - 1) * $this->perPage),
            Column::make("UUID", "uuid")->sortable()->searchable(),
            Column::make("Name", "name")->sortable()->searchable(),
            Column::make("Office Name", "office_name")->sortable(),
            Column::make("Address", "address")->sortable()->searchable(),
            Column::make("Phone", "name")->sortable()->searchable(),
            Column::make("Email", "email")->sortable()->searchable(),
            Column::make("Is API Access", "is_api_access")->sortable()->searchable(),
            Column::make("Status", "status")->sortable()->searchable(),

            ButtonGroupColumn::make("Actions")
                ->buttons([
                    LinkColumn::make('Edit')
                        ->title(fn($row) => 'Edit')
                        ->location(fn($row) => 'javascript:void(0)')
                        ->attributes(function ($row) {
                            return [
                                'data-id' => $row->id,
                                'data-listener' => 'addClientModal',
                                'class' => 'badge bg-success me-1 p-2 ',
                                'icon' => 'fa fa-edit',
                                'title' => 'Edit',

                            ];
                        }),
                    LinkColumn::make(' Delete')
                        ->title(fn($row) => 'Delete')
                        ->location(fn($row) => 'javascript:void(0)')
                        ->attributes(function ($row) {
                            return [
                                'data-id' => $row->id,
                                'data-listener' => 'clientDelete',
                                'class' => 'badge bg-danger me-1 p-2 ',
                                'icon' => 'fa fa-trash',
                                'title' => 'Delete',

                            ];
                        }),
                        LinkColumn::make('API Setup')
                        ->title(fn($row) => 'API Setup')
                        ->location(fn($row) => route('backend.api_setup', ['id' => $row->id]))
                        ->attributes(function ($row) {
                            return [
                                'data-id' => $row->id,
                                'data-listener' => 'clientApiSetup',
                                'wire:navigate' => '',
                                'class' => 'badge bg-warning me-1 p-2 ',
                                'icon' => 'fa fa-cogs',
                                'title' => 'API Setup',

                            ];
                        }),
                ]),

        ];
    }
}
