<?php

namespace App\Pages;

use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\DateRangeFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberRangeFilter;

class UserTable extends DataTableComponent
{
    protected $model = User::class;
    protected $index = 0;

    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setSearchThrottle(1000);
        $this->setFilterLayoutSlideDown();
       

    }

    public function filters(): array
    {

        return [

            DateRangeFilter::make('Verified Period'),
            NumberFilter::make('Amount')

            ->config([
                'min' => 0,
                'max' => 10,
            ])

            ->filter(function (Builder $builder, string $value) {

                $builder->where('id', '<', $value);

            }),
            NumberRangeFilter::make('Success Rate')

            ->options(
                [
                    'min' => 0,
                    'max' => 100,
                ]
            )

            ->config([
                'minRange' => 0,
                'maxRange' => 100,
                'suffix' => 'TK',
            ])

            ->filter(function (Builder $builder, array $values) {
                $builder->where('id', '>=', intval($values['min']))
                ->where('id', '<=', intval($values['max']));
            }),

        ];

    }

    public function columns(): array
    {
        return [
            Column::make("Id", "id")->format(fn () => ++$this->index +  ($this->getPage() - 1) * $this->perPage),
            Column::make("Name", "name")
                ->sortable()->searchable(),
            Column::make("Email", "email")
                ->sortable(),
            Column::make("Created at", "created_at")
                ->sortable(),
            Column::make("Updated at", "updated_at")
                ->sortable(),
        ];
    }
}
