<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bmdais_data', function (Blueprint $table) {
            $table->id();
            $table->string('data_hour')->nullable();
            $table->string('data_type')->nullable();
            $table->string('value')->nullable();
            $table->date('data_date')->nullable();
            $table->string('station_no')->nullable();
            $table->timestamp('last_updated_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bmdais_data');
    }
};
