<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bmdais_metadata', function (Blueprint $table) {
            $table->id();
            $table->string('station_name')->nullable();
            $table->string('division')->nullable();
            $table->string('district')->nullable();
            $table->string('station_type')->nullable();
            $table->string('station_no')->nullable();
            $table->double('latitude')->nullable();
            $table->double('longitude')->nullable();
            $table->timestamp('last_updated_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bmdais_metadata');
    }
};
