<?php

namespace Database\Seeders;

use App\Models\Collection;
use Illuminate\Database\Seeder;

class CollectionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $DataList = [
            [
                'id' => 1,
                'title' => 'Ground Water API JSON',
                'des' => 'Ground Water API JSON v1.0',
                'request_url' => 'api/v1/package-c15/gw/auto/json ',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '5',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 2,
                'title' => 'Ground Water API CSV',
                'des' => 'Ground Water API JSON v1.0',
                'request_url' => 'api/v1/package-c15/gw/auto/csv',
                'response_type' => '2',
                'request_type' => '3',
                'request_limit' => '5',
                'is_ftp' => 1,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 3,
                'title' => 'Surface Water API JSON',
                'des' => 'Surface Water APIv1.0',
                'request_url' => 'api/v1/package-c15/sw/auto/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '5',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 4,
                'title' => 'Surface Water API CSV',
                'des' => 'Surface water api v1.0',
                'request_url' => 'api/v1/package-c15/sw/auto/csv',
                'response_type' => '2',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => 1,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 5,
                'title' => 'Waterlevel Station API Json',
                'des' => 'Waterlevel Station api v1.0',
                'request_url' => 'api/v1/package-c15/wl-station/auto/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 6,
                'title' => 'Rainfall Station API Json',
                'des' => 'Rainfall Station api v1.0',
                'request_url' => 'api/v1/package-c15/rf-station/auto/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 7,
                'title' => 'Waterlevel Data API Json',
                'des' => 'Waterlevel Data api v1.0',
                'request_url' => 'api/v1/package-c15/wl-data/auto/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 8,
                'title' => 'Rainfall Data API Json',
                'des' => 'Rainfall Data api v1.0',
                'request_url' => 'api/v1/package-c15/rf-data/auto/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 9,
                'title' => 'Rainfall Auto Data API Json',
                'des' => 'Rainfall Data api v1.0',
                'request_url' => 'api/v1/package-c15/arf-data/auto/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 10,
                'title' => 'Waterlevel Auto Data API Json',
                'des' => 'Waterlevel Data api v1.0',
                'request_url' => 'api/v1/package-c15/awl-data/auto/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 11,
                'title' => 'Weather Auto Data API Json',
                'des' => 'Waterlevel Data api v1.0',
                'request_url' => 'api/v1/package-c15/wa-data/auto/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 12,
                'title' => 'Surface Water Manual API CSV',
                'des' => 'Surface water Manual api v1.0',
                'request_url' => '/api/v1/package-c15/sw-manual/manual/csv ',
                'response_type' => '2',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => 1,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 13,
                'title' => 'Surface Water Station Manual API Json',
                'des' => 'Surface water Station Manual api v1.0',
                'request_url' => '/api/v1/package-c15/sw-station/manual/json ',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 14,
                'title' => 'Surface Water Level Data Manual API Json',
                'des' => 'Surface water level Data Manual api v1.0',
                'request_url' => '/api/v1/package-c15/swl-data/manual/json ',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 15,
                'title' => 'Surface Water Information By Data Type API Json',
                'des' => 'Surface water Information By Data Manual api v1.0',
                'request_url' => '/api/v1/package-c15/sw-station-by-type/manual/json ',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 16,
                'title' => 'Rainfall Data Manual API Json',
                'des' => 'Rainfall Data Manual api v1.0',
                'request_url' => 'api/v1/package-c15/rf-m-data/manual/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 17,
                'title' => 'Observed Discharge Data Manual API Json',
                'des' => 'Observed Discharge Data Manual api v1.0',
                'request_url' => 'api/v1/package-c15/od-m-data/manual/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 18,
                'title' => 'Cross Section Data Manual API Json',
                'des' => 'Cross Section Data Manual api v1.0',
                'request_url' => 'api/v1/package-c15/cs-m-data/manual/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
            [
                'id' => 19,
                'title' => 'Observed Sediment Data Manual API Json',
                'des' => 'Observed Sediment Data Manual api v1.0',
                'request_url' => 'api/v1/package-c15/osd-m-data/manual/json',
                'response_type' => '1',
                'request_type' => '3',
                'request_limit' => '10',
                'is_ftp' => null,
                'status' => '1',
                // 'data_type' => NULL,
            ],
        ];

        foreach ($DataList as $key => $value) {
            if (!Collection::where('id', $value['id'])->exists()) {
                Collection::create($value);
            }
        }
    }
}
