<div>
    <x-slot name="header">Collection Parameter List</x-slot>
    <x-layouts.backend.container>

        <x-layouts.backend.card>
            <x-slot name="card_header">
                <button class="btn btn-info me-2">
                    <a href="{{ route('backend.api_collection') }}" wire:navigate class="text-white">
                        <span class="fa fa-reply"></span>
                        <b>Back to API List</b>
                    </a>
                </button>
                <x-button.success x-data @click="$dispatch('callEventFunc',{callName:'addParameterModal'})" class="btn"
                    icon="fa fa-plus"> Add Parameter
                </x-button.success>
            </x-slot>
            <livewire:himsapi.datatable.collection-parameter-list-table :collection_id="$collection_id" />
        </x-layouts.backend.card>
    </x-layouts.backend.container>

    <x-modal id="addParameterModal" size="lg"
        title="{{ $collection_parameter_id ? 'Update' : 'Add' }}  Client Information ">

        <div class="row">
            <div class="col-lg-6">
                <x-input.text wire:model.blur="label" label="Label" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model="name" label="Name" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model="placeholder" label="Placeholder" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.select wire:model.change="type" label="Type" require="true" :options="config('status.api_collection_parameters_type')" />
            </div>
            <div class="col-lg-6">
                <x-input.number wire:model="sort" label="Sorting" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model="default_value" label="Default Value" />
            </div>
            <div class="col-lg-12 {{ $type == 2 ? '' : 'd-none' }}">
                <x-input.text wire:model="options" label="Options" />
            </div>
            <div class="col-lg-12">
                <x-input.checkbox wire:model="is_required" label="Is Required" />
            </div>
            <div class="col-lg-6">
                <x-input.select wire:model="status" label="Status" require="true" :options="config('status.common')" />
            </div>

        </div>
        <x-slot name="footer">
            <x-button.success wire:click="collectionParameterStore" wire:target='collectionParameterStore'
                class="btn-sm" icon="fa fa-check">
                Save
            </x-button.success>
        </x-slot>
    </x-modal>
</div>
