# Contributing to OracleTableLinker

Thank you for considering contributing to the OracleTableLinker package! Your contributions help improve the package and assist other users in the community.

## How to Contribute

1. **Fork the Repository**: Create a personal fork of the repository on GitHub.
2. **Clone Your Fork**: Clone the repository to your local machine using:

    ```bash
    git clone https://github.com/your-username/oracle-table-linker.git
    ```

3. **Create a Branch**: Create a new branch for your changes:

    ```bash
    git checkout -b feature/your-feature
    ```

4. **Make Changes**: Implement your changes or new features. Be sure to add tests for your changes if applicable.

5. **Commit Changes**: Commit your changes with a descriptive commit message:

    ```bash
    git add .
    git commit -m "Add feature XYZ"
    ```

6. **Push Your Branch**: Push your branch to your forked repository:

    ```bash
    git push origin feature/your-feature
    ```

7. **Submit a Pull Request**: Navigate to the original repository on GitHub and submit a pull request from your fork.

## Code of Conduct

Please adhere to our [Code of Conduct](code-of-conduct.md) to ensure a welcoming and inclusive environment for all contributors.

## To-Do List

-   Review and test the current code.
-   Add documentation and examples for new features.
-   Address issues reported by users.

Thank you for contributing!
