<?php
session_start();
include("../../../php_crud/my_class.php");
$obj = new my_class();

error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

require_once('../../../asset/custom/PHPExcel_class/PHPExcel.php');
require_once('../../../asset/custom/PHPExcel_class/PHPExcel/Calculation.php');
require_once('../../../asset/custom/PHPExcel_class/PHPExcel/Cell.php');

extract($_POST);

// Unlink All file from this directory
/*$files = glob('Excel_Sheet/*'); // get all file names
foreach($files as $file){ // iterate files
  if(is_file($file))
    unlink($file); // delete file
}*/

/////

//
if (is_file('Excel_Sheet/Section_'.ucwords($section_name).'_'.$section_id.'_Attendance.xlsx')) unlink('Excel_Sheet/Section_'.ucwords($section_name).'_'.$section_id.'_Attendance.xlsx');


$styleTitleArray = array(
    'font' => array(
        'bold' => true,
        'color' => array('rgb' => '000000'),
        'size' => 11
        // 'name'  => 'Verdana'
    ));

$stylesubTitleArray = array(
    'font' => array(
        'bold' => true,
        'color' => array('rgb' => '000000'),
        'size' => 10
        //  'name'  => 'Verdana'
    ));

$title = 'Class: ' . ucwords($class_name) . ', Department: ' . ucwords($department_name) . ', Student Type: ' . ucwords($student_type_name) . ', Section: ' . ucwords($section_name) . '';

$objPHPExcel = new PHPExcel();


$sheet = $objPHPExcel->getActiveSheet();

// For Page Title
$sheet->setCellValueByColumnAndRow(0, 1, $title);
$sheet->mergeCells('A1:F2');
$sheet->getStyle('A1:F2')->applyFromArray($styleTitleArray)
    ->getAlignment()
    ->applyFromArray(array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,))
    ->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

// For Content Column Title
$sheet->getStyle('A3:F3')->applyFromArray($stylesubTitleArray);
// write header
$sheet->getCell('A3')->setValue('Serial');
$sheet->getCell('B3')->setValue('Id');
$sheet->getCell('C3')->setValue('Name');
$sheet->getCell('D3')->setValue('Roll');
$sheet->getCell('E3')->setValue('Attendance Status');
$sheet->getCell('F3')->setValue('Late Time( Minute)');


/* $data = array(
            array('name' => 'A', 'mail' => 'a@gmail.com', 'age' => 43, 'age' => 43, 'age' => 43),
            array('name' => 'C', 'mail' => 'c@gmail.com', 'age' => 24, 'age' => 43, 'age' => 43),
        );*/


// Main work
$data = array();
if ($section_id) {
    $all_st = $obj->sudents_details_by_section($section_id);

    //print_r($all_st);
    $i = 1;
    foreach ($all_st as $index => $val) {
        $data[] = array(
            'Serial' => $i++,
            'Unique Id' => $val->_uniq_id,
            'Name' => $val->_full_name,
            'Roll' => $val->_section_roll,
            'Attendance Status' => '',
            'Late Time' => '');

    }


}


// Format cell width According to content
$cellIterator = $sheet->getRowIterator()->current()->getCellIterator();
$cellIterator->setIterateOnlyExistingCells(true);
/** @var PHPExcel_Cell $cell */
foreach ($cellIterator as $cell) {
    $sheet->getColumnDimension($cell->getColumn())->setAutoSize(true);
}

// Autosize on manual single cell
// Set AutoSize for name and email fields
//$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
//$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);


// Fill worksheet from values in array
$objPHPExcel->getActiveSheet()->fromArray($data, null, 'A4');
$rows = count($data)+5;


// Formating Left Alignment for printing, cell A4 to last, B4 to last and D4 to last 
$objPHPExcel->getActiveSheet()->getStyle('A4:A'.$rows)
                 ->getAlignment()
    			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);  
				
$objPHPExcel->getActiveSheet()->getStyle('B4:B'.$rows)
                 ->getAlignment()
    			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);  

$objPHPExcel->getActiveSheet()->getStyle('D4:D'.$rows)
                 ->getAlignment()
    			->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);  								
				
// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Section ' . ucwords($section_name));







// Save Excel 2007 file
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

$objWriter->save('Excel_Sheet/Section_'.ucwords($section_name).'_'.$section_id.'_Attendance.xlsx');

echo 'Section_'.ucwords($section_name).'_'.$section_id.'_Attendance.xlsx' ;

?>