<?php
ini_set('display_startup_errors', TRUE);
session_start();
include("../../asset/theme/css/myfunc.php");
include("../../php_crud/my_class.php");
$obj = new my_class();
extract($_GET);
//echo "Station: $sel_station_id, Time Period: $sel_time_period";
$sel_year_arr = explode('-',$sel_time_period);
$sel_year = $sel_year_arr[1];

$date_for_mon = "01-$sel_time_period";	
$month_name = date('F', strtotime($date_for_mon));
$well_info_tbls = "AQUATIC.TBLGWH_BASICINFOMST@aquatic227 BASIC_INFO LEFT JOIN AQUATIC.TBLGWH_DIVISIONINFO@aquatic227 DIV_INFO ON BASIC_INFO.DIVISIONCODE=DIV_INFO.ID
LEFT JOIN AQUATIC.TBLGWH_SUBDIVISIONINFO@aquatic227 SUB_DIV_INFO ON BASIC_INFO.SUBDIVISIONCODE=SUB_DIV_INFO.ID 
LEFT JOIN AQUATIC.TBLGWH_DISTRICTINFO@aquatic227 DIST_INFO ON BASIC_INFO.DISTRICTCODE = DIST_INFO.ID LEFT JOIN AQUATIC.TBLGWH_UPAZILA@aquatic227 UPAZILA_INFO ON BASIC_INFO.UPAZILACODE=UPAZILA_INFO.ID";
	$well_info_cols = "NEW_ID,OLD_ID,STATIONNAME,DISTRICTNAME,UPAZILANAME,LATITUDE,LONGITUDE";
	$well_info_cond = "BASIC_INFO.NEW_ID='$sel_well_id'";
$gw_well_info = $obj->View_column_details_By_Cond($well_info_tbls,$well_info_cols,$well_info_cond);

$new_id = $gw_well_info['NEW_ID'];
$old_id = $gw_well_info['OLD_ID'];
$location = $gw_well_info['STATIONNAME'];
$district = $gw_well_info['DISTRICTNAME'];
$upazila = $gw_well_info['UPAZILANAME'];
$latitude = number_format((float)$gw_well_info['LATITUDE'], 5, '.', '');
$longitude = number_format((float)$gw_well_info['LONGITUDE'], 5, '.', '');

if (file_exists('../../asset/custom/upload/water_table_auto_manu_'.$sel_well_id.'_'.$sel_time_period.'.xlsx')) {
        unlink('../../asset/custom/upload/water_table_auto_manu_'.$sel_well_id.'_'.$sel_time_period.'.xlsx');
}

require_once('../../asset/custom/PHPExcel_class/PHPExcel.php');
require_once('../../asset/custom/PHPExcel_class/PHPExcel/Calculation.php');
require_once('../../asset/custom/PHPExcel_class/PHPExcel/Cell.php');

$filename = '../../asset/custom/upload/water_table_auto_manu_'.$sel_well_id.'_'.$sel_time_period.'.xlsx';

try {
    $objPHPExcel = new PHPExcel();
	$objPHPExcel->getProperties()->setCreator("MokNathal")
                ->setLastModifiedBy("MokNathal")
                ->setTitle("STAFF REPORT")
                ->setSubject("STAFF REPORT")
                ->setDescription("STAFF REPORT")
                ->setKeywords("STAFF REPORT")
                ->setCategory("STAFF REPORT");
	$styleArray = array(
		'font'  => array(
			'bold'  => true,
			'color' => array('rgb' => 'FF0000')
		),
		'fill' => array(
			'type' => PHPExcel_Style_Fill::FILL_SOLID,
			'color' => array('rgb' => 'FFFF00')
		)
	);
	
	//heading start
    $objPHPExcel->getActiveSheet()->mergeCells('A1:J6');
	$objPHPExcel->getActiveSheet()->getStyle('A1:J6')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A1')->setValue( "Bangladesh Water Development Board \n Processing and Flood Forecasting Circle\n 72-Green Road, Dhaka-1215, Bangladesh\nPhone: +88-02-58151530\nEmail   : se.pffc@bwdb.gov.bd\nWeb      :  www.hydrology.bwdb.gov.bd");
	$objPHPExcel->getActiveSheet()->getStyle('A1:J6')->getAlignment()->setWrapText(true);

	$objPHPExcel->getActiveSheet()->mergeCells('A7:J7');
	$objPHPExcel->getActiveSheet()->getStyle('A7:J7')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A7')->setValue( "Ground Water Table Automated and Manual Data Comparison Report");
	$objPHPExcel->getActiveSheet()->getStyle('A7:J7')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A7')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('A8:J8');
	$objPHPExcel->getActiveSheet()->getStyle('A8:J8')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	//$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station: ".$rf_well_info['STATION_ID']."(".$rf_well_info['STATION_NAME'].")");
	$objPHPExcel->getActiveSheet()->getStyle('A8:J8')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Well: ".$old_id."(".$new_id.")");
	$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A9')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
	$objPHPExcel->getActiveSheet()->getStyle('D9:G9')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	//$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station: ".$rf_well_info['STATION_ID']."(".$rf_well_info['STATION_NAME'].")");
	$objPHPExcel->getActiveSheet()->getStyle('D9:G9')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('H9:J9');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('H9')->setValue("Time Period: ".$month_name.', '.$sel_year);
	$objPHPExcel->getActiveSheet()->getStyle('H9:J9')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('H9')->getFont()->setBold(true);

	$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue("Location: ".$location);
	$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A10')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('D10:G10');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue("District: ".$district);
	$objPHPExcel->getActiveSheet()->getStyle('D10:G10')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('D10')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('H10:J10');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('H10')->setValue("Upazila: ".$upazila);
	$objPHPExcel->getActiveSheet()->getStyle('H10:J10')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('H10')->getFont()->setBold(true);
	//headiing end	
	
	$objPHPExcel->getActiveSheet()->mergeCells('A11:I11');
	$objPHPExcel->getActiveSheet()->getStyle('A11:I11')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	//$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station: ".$rf_well_info['STATION_ID']."(".$rf_well_info['STATION_NAME'].")");
	$objPHPExcel->getActiveSheet()->getStyle('A11:I11')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('A12:A13');
	$objPHPExcel->getActiveSheet()->getStyle('A12:A13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A12')->setValue("Sl");
	$objPHPExcel->getActiveSheet()->getStyle('A12:A13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A12')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('B12:B13');
	$objPHPExcel->getActiveSheet()->getStyle('B12:B13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('B12')->setValue("New Well ID");
	$objPHPExcel->getActiveSheet()->getStyle('B12:B13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('B12')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('C12:C13');
	$objPHPExcel->getActiveSheet()->getStyle('C12:C13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('C12')->setValue("Old Well ID");
	$objPHPExcel->getActiveSheet()->getStyle('C12:C13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('C12')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('D12:D13');
	$objPHPExcel->getActiveSheet()->getStyle('D12:D13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('D12')->setValue("Location");
	$objPHPExcel->getActiveSheet()->getStyle('D12:D13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('D12')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('E12:E13');
	$objPHPExcel->getActiveSheet()->getStyle('E12:E13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('E12')->setValue("Latitude");
	$objPHPExcel->getActiveSheet()->getStyle('E12:E13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('E12')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('E12')->getNumberFormat()->setFormatCode('#,##0.00000');
	
	$objPHPExcel->getActiveSheet()->mergeCells('F12:F13');
	$objPHPExcel->getActiveSheet()->getStyle('F12:F13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('F12')->setValue("Longtitude");
	$objPHPExcel->getActiveSheet()->getStyle('F12:F13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('F12')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('F12')->getNumberFormat()->setFormatCode('#,##0.00000');
	
	$objPHPExcel->getActiveSheet()->mergeCells('G12:G13');
	$objPHPExcel->getActiveSheet()->getStyle('G12:G13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('G12')->setValue("Date");
	$objPHPExcel->getActiveSheet()->getStyle('G12:G13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('G12')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('G12')->getNumberFormat()->setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_DATE_DATETIME);
	
	$objPHPExcel->getActiveSheet()->mergeCells('H12:J12');
	$objPHPExcel->getActiveSheet()->getStyle('H12:J12')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('H12')->setValue("Rainfall (mm)");
	$objPHPExcel->getActiveSheet()->getStyle('H12:J12')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('H12')->getFont()->setBold(true);
	
	$objPHPExcel->getActiveSheet()->getStyle('H13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('H13')->setValue("Automated");
	$objPHPExcel->getActiveSheet()->getStyle('H13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('H13')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('H13')->getNumberFormat()->setFormatCode('#,##0.000');
	
	$objPHPExcel->getActiveSheet()->getStyle('I13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('I13')->setValue("Manual");
	$objPHPExcel->getActiveSheet()->getStyle('I13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('I13')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('I13')->getNumberFormat()->setFormatCode('#,##0.000');
	
	$objPHPExcel->getActiveSheet()->getStyle('J13')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
	$objPHPExcel->setActiveSheetIndex(0)->getCell('J13')->setValue("Difference(Auto-Manu)");
	$objPHPExcel->getActiveSheet()->getStyle('J13')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('J13')->getFont()->setBold(true);
	$objPHPExcel->getActiveSheet()->getStyle('J13')->getNumberFormat()->setFormatCode('#,##0.000');
	
	$sl=0;
	$row_num = 14;
	foreach($obj->gw_wl_auto_manual_data_list($sel_well_id,$sel_time_period) as $gw_am_data_list){
		$sl++;
		
		$changed_date = date("d-m-Y H:i:s", strtotime($gw_am_data_list['TIMESTAMP']));
		$date_time_arr = explode(" ", $changed_date);
		$date_arr = explode("-", $date_time_arr[0]);
		$time_arr = explode(":", $date_time_arr[1]);
		$day = $date_arr[0];
		$mon = $date_arr[1];
		$year = $date_arr[2];
		
		$hours = $time_arr[0];
		$mins = $time_arr[1];
		$sec = $time_arr[2];
		$show_date = PHPExcel_Shared_Date::FormattedPHPToExcel($year, $mon, $day, $hours, $mins, $sec);
		

		$show_auto_data = "";
		$show_manu_data = "";
		$show_data_diff = "";
		if($gw_am_data_list['AUTO_DATA']!=""){
			$show_auto_data = number_format((float)$gw_am_data_list['AUTO_DATA'], 3, '.', '');
		}
		else{
			$show_auto_data = "-";
		}
		if($gw_am_data_list['MANUAL_DATA']!=""){
			$show_manu_data = number_format((float)$gw_am_data_list['MANUAL_DATA'], 3, '.', '');
		}
		else{
			$show_manu_data = "-";
		}
		if($gw_am_data_list['AUTO_DATA']!="" && $gw_am_data_list['MANUAL_DATA']!=""){
			$show_data_diff = $gw_am_data_list['AUTO_DATA'] - $gw_am_data_list['MANUAL_DATA'];
			$show_data_diff = number_format((float)$show_data_diff, 3, '.', '');
		}
		else{
			$show_data_diff = "-";
		}
		
		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('A'.$row_num, $sl)
			->setCellValue('B'.$row_num, $new_id)
			->setCellValue('C'.$row_num, $old_id)
			->setCellValue('D'.$row_num, $location)
			->setCellValue('E'.$row_num, $latitude)
			->setCellValue('F'.$row_num, $longitude)
			->setCellValue('G'.$row_num, $show_date)
			->setCellValue('H'.$row_num, $show_auto_data)
			->setCellValue('I'.$row_num, $show_manu_data)
			->setCellValue('J'.$row_num, $show_data_diff);
		
		$objPHPExcel->getActiveSheet()->getStyle('G'.$row_num)->getNumberFormat()->
			setFormatCode(PHPExcel_Style_NumberFormat::FORMAT_DATE_DATETIME);
		$objPHPExcel->getActiveSheet()->getStyle('E'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00000');
		$objPHPExcel->getActiveSheet()->getStyle('F'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00000');
		$objPHPExcel->getActiveSheet()->getStyle('H'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00');
		$objPHPExcel->getActiveSheet()->getStyle('I'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00');
		$objPHPExcel->getActiveSheet()->getStyle('J'.$row_num)->getNumberFormat()->setFormatCode('#,##0.00');

		$row_num++;
	}
	
	 
	foreach (range('A1', 'J1') as $columnID) {
			$objPHPExcel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
	}
	$objPHPExcel->getActiveSheet()->setTitle('wt_auto_manu_data');
	$objPHPExcel->setActiveSheetIndex(0);
	ob_clean();

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('../../asset/custom/upload/water_table_auto_manu_'.$sel_well_id.'_'.$sel_time_period.'.xlsx');
        header('Location: ../../asset/custom/upload/water_table_auto_manu_'.$sel_well_id.'_'.$sel_time_period.'.xlsx');
} catch (Exception $e) {
        echo 'Caught exception: ', $e->getMessage(), "\n";
}
?>