$(document).ready(function(){
	load_district_table();
});

function load_district_table(){
	//$('#division_list_holder').load('module/ground_water/division_datatbl.php');
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/district_datatbl.php",
		success:function(st){
			$('#cover-spin').hide();
			$('#district_list_holder').html(st);
		}
	});
}


function load_district_form(){
	$("#modal_body_add_district").load("module/ground_water/district_add_form.php");
}

function load_sub_div(sel_div_id){
	//alert('load_sub_div');
	var datastr = "sel_div_id="+sel_div_id;
	//alert(datastr);
	$('#sub_div_list_holder').load('module/ground_water/sub_div_list_by_div.php',datastr);
}

function e_load_sub_div(sel_div_id){
	var datastr = "sel_div_id="+sel_div_id;
	//alert(datastr);
	$('#e_sub_div_list_holder').load('module/ground_water/sub_div_list_by_div.php',datastr);
}
function save_district(){
	var operation = "insert";
	
	var division_code = $("#division_code").val();
	var sub_division_code = $("#sub_division_code").val();
	var district_code = $("#district_code").val();
	var district_name = $("#district_name").val();
	var dataStr = "division_code="+division_code+"&sub_division_code="+sub_division_code+"&district_code="+district_code+"&district_name="+district_name+"&operation="+operation;
	
	if(division_code==""){
		toastr.error("Please Select Division");
		$("#division_code").focus();
		return false;
	}
	else if(sub_division_code==""){
		toastr.error("Please Select Sub Division");
		$("#sub_division_code").focus();
		return false;
	}
	else if(district_code==""){
		toastr.error("Please mention District Code");
		$("#district_code").focus();
		return false;
	}
	else if(district_name==""){
		toastr.error("Please mention District Name");
		$("#district_name").focus();
		return false;
	}
	else {
		//alert(dataStr);
		$('#cover-spin').show();
		$.ajax({
			type:"post",
			url:"module/ground_water/district_crud.php",
			data:dataStr,
			cache:false,
			success:function(st){
				$('#cover-spin').hide();
				//alert(st);
				if(st=="1") {
					toastr.success('District Information Successfully Saved.');
					$('#modal_add_district').modal('hide');
					load_district_table();
					
					//$('#districtEntryForm')[0].reset();
				}else{
					toastr.error('Failed to Save District. Please Try Again');
				}
			}
		});
	}
}

function load_district_edit_form(sel_id){
	var datastr = "sel_id="+sel_id;
	//alert(datastr);
	$('#district_edit_body').load('module/ground_water/district_edit_form.php',datastr);
}

function update_district_info(){
	var operation = "update";
	var e_sel_id = $("#e_sel_id").val();
	var e_division_code = $("#e_division_code").val();
	var sub_division_code = $("#sub_division_code").val();
	var e_district_code = $("#e_district_code").val();
	var e_district_name = $("#e_district_name").val();
	
	var dataStr = "operation="+operation+"&e_sel_id="+e_sel_id+"&e_division_code="+e_division_code+
	"&sub_division_code="+sub_division_code+"&e_district_code="+e_district_code+
	"&e_district_name="+e_district_name;
	
	if(e_division_code==""){
		toastr.error("Please Select Division");
		$("#e_division_code").focus();
		return false;
	}
	else if(sub_division_code==""){
		toastr.error("Please Select Sub Division");
		$("#sub_division_code").focus();
		return false;
	}
	else if(e_district_code==""){
		toastr.error("Please mention District Code");
		$("#e_district_code").focus();
		return false;
	}
	else if(e_district_name==""){
		toastr.error("Please mention District Name");
		$("#e_district_name").focus();
		return false;
	}
	else {
		//alert(dataStr);
		$('#cover-spin').show();
		$.ajax({
			type:"post",
			url:"module/ground_water/district_crud.php",
			data:dataStr,
			cache:false,
			success:function(st){
				$('#cover-spin').hide();
				//alert(st);
				if(st=="1") {
					toastr.success('District Information Successfully Saved.');
					load_district_table();
					$('#district_edit_modal').modal('hide');
				}else{
					toastr.error('Failed to Save District. Please Try Again');
				}
			}
		});
	}
}

function delete_district(sel_id){
	var operation = "delete";
	var datastr = "operation="+operation+"&sel_id="+sel_id;
	//alert(datastr);
	var result = confirm("Are you sure you want to delete the data?");
	if (!result) {
		
	} 
	else {
		$('#cover-spin').show();
		$.ajax({			
			type:"post" ,
			url:"module/ground_water/district_crud.php",
			data:datastr,
			success:function(st){
				//alert(st);
				$('#cover-spin').hide();
				if(st!==1){
					toastr.success("District has been deleted successfully");
					load_district_table();
				}
				else{
					toastr.error("Error occurred during deleting district");
				}
			}
		});
	}
}