function load_equipment_failure_form(){
	$("#equipment_failure_form_data").load("module/ground_water/equipment_failure_form.php");
	$("#equipment_failure_datatable").hide();
}

function load_equipment_failure_list(){
	$("#equipment_failure_datatable").load("module/ground_water/equipment_failure_datatable.php");
}

function load_device_info(){
	//alert('load_device_info');
	$("#device_list_body").load("module/ground_water/device_list_for_maintenance.php");
}

function load_edit_form(id){
	var datastr = "id="+id;
	$("#equipment_failure_form_data").load("module/ground_water/equipment_failure_form.php",datastr);
	$("#equipment_failure_datatable").hide();
}

function set_device_info(sel_device_id){
	var p_dev_sl_no = $("#p_dev_sl_no_"+sel_device_id).val();
	var p_new_id = $("#p_new_id_"+sel_device_id).val();
	var p_old_id = $("#p_old_id_"+sel_device_id).val();
	var p_dist_name = $("#p_dist_name_"+sel_device_id).val();
	var p_upa_name = $("#p_upa_name_"+sel_device_id).val();
	
	$("#pick_no").val(sel_device_id);
	$("#device_sl_no").val(p_dev_sl_no);
	$("#new_id").val(p_new_id);
	$("#old_id").val(p_old_id);
	$("#upazila").val(p_upa_name);
	$("#district").val(p_dist_name);
	
	$('#modal_device_list').modal('hide');
}

function save_equipment_failure(){
	var device_name = $("#device_name").val();
	var operation = "insert";
	
	form = 'equipmentFailureForm';
	var dataStr = $('#'+form).serialize();
	dataStr = dataStr+"&operation="+operation;
	//alert(dataStr);
	if(device_name=="") {
		toastr.error("Device Must Be Selected");
		$("#device_name").focus();
		return false;
	} else {
		$.ajax({
			type:"post" ,
			// url:"login_check.php" ,
			url:"module/ground_water/equipment_failure_crud.php" ,
			data:dataStr ,
			cache:false ,
			success:function(st){
				if(st=="1") {
					toastr.success('Equipment Failure Information Successfully Saved.');
					$("#zone_datatable").load("module/ground_water/equipment_failure_datatable.php");
				}else{
					toastr.error('Failed to Save Equipment Failure. Please Try Again');
				}
			}
		});	
	}
}

function update_equipment_failure(id){
	var device_name = $("#device_name").val();
	var operation = "update";
	form = 'equipmentFailureForm';
	var dataStr = $('#'+form).serialize();
	dataStr = dataStr+"&id="+id+"&operation="+operation;
	//alert(dataStr);
	if(device_name=="") {
		toastr.error("Device Must Be Selected");
		$("#device_name").focus();
		return false;
	} else {
		$.ajax({
			type:"post" ,
		   //	url:"login_check.php" ,
		   url:"module/ground_water/equipment_failure_crud.php" ,
			data:dataStr ,
			cache:false ,
			success:function(st){
				if(st=="1") {
					toastr.success('Equipment Failure Information Successfully Updated.');
					$("#zone_datatable").load("module/ground_water/equipment_failure_datatable.php");
				}else{
					toastr.error('Failed to Update Equipment Failure. Please Try Again');
				}
			}
		});	
	}
}


function delete_zone(id){
	var zone_name = $("#zone_name").val();
	var operation = "delete";
	var dataStr = "id="+id+"&operation="+operation;
	//alert(dataStr);
	var result = confirm("Are you sure you want to delete data?");
	if (!result) {
		
	} else {
		$.ajax({
			type:"post" ,
		   //	url:"login_check.php" ,
		   url:"module/ground_water/zone_crud.php" ,
			data:dataStr ,
			cache:false ,
			success:function(st){
				if(st=="1") {
					toastr.success('Zone Information Successfully Deleted.');
					$("#zone_datatable").load("module/ground_water/zone_datatable.php");
				}else{
					toastr.error('Failed to Delete Zone. Please Try Again');
				}
			}
		});	
	}
}