function load_station_list(){
	$("#station_search_form").load("module/ground_water/station_search_form");
	$("#station_datatable").load("module/ground_water/station_list.php");
}

function load_station_form(){
	$("#station_form_data").load("module/ground_water/station_form.php");
}

function load_station_edit_form(id){
	var datastr = "id="+id;
	$("#edit_station_form_data").load("module/ground_water/station_edit_form.php",datastr);
}

function load_sub_div(sel_div_id){
	var form_type = "entry";
	var datastr = "form_type="+form_type+"&sel_div_id="+sel_div_id;
	//alert(datastr);
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/load_sub_list_for_upazila.php",
		data:datastr,
		success:function(st){
			$('#cover-spin').hide();
			$('#sub_div_code_holder').html(st);
		}
	});
	
}

function search_station(){
	var search_key = $("#search_keyword").val();
	if ($("#device_sl_no").prop("checked")){
		var datastr = "device_sl_no="+search_key;
	} else if($("#new_id").prop("checked")){
		var datastr = "new_id="+search_key;
	} else if($("#old_id").prop("checked")){
		var datastr = "old_id="+search_key;
	}
	//alert(datastr);
	$("#station_datatable").load("module/ground_water/station_list.php",datastr);
}



function e_load_sub_div(sel_div_id){
	var form_type = "edit";
	var datastr = "form_type="+form_type+"&sel_div_id="+sel_div_id;
	//alert(datastr);
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/load_sub_list_for_upazila.php",
		data:datastr,
		success:function(st){
			$('#cover-spin').hide();
			$('#e_sub_div_code_holder').html(st);
		}
	});
	
}

function load_dist_list_by_sub_div(sel_sub_div_id){
	var form_type = "entry";
	var datastr = "form_type="+form_type+"&sel_sub_div_id="+sel_sub_div_id;
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/load_dist_list_for_upazila.php",
		data:datastr,
		success:function(st){
			$('#cover-spin').hide();
			$('#sub_dist_code_holder').html(st);
		}
	});
}

function e_load_dist_list_by_sub_div(sel_sub_div_id){
	var form_type = "edit";
	var datastr = "form_type="+form_type+"&sel_sub_div_id="+sel_sub_div_id;
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/load_dist_list_for_upazila.php",
		data:datastr,
		success:function(st){
			$('#cover-spin').hide();
			$('#e_sub_dist_code_holder').html(st);
		}
	});
}

function load_upz_list_by_dist(sel_dist_id){
	var form_type = "entry";
	var datastr = "form_type="+form_type+"&sel_dist_id="+sel_dist_id;
	$('#cover-spin').show();
	$.ajax({			
		url:"module/ground_water/load_upz_list_for_district.php",
		data:datastr,
		success:function(st){
			$('#cover-spin').hide();
			$('#upz_code_holder').html(st);
		}
	});
}

function save_station(){
	var new_id = $("#new_station_id").val();
	alert(new_id);
	var operation = "insert";
	form = 'stationForm';
	var dataStr = $('#'+form).serialize();
	dataStr = dataStr+"&operation="+operation;
	//alert(dataStr);
	
	$.ajax({
		type:"post" ,
		// url:"login_check.php" ,
		url:"module/ground_water/station_crud.php" ,
		data:dataStr ,
		cache:false ,
		success:function(st){
			if(st=="Success") {
				toastr.success('Station Information Successfully Saved.');
				$("#station_datatable").load("module/ground_water/station_list.php");
			}else{
				toastr.error('Failed to Save Station. Please Try Again');
			}
		}
	});	
}

function update_station(){
	var new_id = $('#e_new_id').val();
	var operation = "update";
	form = 'stationEditForm';
	var dataStr = $('#'+form).serialize();
	dataStr = dataStr+"&operation="+operation;
	//alert(dataStr);
	if(new_id=="") {
		toastr.error("Station Id Cannot Be Blank");
		$("#e_new_id").focus();
		return false;
	} else {
		$.ajax({
			type:"post" ,
			// url:"login_check.php" ,
			url:"module/ground_water/station_crud.php" ,
			data:dataStr ,
			cache:false ,
			success:function(st){
				if(st=="Success") {
					toastr.success('Station Information Successfully Updated.');
					$("#station_datatable").load("module/ground_water/station_list.php");
				}else{
					toastr.error('Failed to Update Station. Please Try Again');
				}
			}
		});	
	}
}