<?php
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	session_start();
	extract($_REQUEST);
	if($division_id!=""){
		$table_name = "HYDROLOGY.DIVCODE_TBL@HYDRO10";
		$where_cond = "DIVISION_NAME IS NOT NULL ORDER BY DIVISION_NAME ASC";
		$division_info = $obj->Details_By_Cond($table_name,"ID = '$division_id'");
		$label = "Ground Water Data Availability Record of Division: ".$division_info['DIVISIONNAME'];
	} else if($sub_division_id!=""){
		$sub_division_info = $obj->Details_By_Cond("HYDROLOGY.SUBDIVCODE_TBL@HYDRO10"," HYDSUBDIVCODE='$sub_division_id'");
		$label = "Surface Water Data Availability Record of Sub Division: ".$sub_division_info['SUBDIVISION_NAME'];
	} else if($station_id!=""){
		// $district_info = $obj->Details_By_Cond("AQUATIC.TBLGWH_DISTRICTINFO@aquatic227","ID = '$district_id'");
		if ($station_id == "1") {
			$stat_type = "Water Level";
		}
		elseif ($station_id == "2") {
			$stat_type = "Rainfall";
		}
		elseif ($station_id == "3"){
			$stat_type = "(Water Level & Rainfall)";
		}
		$label = "Surface Water Data Availability Record of Station Type: ".$stat_type;
	} else {
		$label = "Surface Water Data Availability Record Summary (All Data)";
	}  
	//echo "1";
?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.8.1/css/all.css" rel="stylesheet" media="all" type="text/css" />
<div class="table-header">
	<i class="icon-list"></i> <?php echo $label; ?>
</div>
<table id="surface_water_tbl" class="table table-striped table-bordered table-hover">
    <thead>
        <tr style="font-family: 'Open Sans';">
			<td style="text-align: center;font-size:13px;" class="table-header">Sl</td>
            <td style="text-align: center;font-size:13px;" class="table-header">Station ID</td>
			<td style="text-align: center;font-size:13px;" class="table-header">Station Name</td>
			
			<td style="text-align: center;font-size:13px;" class="table-header">District</td>
			<td style="text-align: center;font-size:13px;" class="table-header">Upazila</td>
            <td style="text-align: center;font-size:13px;" class="table-header">River Name</td>
			<!--<td style="text-align: center;font-size:13px;" class="table-header">Subdivision Name</td>
			 <td style="text-align: center;font-size:13px;" class="table-header">Division Name</td> -->
			<td style="text-align: center;font-size:13px;" class="table-header">Lattitude</td>
			<td style="text-align: center;font-size:13px;" class="table-header">Longitude</td>
			<td style="text-align: center;font-size:13px;" class="table-header">From Date</td>
			
			<td style="text-align: center;font-size:13px;" class="table-header">To Date</td>
			<td style="text-align: center;font-size:13px;" class="table-header">Action</td>
        </tr>
    </thead>
    <tbody>
		<?php
			//echo $table_name =  "TBLGWH_BASICINFOMST ST INNER JOIN TBLGWH_GWHDATADTL GWT ON GWT.STATIONID = ST.NEW_ID LEFT JOIN TBLGWH_DISTRICTINFO DT ON ST.DISTRICTCODE=DT.ID LEFT JOIN TBLGWH_UPAZILA UPZ ON ST.UPAZILACODE = UPZ.ID";
			if($inactive_option!=""){
				if($inactive_option==2){
					$and = "DIFF_HOURS<=72 AND DIFF_HOURS>=24";
				} else if($inactive_option==1) {
					$and = "DIFF_HOURS>72";
				} else if($inactive_option==3) {
					$and = "DIFF_HOURS<24";
				} else if($inactive_option==4) {
					//echo $inactive_days;
					//echo "<br/>";
					$diff_hours_input = $inactive_days * 24;
					$and = "DIFF_HOURS>$diff_hours_input";
					//echo "<br/>";
				} else if($inactive_option==0) {
					$and = "LASTRECEIVEDATE IS NOT NULL";
				}
			} else {
				$and = "LASTRECEIVEDATE IS NOT NULL";
			}
			if($division_id!=""){				
				//$where_cond = "ST.NEW_ID IS NOT NULL AND ST.DIVISIONCODE='$division_id' AND GWT.DATETIME BETWEEN TO_DATE('$from_date','DD-MM-YYYY') AND TO_DATE('$to_date','DD-MM-YYYY') GROUP BY ST.NEW_ID,ST.OLD_ID,DT.DISTRICTNAME, UPZ.UPAZILANAME,ST.LATITUDE,ST.LONGITUDE";
				$where_cond = "DIVISIONCODE='$division_id' AND $and";
				
			} else if($sub_division_id!=""){
				$where_cond = "SUBDIVISIONCODE='$sub_division_id' AND $and";
			} else if($district_id!=""){
				$where_cond = "DISTRICTCODE='$district_id' AND $and";
			} else {
				$where_cond = "$and";
			}
			if($inactive_option!=""){
				if($inactive_option==2){
					$and = "DIFF_HOURS<=72 AND DIFF_HOURS>=24";
					$where_cond = $where_cond." ORDER BY DISTRICTCODE ASC, LASTRECEIVEDATE DESC";
				} else if($inactive_option==1) {
					$and = "DIFF_HOURS>72";
					$where_cond = $where_cond." ORDER BY DISTRICTCODE ASC, LASTRECEIVEDATE DESC";
				} else if($inactive_option==3) {
					$and = "DIFF_HOURS<24";
					$where_cond = $where_cond." ORDER BY DISTRICTCODE ASC, LASTRECEIVEDATE DESC";
				} else if($inactive_option==4) {
					//echo $inactive_days;
					//echo "<br/>";
					$diff_hours_input = $inactive_days * 24;
					$and = "DIFF_HOURS>$diff_hours_input";
					//echo "<br/>";
					$where_cond = $where_cond." ORDER BY DISTRICTCODE ASC, LASTRECEIVEDATE DESC";
				} else if($inactive_option==0) {
					$where_cond = $where_cond." ORDER BY LASTRECEIVEDATE DESC";
				}
			} else {
				$where_cond = "DATA_READ_TYPE='BOTH' ORDER BY STATION_ID ASC,STATION_NAME ASC";
				//echo $where_cond;
			}

			if ($sub_division_id != "") {
				$where_cond = "DATA_READ_TYPE='BOTH' AND HYDSUBDIVCODE='$sub_division_id' ORDER BY STATION_ID ASC,STATION_NAME ASC";
			}
			elseif($station_id != ""){
				if ($station_id == "1") {
					$where_cond = "DATA_READ_TYPE='BOTH' AND (','||STATION_TYPE||','LIKE'%,'||'1'||',%') ORDER BY STATION_ID ASC";
				}
				elseif ($station_id == "2") {
					$where_cond = "DATA_READ_TYPE='BOTH' AND (','||STATION_TYPE||','LIKE'%,'||'2'||',%') ORDER BY STATION_ID ASC";
				}
				elseif ($station_id == "3") {
					$where_cond = "DATA_READ_TYPE='BOTH' AND (','||STATION_TYPE||','LIKE'%,'||'1'||',%' OR ','||STATION_TYPE||','LIKE'%,'||'2'||',%') ORDER BY STATION_ID ASC";
				}
			}else{
				$where_cond = "DATA_READ_TYPE='BOTH' ORDER BY DISTRICT_NAME ASC, UPZL_NAME ASC, STATION_NAME ASC";
			}
			
			$row=$obj->View_colmn_By_Cond("SW_STATION_AUTO_MANUAL","*",$where_cond);
			
			$i = 1;
			foreach($row AS $index=>$val){
				$from_date = "";
				$to_date = "";
				if(strpos($val['STATION_TYPE'], '1') === 0) { 
					$awl_max_min_dt = $obj->show_awl_max_min_dt($val['STATION_ID']);
					$from_date_arr = explode(" ",$awl_max_min_dt['MIN_DT']);
					$from_date = $from_date_arr[0];
					$to_date_arr = explode(" ",$awl_max_min_dt['MAX_DT']);
					$to_date = $to_date_arr[0];
				}
				else if(strpos($val['STATION_TYPE'], '2') === 0){
					$arf_max_min_dt = $obj->show_arf_max_min_dt($val['STATION_ID']);
					$from_date_arr = explode(" ",$arf_max_min_dt['MIN_DT']);
					$from_date = $from_date_arr[0];
					$to_date_arr = explode(" ",$arf_max_min_dt['MAX_DT']);
					$to_date = $to_date_arr[0];
				}
				else{
					$from_date = "---";
					$to_date = "---";
				}
				$color_status = "";
				if($val['DIFF_HOURS']>72){
					$color_status = "color: #ff3300;";
				} else if($val['DIFF_HOURS']<=72 && $val['DIFF_HOURS']>24){
					$color_status = "color: #000080;";
				} else if($val['DIFF_HOURS']<=24 ){
					$color_status = "color: #228B22;";
				} ?>
					<tr>
						<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?>"><?php echo $i;?></td>
						<td style="font-size: 14px; text-align: left; padding-left: 10px; <?php echo $color_status; ?>"><?php echo $val['STATION_ID'];?></td>
						<td style="font-size: 14px; text-align: left; padding-left: 10px; <?php echo $color_status; ?>"><?php echo $val['STATION_NAME'];?></td>
						<td style="font-size: 14px; text-align: left; padding-left: 10px; <?php echo $color_status; ?>"><?php echo $val['DISTRICT_NAME'];?></td>
						<td style="font-size: 14px; text-align: left; padding-left: 10px; <?php echo $color_status; ?>"><?php echo $val['UPZL_NAME'];?></td>
						<td style="font-size: 14px; text-align: left; padding-left: 10px; <?php echo $color_status; ?>"><?php echo $val['RIVER_NAME'];?></td>
						<!-- <td style="font-size: 14px; text-align: center; <?php echo $color_status; ?>"><?php echo $val['SUBDIVISION_NAME'];?></td>
						<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?>"><?php echo $val['DIVISION_NAME'];?></td> -->
						<td style="font-size: 14px; text-align: left; padding-left: 10px; <?php echo $color_status; ?>"><?php echo round($val['LATITUDE'],5);?></td>
						<td style="font-size: 14px; text-align: left; padding-left: 10px; <?php echo $color_status; ?>"><?php echo round($val['LONGITUDE'],5);?></td>					
						<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?>"><?php echo $from_date;?></td>
						<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?>"><?php echo $to_date;?></td> 
						<td style="font-size: 14px; text-align: center; <?php echo $color_status; ?>">
							<a class="label label-primary btn btn-small " onclick="show_graph('<?php echo $val['STATION_ID'];?>')"><i class="icon-bar-chart"></i> Show Graph</a> 
						</td>
					</tr>
					<?php           

				$i++;
			}
		?>
    </tbody>
</table>
<script type="text/javascript">			
	var oTable2 = $('#surface_water_tbl').dataTable( {
	"aoColumns": [
	  { "bSortable": true },
	  null,null,null, null,null,null, null,null,null,
	  { "bSortable": true }
	],
	"iDisplayLength": 50,
	"sDom": '<"top"'+
				'<"col-md-12"'+
					'<"col-md-4"<"pull-left"l>>'+
					'<"col-md-4"<"text-center"i>>'+
					'<"col-md-4"<"pull-right"f>>'+
				'>'+
			'>'+
			't'+
			'<"bottom"'+				
				'<"col-md-12"'+
					'<"col-md-6"<"pull-left"i>>'+
					'<"col-md-6"<"pull-right"p>>'+
				'>'+
			'>'
	} );
</script>
