<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
extract($_POST);

$res = array();

// Convert year strings to integers for iteration
$from_year = intval($from_year);
$to_year = intval($to_year);

// Iterate through each year in the range
for ($year = $from_year; $year <= $to_year; $year++) {
    // Formulate the condition for each year
    $cond = "WELL_ID='$well_id' AND TO_CHAR(DT, 'YYYY')='$year' ORDER BY DT ASC";

    $yearly_data = array();

    foreach ($obj->View_colmn_By_Cond("HYDROLOGY.GWT_DATA_TBL@HYDRO10", "DT, WATER_LVL", $cond) as $gw_weekly_info) {
        $sel_date = $gw_weekly_info['DT'];
        $sel_wt_data = $gw_weekly_info['WATER_LVL'];

        // Extract only day and month from the date
        $dayMonth = date_create_from_format('d-M-y', $sel_date)->format('d-M');

        // Ensure that $sel_wt_data is explicitly set to null if it's not available
        $sel_wt_data = ($sel_wt_data !== null && $sel_wt_data !== '') ? "$sel_wt_data" : null;

        $yearly_data[] = array("$dayMonth", $sel_wt_data);
    }

    // If no data for the year, add an entry with null values
    if (count($yearly_data) == 0) {
        $yearly_data[] = array(null, null);
    }

    $res["$year"] = $yearly_data;
}


// Extract all unique dates from all years
$allDates = array_unique(array_reduce($res, function ($carry, $yearlyData) {
    return array_merge($carry, array_column($yearlyData, 0));
}, array()));

// Update each year's array with missing dates and sort by day and month
foreach ($res as $year => &$yearlyData) {
    $datesInYear = array_map(function ($item) {
        return $item[0];
    }, $yearlyData);

    // Find missing dates
    $missingDates = array_diff($allDates, $datesInYear);

    // Add missing dates with null RL values
    foreach ($missingDates as $missingDate) {
        $yearlyData[] = array($missingDate, null);
    }

    // Sort the year array by day and month
    usort($yearlyData, function ($a, $b) {
        $dateA = DateTime::createFromFormat('d-M', $a[0]);
        $dateB = DateTime::createFromFormat('d-M', $b[0]);
        return $dateA <=> $dateB;
    });
}

if (count($res) > 0) {
    echo $datas = json_encode($res);
} else {
    // If no data for the entire range, add an entry with null values
    $res["$from_year"] = array(array(null, null));
    echo $datas = json_encode($res);
}
