//load_river_name_by_station_id
function load_river_name_by_station_id(sel_river_id){
	var station_arr = sel_river_id.split("#");
	var station_id = station_arr[1];
	var river_code = station_arr[0];
    var datastr ="sel_river_id="+river_code+"&station_id="+station_id;
//	alert(datastr);
	$('#view_td_data').html("");
	$('#td_discharge_curve_chart').html("");
	$.ajax({
		url: 'module/ground_water_ex/river_name_by_station_id.php', 
		type: 'get',
		data: datastr,
		cache: false,
		success: function(data) {
			var values = data.split("#");
            $("#river_name").val(values[0]);
            $("#station_name_holder").val(values[1]);
		}
	});
}
//excel load river name by station id
function load_river_name_by_station_id_excel(sel_river_id){
	var station_arr = sel_river_id.split("#");
	var station_id = station_arr[1];
	var river_code = station_arr[0];
    var datastr ="sel_river_id="+river_code+"&station_id="+station_id;
	//alert(datastr);
	$('#view_td_data').html("");
	$('#td_discharge_curve_chart').html("");
	$.ajax({
		url: 'module/ground_water_ex/river_name_by_station_id.php', 
		type: 'get',
		data: datastr,
		cache: false,
		success: function(data) {
			var values = data.split("#");
            $("#river_name_1").val(values[0]);
            $("#station_1_name_holder").val(values[1]);
		}
	});
}
function flushData() {
	$('#view_td_data').html("");
	$('#td_discharge_curve_chart').html("");
}

function loadDeForm(){
	$('#view_td_data').html("");
	$('#td_discharge_curve_chart').html("");
	$('#tde_station').val('');
	$('#river_name').val('');
	$('#act_tab_name').val('data_entry');
	$('.nav-tabs a[href="#list_of_data"]').tab('show');
}

function loadExcelData(){
//	alert('loadDeForm');
	$('#view_td_data').html("");
	$('#td_discharge_curve_chart').html("");
	$('#tex_station').val('');
	$('#river_name_1').val('');
	$('#act_tab_name').val('data_upload');
	$('.nav-tabs a[href="#list_of_data"]').tab('show');
}

function load_tidal_discharge_info(show_mode){
    var station = $('#tde_station').val();
	var station_arr = station.split("#");
	var station_id = station_arr[1];
	var river_code = station_arr[0];

    var river_name =$('#river_name').val();
   
    var year =$('#td_year').val();
    var month =$('#td_month').val();
    var datastr ="show_mode"+show_mode+"&station="+station_id+"&river_name="+river_name
	+"&year="+year+"&month="+month;
    //alert(datastr);
	
    $('#cover-spin').show(0);
    $.ajax({
        url:"module/ground_water_ex/tidal_discharge_entry_datatable.php",
        datatype:'get',
        data: datastr,
        success:function(data){
        //alert(data);
        $('#cover-spin').hide();
		//for hidden save all
		//$("#td_save_btn").css({"display":"block"});
        $("#view_td_data").html(data);
		$('#date_1').select();
		
        }
    });  
}
//for multi save
function td_multiple_save(){
  // alert('td_multiple_save');
	var act_tab_name = $("#act_tab_name").val();
	if(act_tab_name=='data_entry'){
		var station = $("#tde_station").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		var river_code = station_arr[0];
	}
	else{
		var station = $("#tex_station").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		var river_code = station_arr[0];
	}
	//var tot_row = $("#tot_row").val();
	//alert(tot_row);
	var table = document.getElementById("td_dis_data_table");
	var tbodyRowCount = table.tBodies[0].rows.length;
	//alert(tbodyRowCount);
	$('#cover-spin').show(0);
	var sel_day = 1;
	while(sel_day <= tbodyRowCount){
		// var date = $('#date_'+sel_day).val(); 
		var date =  encodeURIComponent($('#date_'+sel_day).val());
		//alert( date );
		var wl = $('#wl_'+sel_day).val();
		var ww = $('#ww_'+sel_day).val();
		var area = $('#area_'+sel_day).val();
		var discharge = $('#dischrg_'+sel_day).val();
		var vmax = $('#vmax_'+sel_day).val();
		var vmean = $('#vmean_'+sel_day).val();
		var note = $('#note_'+sel_day).val();
		var operation = "single_row_save";
	    var datastr = "sel_date="+date+"&station_id="+station_id+"&wl="+wl+"&ww="+ww+"&area="+area+"&discharge="+discharge+"&vmax="+vmax+"&vmean="+vmean+"&note="+note+"&operation="+operation;
	   //alert(datastr);
		$.ajax({
			url: 'module/ground_water_ex/tidal_discharge_entry_from_ajax.php', 
			type: 'post',
			data: datastr,
			cache: false,
			success: function(result) {
				//alert(result);
				if(result==1){
					//alert('Data has been saved successfully');
				}
				else{
					alert(result);
				}
			}
		});
		sel_day++;
	}
	alert('Data has been saved successfully');
	$('#cover-spin').hide();

}
//single save
function save_single_td_discharge_info(sel_day,press_op) {
	var act_tab_name = $("#act_tab_name").val();
	if(act_tab_name=='data_entry'){
		var station = $("#tde_station").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		var river_code = station_arr[0];
	}
	else{
		var station = $("#tex_station").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		var river_code = station_arr[0];
	}
	
	// var date = $('#date_'+sel_day).val(); 
	var date =  encodeURIComponent($('#date_'+sel_day).val());
	if(!date){
		alert('Please Select Date');
	}else{
	var wl = $('#wl_'+sel_day).val();
	var ww = $('#ww_'+sel_day).val();
	var area = $('#area_'+sel_day).val();
	var discharge = $('#dischrg_'+sel_day).val();
	var vmax = $('#vmax_'+sel_day).val();
	var vmean = $('#vmean_'+sel_day).val();
	var note = $('#note_'+sel_day).val();
	var operation = "single_row_save";
	var datastr = "sel_date="+date+"&station_id="+station_id+"&wl="+wl+"&ww="+ww+"&area="+area+"&discharge="+discharge+"&vmax="+vmax+"&vmean="+vmean+"&note="+note+"&operation="+operation;
	//alert(datastr);
	$.ajax({
		url: 'module/ground_water_ex/tidal_discharge_entry_from_ajax.php', 
		type: 'post',
		data: datastr,
		cache: false,
		success: function(result) {
			//alert(result);
			if(result==1){
				if(press_op=="btn_click"){
				alert('Data has been saved successfully');
				}
				var tot_row = $("#tot_row").val();
				if(sel_day== tot_row){
					load_new_row();
				}
			}
		}
	});
}
}

						
					
//for graph
function load_td_graph(){
	//alert('load_td_graph');
	var year = $('#td_year').val();
	var month = $('#td_month').val();
	var act_tab_name = $("#act_tab_name").val();
	if(act_tab_name=='data_entry'){
		var station = $("#tde_station").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		var station_name = $('#station_name_holder').val();
	}
	else{
		var station = $("#tex_station").val();
		var station_arr = station.split("#");
		var station_id = station_arr[1];
		var station_name = $('#station_1_name_holder').val();
	}
	
	//alert(year);
	var graph_datastr = "station_id="+station_id+"&year="+year+"&month="+month;
	// alert(graph_datastr);
	$('#cover-spin').show(0);
	$.ajax({
		type:"post",
		url:"module/ground_water_ex/tidal_discharge_graph.php",
		data:graph_datastr,
		success:function(str){
			//alert(str);
			if($.trim(str)){
				//$('#cover-spin').hide();
				var my_2d = $.parseJSON(str);
				//alert(my_2d);
				google.charts.load('current',{packages:['corechart']});
				google.charts.setOnLoadCallback(drawChart);
				function drawChart(){
					//alert('drawChart');
					var data=new google.visualization.DataTable();
					data.addColumn('string','Date');
					data.addColumn('number','Tidal Discharge');
					for(i=0;i<my_2d.length;i++)
						data.addRow([my_2d[i][0],parseFloat(my_2d[i][1]),]);
					var options = {
						title: 'Tidal Discharge Table Information for '+station_id+' ('+station_name+')',
						curveType: 'function',
						pointSize: 5,
						pointShape: 'circle',
						width: 1700,
						height: 500,
						legend: { position: 'bottom' },
						animation: {
						  'startup': true,
						  duration: 5000,
						  easing: 'out',
						},
						hAxis: {
							title: 'Dates'
						},
						vAxis: {
						  title: 'Tidal Discharge (m3/s)',
						  viewWindow: {
							min: data.getColumnRange(1) , 
							max: data.getColumnRange(1),
						  },
						  format: '0.00',
						  gridlines: {
							count: 20
						  }
						}
					  };
					
					var chart=new
					google.visualization.LineChart(document.getElementById('td_discharge_curve_chart'))
					chart.draw(data,options);
					$('#cover-spin').hide();
				}
			}
		}
	});
}
//delete
function delete_tidal_data(id){
	//alert('delete_tidal_data');
	var operation = 'delete';
	var station = $("#tde_station").val();
	var date = $("#date_"+id).val();
	var station_arr = station.split("#");
	var station_id = station_arr[1];
	//alert(station_id);
	datastr = "sel_date="+date+"&station_id="+station_id+"&operation="+operation;
	//alert(datastr);
	if(confirm('Are you sure you want to delete the selected row?')){
	$.ajax({
		url: 'module/ground_water_ex/tidal_discharge_entry_from_ajax.php', 
		type:'post',
		data:datastr,
		success:function(str){
			//alert(str);
			if(str==1){
				alert("Data has been deleted successfully"); 
			}else{
				alert('Fail to delete data');
			}
			load_tidal_discharge_info();
		}
	});
}
}

// function load(){
//   $('#view_td_data').load('module/ground_water_ex/tidal_discharge_entry_datatable.php');
// }

