<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
extract($_REQUEST);

$user_id = $_SESSION['LOGIN_USERID'];
$date = strtoupper(date('d-M-y H:i:s'));
$file = $_FILES['upload_excel']['name'];

$get_depth = $obj->Details_By_Cond("HYDROLOGY.BLPUMP_TBL@HYDRO10", "WELL_ID='$well_id'");
$total_depth_meters = $get_depth['DEPTH'];
$total_depth_feet = round($total_depth_meters * 3.28084);

// Calculate number of rows needed, each row representing 10 feet
$num_rows = ceil($total_depth_feet / 10);

$dir = '../../asset/custom/upload/';
$excel_file = $dir . $file;

if (!file_exists($dir) || !is_writable($dir)) {
    die("Directory does not exist or is not writable.");
}

if (file_exists($excel_file)) {
    unlink($excel_file);
}

if (!move_uploaded_file($_FILES['upload_excel']['tmp_name'], $excel_file)) {
    die("File upload error.");
}

require_once('../../asset/custom/PHPExcel_class/PHPExcel.php');
require_once('../../asset/custom/PHPExcel_class/PHPExcel/IOFactory.php');

try {
    $inputFileType = PHPExcel_IOFactory::identify($excel_file);
    $objReader = PHPExcel_IOFactory::createReader($inputFileType);
    $objPHPExcel = $objReader->load($excel_file);
} catch (Exception $e) {
    die('Error loading file "' . pathinfo($excel_file, PATHINFO_BASENAME) . '": ' . $e->getMessage());
}

$sheet = $objPHPExcel->getSheet(0);
$highestRow = $sheet->getHighestRow();
$highestColumn = 'C';  // Specify the highest column if it is constant

$data = [];

for ($row = 2; $row <= $highestRow; $row++) {
    $row_data = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
    $thickness = $row_data[0][0];
    $color = $row_data[0][1];
    $lithology = $row_data[0][2];
    $data[] = ['thickness' => $thickness, 'color' => $color, 'lithology' => $lithology];
}

// Ensure that $num_rows, $total_depth_meters, and $excel_lithology_flag are defined
// $num_rows = count($data); // Assuming num_rows is the number of data rows
// $total_depth_meters = $num_rows * 3.04878; // Example value
$excel_lithology_flag = 1; // Example value

$table = '<div><label for="upload_excel">
<h5 style="text-align: center; background-color: #ddd; padding: 5px 0px; font-weight: 700; font-size: 20px;">Excel Data Show</h5>
</label></div>
<table id="litho_data_table" class="table table-bordered table-striped" style="width:100%; margin-top:20px">
    <div class="row-fluid" style="margin-bottom:5px;">
        <div class="control-group" style="float:right;">
            <div class="controls">
                <button id="litho_sva_btn" type="button" style="margin-right: 1px; font-size: 12px;" class="btn btn-small btn-success" onclick="lithology_excel_data_save()"><i class="icon-save"></i><b>Save All</b></button>
            </div>
        </div>
    </div>
    <thead>
        <tr>
            <td style="text-align: center; font-size:13px; width: 5%; background-color:#307ECC; vertical-align:middle;" class="table-header" rowspan="2">Sample No</td>
            <td style="text-align: center; font-size:13px; width: 14%; background-color:#307ECC;" class="table-header" colspan="2">Depth (ft)</td>
            <td style="text-align: center; font-size:13px; width: 14%; background-color:#307ECC;" class="table-header" colspan="2">Depth (m)</td>
            <td style="text-align: center; font-size:13px; width: 7%; background-color:#307ECC; vertical-align:middle;" class="table-header" rowspan="2">Thickness (m)</td>
            <td style="text-align: center; font-size:13px; width: 20%; background-color:#307ECC; vertical-align:middle;" class="table-header" rowspan="2">Color</td>
            <td style="text-align: center; font-size:13px; width: 40%; background-color:#307ECC; vertical-align:middle;" class="table-header" rowspan="2">Lithology</td>
        </tr>
        <tr>
            <td style="text-align: center; font-size:13px; background-color:#307ECC; width: 7%;" class="table-header">From</td>
            <td style="text-align: center; font-size:13px; background-color:#307ECC; width: 7%;" class="table-header">To</td>
            <td style="text-align: center; font-size:13px; background-color:#307ECC; width: 7%;" class="table-header">From</td>
            <td style="text-align: center; font-size:13px; background-color:#307ECC; width: 7%;" class="table-header">To</td>
        </tr>
    </thead>
    <tbody id="litho_tbl_body">
        <span><input type="hidden" id="excel_well_id" value="' . $well_id . '"></span>
        <span><input type="hidden" id="excel_well_purpose_id" value="' . $well_purpose_id . '"></span>
        <span><input type="hidden" id="excel_pump_test_id" value="' . $pump_test_id . '"></span>
        <span><input type="hidden" id="excel_well_observation_id" value="' . $observation_id . '"></span>';

for ($i = 0; $i < $num_rows; $i++) {
    $from_m = number_format(($i * 3.04878), 3);
    $to_m = number_format(min(($i + 1) * 3.04878, $total_depth_meters), 3);

    // Convert from meters to feet with precision
    $from_ft = round($from_m * 3.280);
    $to_ft = round($to_m * 3.280);

    $thickness_id = "thickness_$i";
    $color_id = "color_$i";
    $m_q_id = "m_q_$i";

    $table .= '<tr>
                <td style="text-align: center; font-size:13px;">' . ($i + 1) . '</td>
                <td style="text-align: center; font-size:13px;">' . $from_ft . '</td>
                <td style="text-align: center; font-size:13px;">' . $to_ft . '</td>
                <td style="text-align: center; font-size:13px;">
                    <span><input type="hidden" id="excel_lithology_flag" value="' . $excel_lithology_flag . '">' . $from_m . '</span>
                </td>
                <td style="text-align: center; font-size:13px;" class="">
                    <span><input type="hidden" style="width: 80%;" class="excel_lithology_depth" value="' . $to_m . '">' . $to_m . '</span>
                </td>
                <td style="text-align: center;">
                    <input type="text" style="width: 85%; margin: 0px 5px 0px 5px" id="' . $thickness_id . '" class="excel_lithology_thickness" onkeypress="return isNumericInput(event)" value="' . $data[$i]['thickness'] . '" />
                </td>
                <td style="text-align: left;">
                    <input type="text" style="width: 95%; margin: 0px 5px 0px 5px" id="' . $color_id . '" class="excel_lithology_color" value="' . $data[$i]['color'] . '" />
                </td>
                <td style="text-align: left;">
                    <input type="text" style="width: 97%; margin: 0px 5px 0px 5px" id="' . $m_q_id . '" class="excel_lithology_material" value="' . $data[$i]['lithology'] . '" />
                </td>
            </tr>';
}

$table .= '</tbody>
</table>
<div class="row-fluid" style="margin-bottom:5px;">
    <div class="control-group" style="float:right;">
        <div class="controls">
            <button id="litho_sva_btn" type="button" style="margin-right: 1px; font-size: 12px;" class="btn btn-small btn-success" onclick="lithology_excel_data_save()"><i class="icon-save"></i><b>Save All</b></button>
        </div>
    </div>
</div>';

// Clean up: Delete the uploaded file
unlink($excel_file);

echo $table;
?>

<script>
    $(document).ready(function() {
        $('tbody').on('keypress', 'input', function(e) {
            // var flag = $('#lithology_flag').val();
            // alert(flag);
            // if (flag == 2) {
                if (e.which == 13) { 
                    e.preventDefault();
                    var currentInput = $(this);
                    var currentRow = currentInput.closest('tr');
                    var nextInput = currentInput.closest('td').next('td').find('input');

                    if (nextInput.length) {
                        nextInput.select();
                    } else {
                        var nextRow = currentRow.next('tr');
                        if (nextRow.length) {
                            var nextThickness = nextRow.find('.excel_lithology_thickness');
                            var nextColor = nextRow.find('.excel_lithology_color');
                            var nextMaterialQuantity = nextRow.find('.excel_lithology_material');

                            if (nextThickness.val() === "") {
                                nextThickness.val(currentRow.find('.excel_lithology_thickness').val());
                            }
                            if (nextColor.val() === "") {
                                nextColor.val(currentRow.find('.excel_lithology_color').val());
                            }
                            if (nextMaterialQuantity.val() === "") {
                                nextMaterialQuantity.val(currentRow.find('.excel_lithology_material').val());
                            }

                            nextThickness.select();
                        }
                    }
                }
            // } 
        });
    });
</script>
