<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
extract($_REQUEST);

$user_id = $_SESSION['LOGIN_USERID'];
$date = strtoupper(date('d-M-y H:i:s'));
$file = $_FILES['upload_excel']['name'];

$well_basic_info = $obj->Details_By_Cond("HYDROLOGY.BLPUMP_TBL@HYDRO10", "WELL_ID='$excel_well_id'");
$tot_obs_well = $well_basic_info['NUMBER_OF_OBS_WELL'];

$dir = '../../asset/custom/upload/';
$excel_file = $dir . $file;

if (!file_exists($dir) || !is_writable($dir)) {
    die("Directory does not exist or is not writable.");
}

if (file_exists($excel_file)) {
    unlink($excel_file);
}

if (!move_uploaded_file($_FILES['upload_excel']['tmp_name'], $excel_file)) {
    die("File upload error.");
}

require_once('../../asset/custom/PHPExcel_class/PHPExcel.php');
require_once('../../asset/custom/PHPExcel_class/PHPExcel/IOFactory.php');

try {
    $inputFileType = PHPExcel_IOFactory::identify($excel_file);
    $objReader = PHPExcel_IOFactory::createReader($inputFileType);
    $objPHPExcel = $objReader->load($excel_file);
} catch (Exception $e) {
    die('Error loading file "' . pathinfo($excel_file, PATHINFO_BASENAME) . '": ' . $e->getMessage());
}

$sheet = $objPHPExcel->getSheet(0);
$highestRow = $sheet->getHighestRow();

$data = [];

for ($row = 2; $row <= $highestRow; $row++) {
    $row_data = $sheet->rangeToArray('A' . $row . ':' . 'Z' . $row, NULL, TRUE, FALSE);
    $time = $row_data[0][0];
    $pw = $row_data[0][1];
    $observation_wells = [];
    for ($i = 2; $i < $tot_obs_well + 2; $i++) {
        $observation_wells[] = $row_data[0][$i];
    }
    $data[] = ['time' => $time, 'pw' => $pw, 'observation_wells' => $observation_wells];
}
// <h5 style="text-align: center; background-color: #ddd; padding: 5px 0px; font-weight: 700; font-size: 20px;">Excel Data Show</h5>
$table = '<div><label for="upload_excel">
</label></div>
<table id="litho_data_table" class="table table-bordered table-striped" style="width:100%; margin-top:20px">
    <div class="row-fluid" style="margin-bottom:5px;">
        <div class="control-group" style="float:right;">
            <div class="controls">
                <button id="litho_sva_btn" type="button" style="margin-right: 1px; font-size: 12px;" class="btn btn-small btn-success" onclick="pump_test_excel_data_save()"><i class="icon-save"></i><b>Save All</b></button>
            </div>
        </div>
    </div>
    <thead>
        <tr>
            <th style="text-align:center; font-size:13px;" class="table-header">Time(m)</th>
            <th style="text-align:center; font-size:13px;" class="table-header">PW</th>';

for ($j = 1; $j <= $tot_obs_well; $j++) {
    $table .= '<th style="text-align:center; font-size:13px;" class="table-header">OW' . $j . '</th>';
}

$table .= '</tr>
    </thead>
    <tbody id="litho_tbl_body">
        <span><input type="hidden" id="ex_pt_well_id" value="' . $excel_well_id . '"></span>
        <span><input type="hidden" id="ex_test_type_id" value="' . $excel_test_type_id . '"></span>
        <span><input type="hidden" id="excel_tot_obs_well" value="' . $tot_obs_well . '"></span>';

$countrow = count($data);

for ($i = 0; $i < $countrow; $i++) {
    $time_id = "time_$i";
    $pw_id = "pw_$i";
    $table .= '<tr>
                <td style="text-align: center;">
                    <input onkeypress="return isNumericInput(event)" type="text" style="text-align: center; font-weight: bold; padding:0px; height:0px" id="' . $time_id . '" class="excel_pt_time" onkeypress="return handleEnter(event)" value="' . $data[$i]['time'] . '" />
                </td>
                <td style="text-align: center;">
                    <input onkeypress="return isNumericInput(event)" type="text" style="text-align: center; font-weight: bold; padding:0px; height:0px" id="' . $pw_id . '" class="excel_pt_pw" onkeypress="return handleEnter(event)" value="' . $data[$i]['pw'] . '" />
                </td>';
    $ow = 1;
    foreach ($data[$i]['observation_wells'] as $j => $ow_value) {
        $ow_id = "ow_" . $i . "_" . $j;
        $table .= '<td style="text-align: center;">
                    <input onkeypress="return isNumericInput(event)" type="text" style="text-align: center; font-weight: bold; padding:0px; height:0px" id="excel_pt_ow_' . $ow . '" class="excel_pt_ow_' . $ow . '" onkeypress="return handleEnter(event)" value="' . $ow_value . '" />
                </td>';
        $ow++;
    }

    $table .= '</tr>';
}

$table .= '</tbody>
</table>
<div class="row-fluid" style="margin-bottom:5px;">
    <div class="control-group" style="float:right;">
        <div class="controls">
            <button id="litho_sva_btn" type="button" style="margin-right: 1px; font-size: 12px;" class="btn btn-small btn-success" onclick="pump_test_excel_data_save()"><i class="icon-save"></i><b>Save All</b></button>
        </div>
    </div>
</div>';

// Clean up: Delete the uploaded file
unlink($excel_file);

echo $table;
?>

<!-- Alphanumeric Checking -->
<script>
  let inputReset = false;

  function isNumericInput(event) {
    const key = event.keyCode || event.which;
    const keyChar = String.fromCharCode(key);

    const regex = /[0-9]|\./;
    if (!regex.test(keyChar)) {
      event.preventDefault();
      return false;
    }

    const input = event.target;
    const currentValue = input.value;

    if (inputReset) {
      input.value = "";
      inputReset = false;
    }

    if (key === 8 || key === 46 || key === 37 || key === 39) {
      return true;
    }

    const decimalIndex = currentValue.indexOf('.');
    if (decimalIndex !== -1 && keyChar === '.') {
      event.preventDefault();
      return false;
    }
    if (decimalIndex === -1) {
      if (currentValue.length >= 3 && keyChar !== '.') {
        event.preventDefault();
        return false;
      }
    } else {
      const decimalPart = currentValue.substring(decimalIndex + 1);
      if (decimalPart.length >= 3) {
        event.preventDefault();
        return false;
      }
    }
    return true;
  }
</script>

<!-- Alphanumeric Checking -->

<script>
function handleEnter(event) {
    if (event.keyCode === 13) {
        event.preventDefault();
        var inputs = Array.from(document.querySelectorAll('input[type="text"]'));
        var currentInput = document.activeElement;
        var currentIndex = inputs.indexOf(currentInput);
        var nextIndex = (currentIndex + 1) % inputs.length;
        inputs[nextIndex].select();
    }
}
</script>
