<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

include("../../asset/theme/css/myfunc.php");
include("../../php_crud/my_class.php");

require_once('../../asset/vendor/autoload.php');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$obj = new my_class();

// Uncomment if you need these lines for specific functionality.
// extract($_REQUEST);

// $tbl = "HYDROLOGY.BLPUMP_TBL@HYDRO10 LEFT JOIN HYDROLOGY.UPAZILA_TBL@HYDRO10 ON BLPUMP_TBL.UPZL_CODE = UPAZILA_TBL.UPZL_CODE LEFT JOIN HYDROLOGY.DISTRICT_TBL@HYDRO10 ON UPAZILA_TBL.DST_CODE = DISTRICT_TBL.DISTRICT_NO";
// $cols = "DISTRICT_TBL.DISTRICT_NAME AS DISTRICT_NAME";
// $where = "BLPUMP_TBL.WELL_ID = '$well_id'";

// $get_upzila_name = $obj->View_column_details_By_Cond($tbl, $cols, $where);

// if (!$get_upzila_name) {
//     die("Error retrieving Upzila name.");
// }

// $upzila_name = $get_upzila_name['DISTRICT_NAME'];

// $get_depth = $obj->Details_By_Cond("HYDROLOGY.BLPUMP_TBL@HYDRO10", "WELL_ID='$well_id'");
// $total_depth_meters = $get_depth['DEPTH'];
// $total_depth_feet = round($total_depth_meters * 3.28084);

// $num_rows = ceil($total_depth_feet / 10);

if (file_exists('../../asset/custom/upload/pump_test_sample_excel_file.xlsx')) {
    unlink('../../asset/custom/upload/pump_test_sample_excel_file.xlsx');
}

$filename = '../../asset/custom/upload/pump_test_sample_excel_file.xlsx';

try {
    $spreadsheet = new Spreadsheet();
    $spreadsheet->getProperties()->setCreator("MokNathal")
        ->setLastModifiedBy("MokNathal")
        ->setTitle("STAFF REPORT")
        ->setSubject("STAFF REPORT")
        ->setDescription("STAFF REPORT")
        ->setKeywords("STAFF REPORT")
        ->setCategory("STAFF REPORT");

    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setCellValue('A1', 'Time(m)')
          ->setCellValue('B1', 'PW')
          ->setCellValue('C1', 'OW1')
          ->setCellValue('D1', 'OW2')
          ->setCellValue('E1', 'OW3');

    $sheet->getStyle('A1:E1')->getAlignment()->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER);

    $sheet->getStyle('A1')->getFont()->setBold(true);
    $sheet->getStyle('B1')->getFont()->setBold(true);
    $sheet->getStyle('C1')->getFont()->setBold(true);
    $sheet->getStyle('D1')->getFont()->setBold(true);
    $sheet->getStyle('E1')->getFont()->setBold(true);

    $columnWidths = [
        'A' => 20,  
        'B' => 20,  
        'C' => 20,  
        'D' => 20,
        'E' => 20,  
    ];

    foreach ($columnWidths as $column => $width) {
        $sheet->getColumnDimension($column)->setWidth($width);
    }

    $sheet->setTitle('Transaction List');
    $spreadsheet->setActiveSheetIndex(0);

    $writer = new Xlsx($spreadsheet);
    $writer->save($filename);

    header("Location: " . $filename);
} catch (Exception $e) {
    echo 'Caught exception: ', $e->getMessage(), "\n";
}
?>
