<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
?>
<style>
	/* canvas {
		width: 70%; 
		height: 520px !important;
		width: 70% !important; 
	} */
</style>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script type="text/javascript" src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
<script src='https://cdn.plot.ly/plotly-2.24.1.min.js'></script>
<script src="module/ground_water_ex/js/water_level_information.js" type="text/javascript"></script>

<div id="cover-spin"></div>

<div class="table-header">
	<i class="fas fa-th-list"></i> Water Level Information
</div>

<div class="row-fluid" style="margin-top: -4px;">
	<div class="widget-header widget-header-large">
		<div class="widget-toolbar no-border">
			<ul class="nav nav-tabs" id="myTab">
				<li class="active">
					<a data-toggle="tab" href="#data_entry" onClick="loadDeForm()">Data Entry</a>
				</li>
				<li>
					<a data-toggle="tab" href="#data_upload" onClick="loadExcelData()">Excel Upload</a>
				</li>
			</ul>
		</div>
	</div>
</div>

<input type="hidden" style="width: 95%;" id="act_tab_name" name="act_tab_name" value="data_entry" />
<div class="row-fluid" style="padding-bottom: 10px; margin-top: -4px; background-color:#f5f5f5;-webkit-box-shadow: 0 8px 6px -6px black; -moz-box-shadow: 0 8px 6px -6px black; box-shadow: 0 8px 6px -6px black;">
	<div class="widget-body" style="border: none;  background-color: #f5f5f5;">
		<div class="widget-main padding-5">
			<div class="tab-content form_tab" style="overflow: visible; position: sticky; z-index: 999;">
				<!--####--Data-Entry--####-->
				<div id="data_entry" class="tab-pane in active">
					<!--River Field Starts-->

					<div class="span3" style="margin-top: 5px; padding-left: 25px;">
						<div class="control-group">
							<label class="control-label" for="river"><b>River<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%">
								<select id="river" name="river" class="chosen-select" style="height: 12px !important;" onchange="load_station_by_river_id(this.value)">
									<option value=""></option>
									<?php
									$table_name = 'HYDROLOGY.RIVER_INFO@HYDRO10';
									$columns = 'RIVER_CODE, RIVER_NAME';
									$where_cond = '1=1 ORDER BY RIVER_NAME ASC';

									foreach ($obj->View_colmn_By_Cond($table_name, $columns, $where_cond) as $river_list) {
										echo '<option value="' . $river_list['RIVER_CODE'] . '" data-river-name="' . $river_list['RIVER_NAME'] . '">' . $river_list['RIVER_NAME'] . '</option>';
									}
									?>
								</select>
							</div>
						</div>
					</div>
					<!--River Field Ends-->

					<!--Station Field Stats-->
					<div class="span3" style="margin-top: 5px; padding-left: 25px;">
						<div class="control-group">
							<label class="control-label" for="station"><b>Station<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%" id="station_list_holder">
								<select id="de_station" style="height: 12px !important;" name="de_station" class="chosen-select" onchange="flushData()">
									<option value=""></option>
								</select>
							</div>
						</div>
					</div>
					<!--Station Field Ends-->

					<!--Year Field Starts-->
					<div class="span2" style="margin-top: 5px; padding-left: 25px;">
						<div class="control-group">
							<label class="control-label" for="year"><b>Year<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%;">
								<input type="text" style="width: 97%; height: 12px !important;" id="year" name="year" value="<?php echo date('Y'); ?>" maxlength="4" />
							</div>
						</div>
					</div>
					<!--Year Field Ends-->

					<!--Month Fields Starts-->
					<div class="span2" style="margin-top: 5px; padding-left: 25px;">
						<div class="control-group">
							<label class="control-label" for="month"><b>Month<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%">
								<select id="month" name="month" style="height: 12px !important;" class="chosen-select" onchange="flushData()">
									<option value=""></option>
									<option value="01">January</option>
									<option value="02">February</option>
									<option value="03">March</option>
									<option value="04">April</option>
									<option value="05">May</option>
									<option value="06">June</option>
									<option value="07">July</option>
									<option value="08">August</option>
									<option value="09">September</option>
									<option value="10">October</option>
									<option value="11">November</option>
									<option value="12">December</option>
								</select>
							</div>
						</div>
					</div>
					<!--Month Field Ends-->
					<!--Show Data Button-->
					<div class="span2" style="margin-top: 30px;">
						<div class="control-group">
							<div class="controls">
								<button type="button" onclick="load_data_on_act_tab()" id="wli_find_btn" class="btn btn-minier btn-info" style="padding: 4px !important;">
									<i class="icon-search"></i> <b style="font-size: 12px;">Show Data</b>
								</button>
							</div>
						</div>
					</div>
					<!--Show Data Button-->
				</div>
				<!--####--Data-Entry--####-->

				<!--####--Data-Upload--####-->
				<div id="data_upload" class="tab-pane">
					<!--River Field Starts-->

					<div class="span3" style="margin-top: 5px; padding-left: 25px;">
						<div class="control-group">
							<label class="control-label" for="river_1"><b>River<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%">
								<select id="river_1" name="river_1" class="chosen-select" style="height: 12px !important;" onchange="load_station_by_river_id_excel(this.value)">
									<option value=""></option>
									<?php
									$table_name = 'HYDROLOGY.RIVER_INFO@HYDRO10';
									$columns = 'RIVER_CODE, RIVER_NAME';
									$where_cond = '1=1 ORDER BY RIVER_NAME ASC';

									foreach ($obj->View_colmn_By_Cond($table_name, $columns, $where_cond) as $river_list) {
										echo '<option value="' . $river_list['RIVER_CODE'] . '">' . $river_list['RIVER_NAME'] . '</option>';
									}
									?>
								</select>
							</div>
						</div>
					</div>
					<!--River Field Ends-->

					<!--Station Field Stats-->
					<div class="span3" style="margin-top: 5px; padding-left: 25px;">
						<div class="control-group">
							<label class="control-label" for="station_1"><b>Station<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%" id="station_list_holder_1">
								<select id="station_1" style="height: 12px !important;" name="station_1" class="chosen-select" onchange="flushData()">
									<option value=""></option>
								</select>
							</div>
						</div>
					</div>

					<!--Station Field Ends-->

					<!--Excel File Upload-->
					<div class="span3" style="margin-top: 5px; padding-left: 25px;">
						<div class="control-group">
							<label class="control-label" for="file"><b>Select File<font color="#FF0000"></font></b></label>
							<div class="controls" style="width: 100%;">
								<!--<input class="ace-file-input" type="file" name="file" id="file" accept=".xlsx">-->
								<input class="ace-file-input" type="file" name="wtl_file" id="wtl_file" accept="application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet">
							</div>
						</div>
					</div>

					<div class="span2" style="margin-top: 30px;padding-left:12px;">
						<div class="control-group">
							<div class="controls">
								<button type="button" id="wli_up_btn" class="btn btn-minier btn-success" style="padding: 4px !important;" onclick="load_wtl_excl_data()"><i class="icon-upload"></i>
									<b style="font-size: 12px;">Upload</b>
								</button>
							</div>
						</div>
					</div>

					<!--Excel File Upload-->
				</div>
				<!--####--Data-Upload--####-->
			</div>
		</div>
	</div>
</div>


<div class="row-fluid" style="margin-top: 15px;">
	<div class="col-sm-6 widget-container-col" id="widget-container-col-10">
		<div class="widget-box" id="widget-box-10">
			<div class="widget-header widget-header-large">
				<div class="widget-toolbar no-border">
					<ul class="nav nav-tabs" id="myTab">
						<li class="active">
							<a data-toggle="tab" href="#data_list" onclick="load_water_level_info()">Data List</a>
						</li>
						<li>
							<a data-toggle="tab" href="#graph_data" onclick="load_wl_graph_holder()"> Hydro Graph</a>
						</li>
					</ul>
					<!-- <a data-toggle="tab" href="#graph_data" onclick="myFunction()">Graph Data</a> -->
				</div>
			</div>
			<!--for grap-->
			<div class="widget-body">
				<div class="widget-main padding-5">
					<div class="tab-content data_content">
						<div id="data_list" class="tab-pane active">
							<div id="view_wli_data"></div>
						</div>
						<div class="tab-pane" id="graph_data"></div>
					</div>
				</div>
			</div>
			<!--end graph-->
		</div>
	</div>
</div>

<script>
	$('.chosen-select').chosen({
		allow_single_deselect: true
	});
	//resize the chosen on window resize
	$(window)
		.off('resize.chosen')
		.on('resize.chosen', function() {
			$('.chosen-select').each(function() {
				var $this = $(this);
				$this.next().css({
					'width': '100%'
				});
			})
		}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if (event_name != 'sidebar_collapsed') return;
		$('.chosen-select').each(function() {
			var $this = $(this);
			$this.next().css({
				'width': '100%'
			});
		})
	});
</script>

<!-- <script>
	$('#file').ace_file_input({
		no_file:'No File ...',
		btn_choose:'Choose',
		btn_change:'Change',
		droppable:false,
		onchange:null,
		thumbnail:false
	});
</script> -->
<script>
	function load_wtl_excl_data() {
		//alert('load_wtl_excel_data'); 
		var river = $("#river_1").val();
		//alert(river);
		var station = $("#station_1").val();
		//alert(station);
		var station_arr = station.split("#");
		var station_id = station_arr[0];
		var tidal_status = station_arr[1];
		//alert(station_id);
		//alert(tidal_status);
		if (!station_id) {
			alert('Please Select Station');
		}
		if (!river) {
			alert('Please Select River');
		} else {
			if (tidal_status == 'T') {
				var form_url = "module/ground_water_ex/excel_of_wtl_tidal.php";
			} else {
				var form_url = "module/ground_water_ex/excel_of_wtl_non_tidal.php";
			}

			var formData = new FormData();
			formData.append('river', river);
			formData.append('station', station_id);
			formData.append('wtl_file', $('#wtl_file')[0].files[0]);

			var excelFile = $('#wtl_file').val();

			var parse = excelFile.split('.');
			if (parse[parse.length - 1] != "xlsx" && parse[parse.length - 1] != "xls") {
				alert("Please Select excel File");
				return false;
			} else {
				$('#cover-spin').show(0);
				$.ajax({
					type: 'post',
					url: form_url,
					data: formData,
					contentType: false,
					processData: false,
					success: function(data) {
						//alert(res);
						$('#cover-spin').hide();
						$("#view_wli_data").html('');
						//$("#obs_dis_sva_btn").css({"display":"block"});
						$("#view_wli_data").html(data);
						$('#6hr_1').select();


					}
				});
			}
		}
		return false;
	}

	$('#file').ace_file_input({
		no_file: 'No File ...',
		btn_choose: 'Choose',
		btn_change: 'Change',
		droppable: false,
		onchange: null,
		thumbnail: false
	});
</script>