<?php
	session_start();
	// ============

	include("../../asset/theme/css/myfunc.php");
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	// ============
	$branchid = $_SESSION['LOGIN_BRANCH'];

	$header_list = [
		"STATION_CODE" => "Station ID",
		"STATION_NAME" => "Station Name",
		"KEYWORD" => "Keyword",
		"RIVER_NAME" => "River Name",
		"BASIN" => "Basin",
		"DISTRICT" => "District",
		"UPZILA" => "Upazila",
		"MEASUREMEMT_DIVISION" => "Measurememt Division",
		"MEASUREMENT_SUB_DIVISION" => "Measurememt Sub Division",
		"LATITUDE" => "Latitude",
		"LONGITUDE" => "Longitude",
		"MOBILE_NO" => "Mobile No",
		"QC_HIGH_RF" => "QC High RF",
		"QC_LOW_RF" => "QC Low RF",
		"PHONE_NO" => "Contact Info",
		"STATION_TAGS" => "Station Tags"
	];
	

	$allowed_keys = explode(",", $rf_stat_col_list);
	$allowed_keys = array_map('trim', $allowed_keys);
	$filtered = array_intersect_key($header_list, array_flip($allowed_keys));
	

	$ao_columns = [];
	// Optional: Set first column sortable, rest as `null`, and maybe last sortable (if needed)
	$ao_columns[] = '{ "bSortable": true }'; // first column

	foreach ($allowed_keys as $key) {
		$ao_columns[] = 'null';
	}
	$ao_columns[] = '{ "bSortable": true }'; // last column

	// Convert to string for JS
	$ao_columns_js = '[' . implode(',', $ao_columns) . ']';
	
	$where_cond = "STATION_TYPE='2'";
	
	
	if($stat_tag!=""){
		$where_cond .= " AND (',' || STATION_TAGS || ',') LIKE '%,$stat_tag,%'";
	}
	else{
		$where_cond .= "";
	}
	
	if($dist!="" && $basin=="" && $m_div==""){
		$where_cond .= " AND TRIM(DISTRICT)='$dist'";
	}
	//only basin selected
	else if($dist=="" && $basin!="" && $m_div==""){
		$where_cond .= " AND TRIM(BASIN)='$basin'";
	}
	//only division selected
	else if($dist=="" && $basin=="" && $m_div!=""){
		$where_cond .= " AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//district and basin selected
	else if($dist!="" && $basin!="" && $m_div==""){
		$where_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(BASIN)='$basin'";
	}
	//district and division selected
	else if($dist!="" && $basin=="" && $m_div!=""){
		$where_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//basin and division selected
	else if($dist=="" && $basin!="" && $m_div!=""){
		$where_cond .= " AND TRIM(BASIN)='$basin' AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//district, basin and division selected
	else if($dist!="" && $basin!="" && $m_div!=""){
		$where_cond .= " AND TRIM(DISTRICT)='$dist' AND TRIM(BASIN)='$basin' AND TRIM(MEASUREMEMT_DIVISION)='$m_div'";
	}
	//none is selected
	else{
		$where_cond .= "";
	}
	$where_cond .= " ORDER BY STATION_NAME ASC";
	$table = "FFWC.STATIONS_TBL";
	$column = "PKID,$rf_stat_col_list";
	$sl = 0;
?>
<div>
	<table id="ffwc_rf_stat_list" class="table table-striped table-bordered table-hover">
		<thead>
			<th style="text-align: center;">Sl</th>
		<?php	
			// Print the result
			foreach ($filtered as $key => $value) {
				echo '<th style="text-align: center;">'.$value.'</th>';
			}
		?>	
			<th style="text-align: center;">Action</th>
        </thead>
		<tbody>
		<?php
			foreach ($obj->View_colmn_By_Cond($table, $column, $where_cond) as $rf_stat_info) {
                $sl++;
				$pk_id = $rf_stat_info['PKID'];
				echo "<tr>";
					echo "<td style='text-align: center;'>$sl</td>";
					foreach ($filtered as $key => $value) {
						$cell_val = "";
						if($key=="STATION_TAGS"){
							$STATION_TAGS = $rf_stat_info[$key];
				
							$tag_lists = "";
							if($STATION_TAGS!=NULL || $STATION_TAGS!=null || $STATION_TAGS!=""){
								$tag_tbl = "FFWC.STATION_TAGS";
								$tag_cond = "ID IN ($STATION_TAGS)";
								foreach($obj->View_colmn_By_Cond($tag_tbl,"*",$tag_cond) as $tag_info){
									$tag_lists .= $tag_info['TAG_NAME'].", ";
								}
								$tag_lists = substr($tag_lists,0,-2);
							}
							else{
								$tag_lists = "";
							}
							$cell_val = $tag_lists;
						}
						else{
							$cell_val = $rf_stat_info[$key];
						}
						echo '<td style="text-align: center;">'.$cell_val.'</td>';
					}
					echo '<td style="text-align:center;">';
					 echo '<a class="label label-info" style="hover:cursor; width: 38px;" href="#ffwc_rf_stat_view" data-toggle="modal" onclick="load_ffwc_rf_station_vw_modal(\'' . $pk_id . '\')"> <i class="fa fa-eye"></i> View</a>';
					if($_SESSION['edit']=='Y'){
						echo '<br/><a class="label label-success" style="hover:cursor; width: 38px;" href="#ffwc_rf_stat_edit_form" data-toggle="modal" onclick="load_ffwc_rf_station_edit_modal(\'' . $pk_id . '\')"> <i class="fa fa-edit"></i> Edit</a>';
					}	
				echo '</td>';
				echo "</tr>";
			}
		?>
		</tbody>
	</table>
</div>

<script type="text/javascript">
   var oTable2 = $('#ffwc_rf_stat_list').dataTable({
    "aoColumns": <?php echo $ao_columns_js; ?>,
    "iDisplayLength": 50
	});
</script>

<!--<div class="row-fluid">
    <div id="columnVisibilityrf" class="custom-dropdown">
        <label for="col1"><input type="checkbox" id="col1" onclick="toggleColumn(0)"> SL</label><br>
        <label for="col2"><input type="checkbox" id="col2" onclick="toggleColumn(1)"> Station ID </label><br>
        <label for="col3"><input type="checkbox" id="col3" onclick="toggleColumn(2)"> Station Name </label><br>
        <label for="col4"><input type="checkbox" id="col4" onclick="toggleColumn(3)"> Keyword </label><br>
        <label for="col5"><input type="checkbox" id="col5" onclick="toggleColumn(4)"> River Name </label><br>
        <label for="col6"><input type="checkbox" id="col6" onclick="toggleColumn(5)"> Basin </label><br>
        <label for="col7"><input type="checkbox" id="col7" onclick="toggleColumn(6)"> District </label><br>
        <label for="col8"><input type="checkbox" id="col8" onclick="toggleColumn(7)"> Upzila </label><br>
        <label for="col9"><input type="checkbox" id="col9" onclick="toggleColumn(8)"> Latitude </label><br>
        <label for="col10"><input type="checkbox" id="col10" onclick="toggleColumn(9)"> Longitude </label><br>
        <label for="col11"><input type="checkbox" id="col11" onclick="toggleColumn(10)"> Measurement Division </label><br>
        <label for="col12"><input type="checkbox" id="col12" onclick="toggleColumn(11)"> Measurement SubDivision </label><br>
        <label for="col13"><input type="checkbox" id="col13" onclick="toggleColumn(12)"> Mobile No </label><br>
        <label for="col14"><input type="checkbox" id="col14" onclick="toggleColumn(13)"> QC High Rf </label><br>
        <label for="col15"><input type="checkbox" id="col15" onclick="toggleColumn(14)"> QC Low Rf </label><br>
        <label for="col16"><input type="checkbox" id="col16" onclick="toggleColumn(15)"> Contact Info </label><br>
        <label for="col17"><input type="checkbox" id="col17" onclick="toggleColumn(16)"> Station Tags </label><br>
    </div>
    <table id="ffwc_rf_stat_list" class="table table-striped table-bordered table-hover">
        <thead>
            <th style="text-align: center;" id="col1">Sl.</th>
            <th style="text-align: center;" id="col2">Station Id</th>
            <th style="text-align: center;" id="col3">Station Name</th>

            <th style="text-align: center;" id="col4">Keyword</th>
            <th style="text-align: center;" id="col5">River Name</th>
            <th style="text-align: center;" id="col6">Basin</th>
            <th style="text-align: center;" id="col7">District</th>
            <th style="text-align: center;" id="col8">Upzila</th>

            <th style="text-align: center; display:none;" id="col9">Latitude</th>
            <th style="text-align: center; display:none;" id="col10">Longitude</th>
            <th style="text-align: center; display:none;" id="col11">Measurement Division</th>
            <th style="text-align: center; display:none;" id="col12">Measurement SubDivision</th>
            <th style="text-align: center; display:none;" id="col13">Mobile No</th>
            <th style="text-align: center; display:none;" id="col14">QC High Rf</th>
            <th style="text-align: center; display:none;" id="col15">QC Low Rf</th>
            <th style="text-align: center; display:none;" id="col16">Contact Info</th>
            <th style="text-align: center; display:none;" id="col17">Station Tags</th>
            <!--<th style="text-align: center; display:none;" id="col18"></th>
            <th style="text-align: center; display:none;" id="col19"></th>
            <th style="text-align: center; display:none;" id="col20">QC Mean WL</th>
            <th style="text-align: center; display:none;" id="col21">High WL Date</th>
            <th style="text-align: center; display:none;" id="col22">Low WL Date</th>
            <th style="text-align: center; display:none;" id="col23"></th>
            <th style="text-align: center; display:none;" id="col24"></th>
            <th style="text-align: center; display:none;" id="col25"></th>-->

<!--
            <th style="text-align: center;">Action</th>
        </thead>
        <tbody>
            <?php
            //$sl=0;
            //$cond = "HYDSUBDIVCODE LIKE 'SW%' ORDER BY STATION_ID";
            $table = "FFWC.STATIONS_TBL";
            $where_cond = "(DATA='RF') ORDER BY STATION_CODE ASC";
            $column = "*";
            $sl = 0;
            foreach ($obj->View_colmn_By_Cond($table, $column, $where_cond) as $value) {
                $sl++;
                $pk_id = $value['PKID'];
                $stat_id = $value['STATION_CODE'];
                $stat_name = $value['STATION_NAME'];
                $keyword = $value['KEYWORD'];
                $basin = $value['BASIN'];
                $riv_name = $value['RIVER_NAME'];

                $district = $value['DISTRICT'];
                $upzila = $value['UPZILA'];
                $mea_division = $value['MEASUREMEMT_DIVISION'];
                $mea_sub_division = $value['MEASUREMENT_SUB_DIVISION'];
                $phone = $value['PHONE_NO'];
                $data_type = $value['DATA'];
                $STATION_TYPE = $value['STATION_TYPE'];
                $STATION_CODE = $value['STATION_CODE'];
                $MOBILE_NO = $value['MOBILE_NO'];
                $DANGER_LEVEL = $value['DANGER_LEVEL'];
                $BASIN = $value['BASIN'];
                $RECORDED_HIGH_WL = $value['RECORDED_HIGH_WL'];
                $PRE_MONSOON_DL = $value['PRE_MONSOON_DL'];
                $LATITUDE = $value['LATITUDE'];
                $LONGITUDE = $value['LONGITUDE'];
                $UPZILA = $value['UPZILA'];
                $QC_MEAN_WL = $value['QC_MEAN_WL'];
                $HIGH_WL_DATE = $value['HIGH_WL_DATE'];
                $LOW_WL_DATE = $value['LOW_WL_DATE'];
                $QC_HIGH_RF = $value['QC_HIGH_RF'];
                $QC_LOW_RF = $value['QC_LOW_RF'];
                $STATION_TAGS = $value['STATION_TAGS'];
                // $mea_sub_division = $value['MEASUREMENT_SUB_DIVISION'];
                // $phone = $value['PHONE_NO'];
                // $data_type = $value['DATA'];
				
				$tag_lists = "";
				if($STATION_TAGS!=NULL || $STATION_TAGS!=null || $STATION_TAGS!=""){
					$tag_tbl = "FFWC.STATION_TAGS";
					$tag_cond = "ID IN ($STATION_TAGS)";
					foreach($obj->View_colmn_By_Cond($tag_tbl,"*",$tag_cond) as $tag_info){
						$tag_lists .= $tag_info['TAG_NAME'].", ";
					}
					$tag_lists = substr($tag_lists,0,-2);
				}
				else{
					$tag_lists = "-";
				}

                echo "<tr>";
                echo "<td style='text-align: center;' id='col1'>$sl</td>";
                echo "<td style='text-align: center;' id='col2'>$stat_id</td>";
                echo "<td width='12%' id='col3'>$stat_name</td>";
                echo "<td width='8%' style='text-align: center;' id='col4'>$keyword</td>";
                echo "<td width='8%' style='text-align: center;' id='col5'>$basin</td>";
                echo "<td width='12%' id='col6'>$riv_name</td>";
                echo "<td width='12%' id='col7'>$district</td>";
                echo "<td width='12%' id='col8'>$upzila</td>";

                echo "<td style='text-align: center;display: none;' id='col9'>$LATITUDE</td>";
                echo "<td style='text-align: center;display: none;' id='col10'>$LONGITUDE</td>";
                echo "<td style='text-align: center;display: none;' id='col11'>$mea_division</td>";
                echo "<td style='text-align: center;display: none;' id='col12'>$mea_sub_division</td>";
                echo "<td style='text-align: center;display: none;' id='col13'>$MOBILE_NO</td>";
                echo "<td style='text-align: center;display: none;' id='col14'>$QC_HIGH_RF</td>";
                echo "<td style='text-align: center;display: none;' id='col15'>$QC_LOW_RF</td>";
                echo "<td style='text-align: center;display: none;' id='col16'>$phone</td>";
                echo "<td style='text-align: center;display: none;' id='col17'>$tag_lists</td>";


                echo '<td style="text-align:center;">';
               
                
                echo '</td>';
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>
</div>


<script type="text/javascript">
    $(document).ready(function() {
        var oTable2 = $('#ffwc_rf_stat_list').DataTable({
            "columns": [{
                    "orderable": false
                },
                null, null, null, null, null, null,
                {
                    "orderable": false
                }
            ],
            "iDisplayLength": 50
        });
        const table = document.getElementById('ffwc_rf_stat_list');
        const ths = table.getElementsByTagName('th');

        // Loop through the columns
        for (let i = 0; i < 8; i++) {
            const checkbox = document.getElementById(`col${i + 1}`);
            if (checkbox) {
                if (i < ths.length) {
                    // These columns exist in the table and are visible
                    checkbox.checked = true;
                } else {
                    // These columns are not in the table
                    checkbox.checked = false;
                }
            }
        }
    });
</script>-->