<?php
session_start();
include("../../php_crud/my_class.php");
include("../../asset/theme/css/myfunc.php");
$obj = new my_class();
?>

<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" />
<link rel="stylesheet" href="asset/custom/alertifyjs/css/alertify.rtl.css">
<link rel="stylesheet" href="asset/custom/alertifyjs/css/themes/default.rtl.css">
<link rel="stylesheet" href="asset/theme/css/custom_design.css">

<script src="asset/custom/js/typeahead.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<!-- <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script> -->
<script src="module/mobiledatalog/js/ffwc_water_level_info.js" type="text/javascript"></script>

<!-- Include jQuery + jQuery UI -->
<!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script> -->

<style type="text/css">
    .centered-div {
        width: 95%;
        /* Adjust the width as needed */
        margin: 0 auto;
        background-color: white;
    }

    .stat div {
        display: inline-grid;
        /* width: auto; */
    }

    .stat-div {
        border: 1px solid #ccc;
        border-radius: 2px;
    }

    .station-list-wl {
        background-color: white;
        /* width: 200px; */
        /* Adjust the width as needed */
        height: 650px;
        /* Adjust the height as needed */
        overflow: auto;
        /* Enable vertical scrolling when needed */
    }

    .station_wl {
        cursor: pointer;
        padding: 2px;
        margin: 2px;
        border: 1px solid #ccc;
        border-radius: 2px;
    }

    /* Define the selected class */
    .selected {
        background-color: #2283C5;
        color: white;
        /* Set text color to white for better visibility */
    }

    .modal {
        position: fixed;
        top: 50%;
        left: 65%;
        /* transform: translate(-50%, -50%); */
    }

    .modal-footer {
        height: 14px;
        /* margin-top: 10px; */
    }

    #btn_save {
        display: block;
        margin: 0 auto;
        margin-top: -10px;
    }

    .modal-body {
        height: 140px;
        margin-top: 30px;
        font-size: 16px;
        /* font:center; */
        /* overflow-y: auto; */
    }

    /* .modal-footer {
    height: 15px;
    text-align: center;
} */

    /* .close {
  color: #aaa;
  float: right;
  font-size: 28px;
  font-weight: bold;
}

.close:hover,
.close:focus {
  color: black;
  text-decoration: none;
  cursor: pointer;
} */
    /* .modal-footer {
  height: 20px;
  
} */

    /* .modal-footer {
  margin-top: -10px;
} */
</style>

<div id="cover-spin"></div>

<div class="table-header">
    <i class="fas fa-th-list"></i> FFWC Water Level Information
</div>
<input type="hidden" style="width: 95%;" id="act_tab_name" name="act_tab_name" value="data_entry" />
<div class="row-fluid" style="padding-bottom: 5px; margin-top: -4px; background-color:#f5f5f5;-webkit-box-shadow: 0 8px 6px -6px black; -moz-box-shadow: 0 8px 6px -6px black; box-shadow: 0 8px 6px -6px black;">

    <div class="widget-body" style="border: none;  background-color: #f5f5f5;">
        <div class="widget-main padding-5">
            <div class="tab-content" style="overflow: visible; position: sticky; z-index: 999;">
                <!--####--Data-Entry--####-->
                <div id="data_entry" class="tab-pane in active">

                    <div class="span3" style="padding-bottom:20px;">
                        <div class="control-group stat" style="width: 100%;">


                            <div class="controls" style="width: 80%;">

                                <?php
                                $table = "FFWC.STATIONS_TBL";
                                // $where_cond = "1=1 ORDER BY SID ";
                                $where_cond = "STATION_TYPE IN (0,1)";
                                $total_row = $obj->Total_Count_By_Cond($table, $where_cond);
                                ?>
                                <label align="center"><b>List of Stations: <?php echo $total_row ?> </b>
                                    <font style="color:#FF0000;"></font>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="span3" style="padding-bottom:20px;">
                        <div class="control-group stat">
                            <div class="controls">
                                <label align="right"><b>Data For</b>
                                </label>
                            </div>
                            <div class="controls">
                                <input type="number" style="width: 90%; height:15px!important;" name="from_date" id="day5" value="7" min="1" onchange="handleDaysChange(this.value)">
                            </div>
                            <div>
                                <label align="left"><b>Days</b>
                                </label>
                            </div>
                        </div>
                    </div>

                    <!-- <div class="span3">
                        <div class="control-group stat">
                            <div class="controls">
                                <p align="left"><b>Upto:</b></p>
                            </div> -->
                    <!-- <label class="control-label" for="form-field-1">&nbsp;</font></label> -->
                    <!-- <div class="controls" id="branch_control">
                                <input style="width: 100%; height:12px!important;" id="date" name="date" class="date-picker" type="text" data-date-format="dd-mm-yyyy" placeholder="dd-mm-yyyy" />
                            </div>
                        </div>
                    </div> -->
                    <div class="span3">
                        <div class="control-group stat">
                            <div class="controls">
                                <p align="left"><b>Upto:</b></p>
                            </div>
                            <!-- <label class="control-label" for="form-field-1">&nbsp;</font></label> -->
                            <div class="controls" id="branch_control">
                                <input style="width: 100%; height:12px!important;" id="to_date" name="date" class="date-picker" type="text" data-date-format="dd-mm-yyyy" placeholder="dd-mm-yyyy" onchange="handleDateChange(this.value)" />
                            </div>
                        </div>
                    </div>

					<div class="span3">
                        <div class="control-group stat">
                            <div class="controls">
                                <p align="left"><b>Graph Display Mode:</b></p>
                            </div>
                            <div class="controls" id="branch_control" style="width: 180px !important;">
								<select id="display_mode" name="display_mode" class="chosen-select" style="height: 12px !important;" onchange="reload_wl_view()">
									<option value="NONE">--Select--</option>
									<option value="DL">Danger Level</option>
									<option value="HRL">Highest Recorded Level</option>
									<option value="BOTH">Both</option>
								</select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- data and grapg -->
<div class="row-fluid">
    <div class="span3" style="margin-top: 25px;">
        <div class="stat-div centered-div">
            <input type="text" id="stationSearch_wl" placeholder="Search Stations" style="width: 98%; height: 15px !important; background-color: white !important;">
            <div class="station-list-wl">
                <?php

                $table = "FFWC.STATIONS_TBL";
                $where_cond = "STATION_TYPE='1' ORDER BY STATION_NAME ASC";
                $column = "*";
                $firstStation = true; // To track the first station div
                $sl = 1;

                foreach ($obj->View_colmn_By_Cond($table, $column, $where_cond) as $value) {
                    $selectedClass = $firstStation ? 'selected' : '';
					echo '<div id="default-station" class="station_wl ' . $selectedClass . '" onclick="load_wl_info(this)" data-station-key="' . $value['KEYWORD'] . '" data-station-name="' . $value['STATION_NAME'] . '" data-river-name="' . $value['RIVER_NAME'] . '">' . $sl . ". " . $value['STATION_NAME'] . ' (' . $value['KEYWORD'] . ')</div>';
                    $firstStation = false;
                    $sl++;
                }
                ?>
            </div>
            <!-- <input type="hidden" id="station_name_holder"> -->
        </div>
    </div>
    <div class="span3" id="data_to_show_ffwc_wl" style="margin-top: 25px;"></div>
    <!-- <div class="span6" id="graph_to_show_ffwc_wl" style="margin-top: 10px;">
  
    </div> -->
    <div class="span6" id="graph_to_show_ffwc_wl" style="margin-top: 10px;">
	    <canvas id="graph_canvas_ffwc_wl" style="width: 100%; height: 500px;"></canvas>
    </div>

    <!-- margin-left: 70px; -->
</div>
<!-- data and graph end -->
<div id="modal_ffwc_wl_edit" class="modal hide fade" style="margin-top: 200px; margin-left: -28%; width: 25%; " tabindex="-1">
    <div class="modal-header no-padding">
        <div class="table-header">
            <button type="button" class="close" data-dismiss="modal" style="opacity:1 !important"><i class="fa fa-window-close" style="font-size: 26px;font-weight: bold;color: #FFF;"></i> </button>
            <b> Edit Water Level </b>
        </div>
    </div>
    <div class="modal-body " id="ffwc_model_edit_body" style="max-height: 600px;">
    </div>
    <div class="modal-footer ">
        <div class="row-fluid">
            <button class="btn btn-small btn-success pull-right " type="button" id="btn_save" onclick="save_wl_data()">
                <i class="icon-ok bigger-40"></i>
                Save
            </button>
        </div>
    </div>
</div>

<div id="modal_ffwc_wl_add" class="modal hide fade" style="margin-top: 200px; margin-left: -28%; width: 28%; " tabindex="-1">
    <div class="modal-header no-padding">
        <div class="table-header">
            <button type="button" class="close" data-dismiss="modal" style="opacity:1 !important"><i class="fa fa-window-close" style="font-size: 26px;font-weight: bold;color: #FFF;"></i> </button>
            <b> Add Water Level </b>
        </div>
    </div>
    <div class="modal-body " id="ffwc_model_add_body" style="max-height: 600px;">
    </div>
    <div class="modal-footer ">
        <div class="row-fluid">
            <button class="btn btn-small btn-success pull-right " type="button" id="btn_save" onclick="save_water_data()">
                <i class="icon-ok bigger-40"></i>
                Save
            </button>
        </div>
    </div>
</div>


<script>
	$('.chosen-select').chosen({allow_single_deselect: true, disable_search: true});
	//resize the chosen on window resize
	$(window)
		.off('resize.chosen')
		.on('resize.chosen', function() {
			$('.chosen-select').each(function() {
				var $this = $(this);
				$this.next().css({
					'width': '100%'
				});
			});
		}).trigger('resize.chosen');
	//resize chosen on sidebar collapse/expand
	$(document).on('settings.ace.chosen', function(e, event_name, event_val) {
		if (event_name != 'sidebar_collapsed') return;
		$('.chosen-select').each(function() {
			var $this = $(this);
			$this.next().css({
				'width': '100%'
			});
		});
	});
	
    // Remove event listeners when navigating away from the page
    window.onbeforeunload = function() {
        // Remove event listeners here
        // For example, if you have a keydown event listener:
        document.removeEventListener('keydown', handleKeyDown);
    };
</script>


<script>
    document.getElementById('day5').addEventListener('keyup', function(event) {
        // Check if the key pressed is "Enter" (key code 13)
        if (event.keyCode === 13) {
            // Simulate a click on the previously selected div
            if (selectedDivWL) {
                selectedDivWL.click();
            }
        }
    });

    function handleDateChange(dateValue) {
        // Simulate a click on the previously selected div
        // alert(dateValue);
        if (selectedDivWL) {
            selectedDivWL.click();
        }
        $('#to_date').datepicker('hide');

    }
	
	function handleDaysChange(dateValue) {
        if (selectedDivWL) {
            selectedDivWL.click();
        }
    }
	
	function reload_wl_view(){
		if (selectedDivWL) {
			selectedDivWL.click();
		}
	}
</script>

<script>
    setTimeout(function() {
        var firstStationDivWL = document.querySelector('.station_wl.selected');
        if (firstStationDivWL) {
            firstStationDivWL.click();
        }
    }, 50); // You can adjust the delay as needed
</script>

<script>
    var stationList_wl = document.querySelector('.station-list-wl');
    var stations_wl = stationList_wl.querySelectorAll('.station_wl');
    let focusedIndex_wl = 0;
    let selectedStation_wl = null;

    document.getElementById('stationSearch_wl').addEventListener('input', function() {
        var searchTerm_wl = this.value.trim().toLowerCase();

        // Filter stations based on the search term
        stations_wl.forEach((station, index) => {
            var stationName_wl = station.textContent.toLowerCase();
            var isMatch_wl = stationName_wl.includes(searchTerm_wl);

            // Show or hide stations based on the search result
            station.style.display = isMatch_wl ? 'block' : 'none';
        });

        // If the selected station is hidden, find and select the first visible station
        if (selectedStation_wl && !isStationVisible_wl(selectedStation_wl)) {
            findAndSelectVisibleStation_wl();
        }
    });

    // Initial selection of the first visible station
    findAndSelectVisibleStation_wl();

    document.addEventListener('keydown', function(e) {
        if (e.key === 'ArrowDown' || e.key === 'ArrowUp') {
            // Remove 'selected' class from the previously selected station
            if (selectedStation_wl) {
                selectedStation_wl.classList.remove('selected');
            }

            // Calculate the new focused index
            focusedIndex_wl = e.key === 'ArrowDown' ?
                (focusedIndex_wl + 1) % stations_wl.length :
                (focusedIndex_wl - 1 + stations_wl.length) % stations_wl.length;

            // Update the selected station
            selectedStation_wl = stations_wl[focusedIndex_wl];

            // Add 'selected' class to the new focused station
            selectedStation_wl.classList.add('selected');

            // Trigger click on the new focused station
            selectedStation_wl.click();
        }
    });

    stations_wl.forEach((station, index) => {
        station.addEventListener('click', function() {
            // Update the selected station when clicked
            if (selectedStation_wl) {
                selectedStation_wl.classList.remove('selected');
            }
            selectedStation_wl = station;
            selectedStation_wl.classList.add('selected');

            focusedIndex_wl = index;
            // Add any other logic you need when a station is selected.
        });
    });

    function findAndSelectVisibleStation_wl() {
        for (let i = 0; i < stations_wl.length; i++) {
            if (isStationVisible_wl(stations_wl[i])) {
                handleStationClick_wl(stations_wl[i], i);
                break;
            }
        }
    }

    function handleStationClick_wl(station, index) {
        // Your existing code for handling station click
        // Update the selectedStation_wl and focusedIndex_wl accordingly
        selectedStation_wl = station;
        focusedIndex_wl = index;

        // Example: Log the selected station's text content
        console.log('Selected Station:', selectedStation_wl.textContent);
    }

    function isStationVisible_wl(station) {
        // Your existing code for checking if the station is visible
        var rect = station.getBoundingClientRect();
        return (
            rect.top >= 0 &&
            rect.bottom <= (window.innerHeight || document.documentElement.clientHeight)
        );
    }
</script>

<script>
    var currentDate = new Date();

    var day = currentDate.getDate();
    var month = currentDate.getMonth() + 1; // Months are 0-based
    var year = currentDate.getFullYear();

    var formattedDate = (day < 10 ? '0' : '') + day + '-' + (month < 10 ? '0' : '') + month + '-' + year;
    document.getElementById('to_date').value = formattedDate;
</script>

<script type="text/javascript">
    $('.chosen-select').chosen({
        allow_single_deselect: true
    });
    //resize the chosen on window resize

    $(window)
        .off('resize.chosen')
        .on('resize.chosen', function() {
            $('.chosen-select').each(function() {
                var $this = $(this);
                $this.next().css({
                    'width': '100%'
                });
            })
        }).trigger('resize.chosen');
    //resize chosen on sidebar collapse/expand
    $(document).on('settings.ace.chosen', function(e, event_name, event_val) {
        if (event_name != 'sidebar_collapsed') return;
        $('.chosen-select').each(function() {
            var $this = $(this);
            $this.next().css({
                'width': '100%'
            });
        })
    });
</script>


<!--for load datatable-->
<script type="text/javascript">
    $('.date-picker').datepicker().next().on(ace.click_event, function() {
        $(this).prev().focus();
    });
    $(".date-picker").attr("autocomplete", "off");
</script>
