$(document).ready(function(){
	call_stat_n_db_col_list();
});

function call_stat_n_db_col_list(){
	load_station_list();
	load_col_list();
}
function load_station_list(){
	var data_type_excl = $("#data_type_excl").val();
	var stat_tag = $("#stat_tag").val();
	var dist = $("#dist").val();
	var basin = $("#basin").val();
	var m_div = $("#m_div").val();
	var river = $("#river").val();
	var datastr = "data_type="+data_type_excl+"&stat_tag="+stat_tag+"&dist="+dist+
	"&basin="+basin+"&m_div="+m_div+"&river="+river;
	//alert(datastr);
	$('#cover-spin').show();
	$.ajax({
		url: "module/mobiledatalog/station_list_for_reports.php",
		datatype: 'POST',
		data: datastr,
		success: function (data) {
			$('#cover-spin').hide();
			//alert(data);
			$("#station_list_holder").html(data);
		}
	});
}

function load_col_list(){
	var data_type_excl = $("#data_type_excl").val();
	var datastr = "data_type="+data_type_excl;
	//alert(datastr);
	$('#cover-spin').show();
	$.ajax({
		url: "module/mobiledatalog/station_col_list.php",
		datatype: 'POST',
		data: datastr,
		success: function (data) {
			$('#cover-spin').hide();
			//alert(data);
			$("#col_list_excl_holder").html(data);
		}
	});
}

function download_stat_info(){
	var data_type_excl = $("#data_type_excl").val();
	var stat_tag = $("#stat_tag").val();
	var dist = $("#dist").val();
	var basin = $("#basin").val();
	var m_div = $("#m_div").val();
	var river = $("#river").val();
	var station_list = $("#station_list").val();
	var stat_col_list = $("#stat_col_list_excl_up").val();
	
	if(!station_list){
		alert("Please Select Station");
		$("#station_list").focus();
		return false;
	}
	else if(!stat_col_list){
		alert("Please Select Data Column Names");
		$("#stat_col_list_excl_up").focus();
		return false;
	}
	else{
		var datastr = "data_type="+data_type_excl+"&dist="+dist+"&basin="+basin+"&m_div="+m_div+
		"&river="+river+"&station_list="+station_list+"&stat_col_list="+stat_col_list;
	//	alert(datastr);
		window.open('module/mobiledatalog/station_info_update_excel_dl.php?'+datastr);
	}
}

function upload_stat_info() {
	var data_type_excl = $("#data_type_excl").val();
	var stat_col_list = $("#stat_col_list_excl_up").val()

	var formData = new FormData();
	formData.append('data_type', data_type_excl);
	formData.append('stat_col_list', stat_col_list);
	formData.append('stat_file', $('#stat_file')[0].files[0]);
			
	var excelFile = $('#stat_file').val();

	var parse = excelFile.split('.');
	if(!stat_col_list){
		alert("Please Select Data Column Names which are in the excel");
		$("#stat_col_list_excl_up").focus();
		return false;
	}
	else if (parse[parse.length - 1] != "xlsx" && parse[parse.length - 1] != "xls") {
		alert("Please Select excel File");
		return false;
	} else {
		$('#cover-spin').show(0);
		$.ajax({
			type: 'post',
			url: "module/mobiledatalog/station_info_excl_datatable.php",
			data: formData,
			contentType: false,
			processData: false,
			success: function(res) {
				//alert(res);
				$('#cover-spin').hide();
				$("#excl_data_holder").html('');
				$("#excl_data_holder").html(res);
			}
		});
	}
	return false;
}

function save_excl_stat_info(){
	const formData = {};

    $(".excl_input").each(function() {
        const name = $(this).attr("name");
        const value = $(this).val();

        const matches = name.match(/data\[(\d+)\]\[(\w+)\]/);
        if (matches) {
            const rowIndex = matches[1];
            const key = matches[2];

            if (!formData[rowIndex]) {
                formData[rowIndex] = {};
            }
            formData[rowIndex][key] = value;
        }
    });
	//alert(JSON.stringify(formData));
	$('#cover-spin').show(0);
	$.ajax({
        url: 'module/mobiledatalog/station_info_excl_ajax.php',
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify(formData),
      //  dataType: 'json',
        success: function(response) {
			$('#cover-spin').hide();
            //alert(response);
			if(response==1){
				alert('Station Information has been updated successfully');
				$("#excl_data_holder").html('');
				$('#stat_file').val('');
			}
			else{
				alert('Error occurred.');
				//$("#excl_data_holder").html(response);
			}
        }
    });
}