<?php
	session_start();
	include("../../php_crud/my_class.php");
	$obj = new my_class();

	extract($_REQUEST);
	$batch_no = trim($mfd_batch_no);
	$user_id = $_SESSION['LOGIN_USERID'];
	$db_ins_date = date('d-M-y H:i:s');
	$date = strtoupper($db_ins_date);
	
	if($operation=='save_data'){
		$ret_msg = 0;
		$proccess_status = "";
		$data_arr = [];
		if(strpos($data_list,",")!=""){
			$data_arr = explode(",",$data_list);
		} 
		else{
			$data_arr[0] = $data_list;
		}
		
		for($i=0; $i<count($data_arr); $i++) {
			$input_arr = explode('#', $data_arr[$i]);
			
			//print_r($input_arr);
			$id_val = $input_arr[0];
			$sel_station_id = strtoupper($input_arr[1]);
			$in_date = strtoupper($input_arr[2]);
			$sel_hr6_vwl = $input_arr[3];
			$sel_hr9_vwl = $input_arr[4];
			$sel_hr12_vwl = $input_arr[5];
			$sel_hr15_vwl = $input_arr[6];
			$sel_hr18_vwl = $input_arr[7];
			$sel_vrf = $input_arr[8];
			
			$wl_count_cond = "UPPER(KEYWORD)='$sel_station_id' GROUP BY KEYWORD";
			$proccess_status .="$wl_count_cond\n";
			$wl_cols = "COUNT(CASE WHEN STATION_TYPE='1' THEN STATION_TYPE END) AS WL_STATION,COUNT(CASE WHEN STATION_TYPE='2' THEN STATION_TYPE END) AS RF_STATION,KEYWORD";
			$stat_basic_info = $obj->View_column_details_By_Cond("FFWC.STATIONS_TBL",$wl_cols,$wl_count_cond);
		
			$wl_stat_cond = "UPPER(KEYWORD)='$sel_station_id' AND TRIM(DATA)='WL'";
			$wl_stat_info = $obj->View_column_details_By_Cond("FFWC.STATIONS_TBL","STATION_CODE",$wl_stat_cond);
			$stat_wl_id = $wl_stat_info['STATION_CODE'];
		
			$rf_stat_cond = "UPPER(KEYWORD)='$sel_station_id' AND TRIM(DATA)='RF'";
			$rf_stat_info = $obj->View_column_details_By_Cond("FFWC.STATIONS_TBL","STATION_CODE",$rf_stat_cond);
			$stat_rf_id = $rf_stat_info['STATION_CODE'];
		
			$is_in_hydro_wl = $obj->Total_Count_By_Cond("HYDROLOGY.SW_STATION_TBL@HYDRO10","STATION_ID='$stat_wl_id' AND  (',' || STATION_TYPE || ',') LIKE '%,1,%'");
			$is_in_hydro_rf = $obj->Total_Count_By_Cond("HYDROLOGY.SW_STATION_TBL@HYDRO10","STATION_ID='$stat_rf_id' AND  (',' || STATION_TYPE || ',') LIKE '%,2,%'");
			
			$form_data['VERIFIED_HR6']="'$sel_hr6_vwl'";
			$form_data['VERIFIED_HR9']="'$sel_hr9_vwl'";
			$form_data['VERIFIED_HR12']="'$sel_hr12_vwl'";
			$form_data['VERIFIED_HR15']="'$sel_hr15_vwl'";
			$form_data['VERIFIED_HR18']="'$sel_hr18_vwl'";
			$form_data['VERIFIED_RAINFALL']="'$sel_vrf'";
			$form_data['STATUS']="'A'";
			$form_data['VERIFIED_LOG_DATE']="TO_DATE('$in_date', 'DD-MON-RR')";
			$form_data['UPDATE_BY']="'$user_id'";
			$form_data['UPDATE_DATE']= "TO_DATE('$date','DD-MON-RR HH24:MI:SS')";
			
			$table_name='MDM_Wl_RAINFALL_DATA_LOG';
			$where_cond = "ID='$id_val'";	
			$update = $obj->Update_Data($table_name, $form_data, $where_cond);
			if($update){
				$ret_msg=1;
				$proccess_status .= "\n MDM ID $id_val update in line 65 is complete for $i row\n";
			}
			if($stat_basic_info['WL_STATION']==1){
				if($sel_hr6_vwl!=""){
					$date_hr6 = "$in_date 06:00:00";
					$ffwc_hr6_res = process_ffwc_data($obj,$date_hr6,$sel_station_id,$sel_hr6_vwl,'W');
					$proccess_status .= "ffwc hr6 insert: $ffwc_hr6_res\n";
					if($stat_wl_id!="" && $is_in_hydro_wl!=0){
						$hydro_hr6_res = process_hydro_wl_data($obj,$date_hr6,$stat_wl_id,$sel_hr6_vwl);
						$proccess_status .= "hydro hr18 insert: $hydro_hr6_res\n";
					}
				}
				if($sel_hr9_vwl!=""){
					$date_hr9 = "$in_date 09:00:00";
					$ffwc_hr9_res = process_ffwc_data($obj,$date_hr9,$sel_station_id,$sel_hr9_vwl,'W');
					$proccess_status .= "ffwc hr9 insert: $ffwc_hr9_res\n";
					if($stat_wl_id!="" && $is_in_hydro_wl!=0){
						$hydro_hr9_res = process_hydro_wl_data($obj,$date_hr9,$stat_wl_id,$sel_hr9_vwl);
						$proccess_status .= "hydro hr9 insert: $hydro_hr9_res\n";
					}
				}
				if($sel_hr12_vwl!=""){
					$date_hr12 = "$in_date 12:00:00";
					$ffwc_hr12_res = process_ffwc_data($obj,$date_hr12,$sel_station_id,$sel_hr12_vwl,'W');
					$proccess_status .= "ffwc hr12 insert: $ffwc_hr12_res\n";
					if($stat_wl_id!="" && $is_in_hydro_wl!=0){
						$hydro_hr12_res = process_hydro_wl_data($obj,$date_hr12,$stat_wl_id,$sel_hr12_vwl);
						$proccess_status .= "hydro hr12 insert: $hydro_hr12_res\n";
					}
				}
				if($sel_hr15_vwl!=""){
					$date_hr15 = "$in_date 15:00:00";
					$ffwc_hr15_res = process_ffwc_data($obj,$date_hr15,$sel_station_id,$sel_hr15_vwl,'W');
					$proccess_status .= "ffwc hr18 insert: $ffwc_hr6_res\n";
					if($stat_wl_id!="" && $is_in_hydro_wl!=0){
						$hydro_hr15_res = process_hydro_wl_data($obj,$date_hr15,$stat_wl_id,$sel_hr15_vwl);
						$proccess_status .= "hydro hr15 insert: $hydro_hr15_res\n";
					}
				}
				if($sel_hr18_vwl!=""){
					$date_hr18 = "$in_date 18:00:00";
					$ffwc_hr18_res = process_ffwc_data($obj,$date_hr18,$sel_station_id,$sel_hr18_vwl,'W');
					$proccess_status .= "ffwc hr18 insert: $ffwc_hr18_res\n";
					if($stat_wl_id!="" && $is_in_hydro_wl!=0){
						$hydro_hr18_res = process_hydro_wl_data($obj,$date_hr18,$stat_wl_id,$sel_hr18_vwl);
						$proccess_status .= "hydro hr18 insert: $hydro_hr18_res\n";
					}
				}
			}
			if($stat_basic_info['RF_STATION']==1){
				if($sel_vrf!=""){
					$date_rf = "$in_date 09:00:00";
					$ffwc_hr9_res = process_ffwc_data($obj,$date_rf,$sel_station_id,$sel_vrf,'R');
					$proccess_status .= "ffwc hr9 update: $ffwc_hr9_res\n";
					if($stat_rf_id!="" && $is_in_hydro_rf!=0){
						$hydro_rf_res = process_hydro_rf_data($obj,$date_rf,$stat_rf_id,$sel_vrf);
						$process_res .= "insert hydrology rainfall: $hydro_rf_res\n";
					}
				}
			}
		}
		//echo $proccess_status;
		$tot_wrong_data = $obj->Total_Count_By_Cond("MDM_WL_RAINFALL_DATA_LOG","STATUS='P' AND DATA_READ_TYPE='M' AND BATCH_NO='$batch_no'");
		$con_close = $obj->close_hydro_orcl_conn();
		echo $ret_msg."#$tot_wrong_data";
	}
	
	if($operation=='delete_faulty_data'){
		$data_arr = [];
		if(strpos($data_list,",")!=""){
			$data_arr = explode(",",$data_list);
		}
		else{
			$data_arr[0] = $data_list;
		}
		$ret_msg = 0;
		for($i=0; $i<count($data_arr); $i++) {
			$table_name='MDM_WL_RAINFALL_DATA_LOG';
			$where_cond="ID='".$data_arr[$i]."'";	
			$del_res = $obj->Delete_Data($table_name,$where_cond);
			if($del_res) {
				$ret_msg = 1;
			}
		}
		$tot_wrong_data = $obj->Total_Count_By_Cond("MDM_WL_RAINFALL_DATA_LOG","STATUS='P' AND DATA_READ_TYPE='M' AND BATCH_NO='$batch_no'");
		$con_close = $obj->close_hydro_orcl_conn();
		echo $ret_msg."#$tot_wrong_data";
	}
	

	function process_ffwc_data($obj,$date_time,$station_id,$value,$type){
		$form_data['M_DATE']="TO_DATE('$date_time','DD-MON-YY HH24:MI:SS')";
		$form_data['STATION_CODE']="'$station_id'";
		$form_data['DATA_VALUE']="'$value'";
		$form_data['D_TYPE']="'$type'";

		$del_cond = "UPPER(STATION_CODE)='$station_id' AND TO_CHAR(M_DATE, 'DD-MON-YY HH24:MI:SS')='$date_time' AND D_TYPE='$type'";
		$del_data = $obj->Delete_Data('FFWC.DATA_TBL',$del_cond);
		$insert_data = $obj->Insert_Data('FFWC.DATA_TBL', $form_data);
		return $insert_data;
	}

	function process_hydro_wl_data($obj,$date_time,$station_id,$wl){
		$user_id = $_SESSION['LOGIN_USERID'];
		$db_ins_date = date('d-M-y H:i:s');
		$db_ins_date = strtoupper($db_ins_date);

		$hydro_form_data['STATION_ID'] = "'$station_id'";
		$hydro_form_data['SWL_DATE'] = "TO_DATE('$date_time','DD-MON-YY HH24:MI:SS')";
		$hydro_form_data['WL'] = "'$wl'";
		$hydro_form_data['DATA_TYPE'] = "'R'";
		$hydro_form_data['INSERT_BY'] = "'$user_id'";
		$hydro_form_data['INSERT_DTM'] = "TO_DATE('$db_ins_date','DD-MON-YY HH24:MI:SS')";
		$hydro_del_cond = "STATION_ID='$station_id' AND TO_CHAR(SWL_DATE, 'DD-MON-YY HH24:MI:SS')='$date_time' AND DATA_TYPE='R'";
		
		//$hydro_del_data = $obj->Delete_Data('HYDROLOGY.SWL_DATA@HYDRO10',$hydro_del_cond);
		//$hydro_ins_data = $obj->Insert_Data('HYDROLOGY.SWL_DATA@HYDRO10', $hydro_form_data);
		//return $hydro_ins_data;
		return 1;
	}

	function process_hydro_rf_data($obj,$date_time,$station_id,$rainfall){
		$user_id = $_SESSION['LOGIN_USERID'];
		$db_ins_date = date('d-M-y H:i:s');
		$db_ins_date = strtoupper($db_ins_date);
		
		$rf_data['STATION_ID'] = "'$station_id'";
		$rf_data['RF_DATE'] = "TO_DATE('$date_time','DD-MON-YY HH24:MI:SS')";
		$rf_data['RAIN_FALL'] = "'$rainfall'";
		$rf_data['UPDT_BY'] = "'$user_id'";
		$rf_data['UPDT_DTM'] = "TO_DATE('$db_ins_date','DD-MON-YY HH24:MI:SS')";
		
		$del_rf_cond_hydro = "STATION_ID='$station_id' AND TO_CHAR(RF_DATE,'DD-MON-YY HH24:MI:SS')='$date_time'";
		//$del_rf_hydro = $obj->Delete_Data('HYDROLOGY.RAIN_FALL_DATA@HYDRO10',$del_rf_cond_hydro);
		//$ins_rf_hydro = $obj->Insert_Data('HYDROLOGY.RAIN_FALL_DATA@HYDRO10', $rf_data);
		//return $ins_rf_hydro;
		return 1;
	}
?>