$(document).ready(function(){
	load();
});

/////////--Validation--/////////
function validateInput(input) {
	var regex = /(\b(on\w+)=|javascript:|(<\s*)(\/*)script)/i;
	if (input.length > 100 || regex.test(input)) {
	  return false;
	}
	return true;
}
/////////--Validation--///////// 

function add_station(){
	$("#add_station").load("module/morphology/add_station_modal.php");
}

function load(){
	$('#cover-spin').show(0);
    $.ajax({
        url:"module/morphology/station_datatable.php",
        datatype:'get',
       // data: datastr,
        success:function(data){
			$('#cover-spin').hide();
			$("#data_to_show").html(data);
        }
    });  
	//$("#data_to_show").load("module/morphology/station_datatable.php");
}	

function form_reset(){
	document.getElementById("add_station_modal").reset();
}

function load_station_vw_modal(sel_stat_id){
	var datastr = "sel_stat_id="+sel_stat_id;
	//alert(datastr);
	$("#model_stat_vw_body").load("module/morphology/morph_station_details_vw.php",datastr);
}

function load_station_edit_modal(sel_stat_id){
	var datastr = "sel_stat_id="+sel_stat_id;
	//alert(datastr);
	$("#model_stat_edit_body").load("module/morphology/morph_station_edit_form.php",datastr);
}

function add_morph_station(){
	var operation =  "insert_morph_station_data";
	var si_no = $('#si_no').val();
	var stat_id =  $('#stat_id').val();
	var stat_name =  encodeURIComponent($('#stat_name').val());
	var river_code =  $('#river_code').val();
	var l_upz_code =  $('#l_upz_code').val();
	var div_code =  $('#div_code').val();
	var vill =  encodeURIComponent($('#vill').val());
	var uni =  encodeURIComponent($('#uni').val());
	var l_lat =  $('#l_lat').val();
	var riv_dist =  $('#riv_dist').val();
	var l_long =  $('#l_long').val();
	var l_north =  $('#l_north').val();
	var l_east =  $('#l_east').val();
	
	var r_lat =  $('#r_lat').val();
	var r_upz_code =  $('#r_upz_code').val();
	var r_long =  $('#r_long').val();
	var r_north =  $('#r_north').val();
	var r_east =  $('#r_east').val();
	var dist =  $('#dist').val();
	var note =  encodeURIComponent($('#note').val());
	var note_val = $('#note').val();
	const note_bytesize = note_val.length;
	if(validateInput(si_no) == false){
		alert('Serial No. Should be a Number');
		$('#si_no').val('');
		$('#si_no').focus();
        return false;
	}
	else if(validateInput(stat_id) == false){
		alert('Please Insert The Station ID correctly');
		$('#stat_id').val('');
		$('#stat_id').focus();
        return false;
	}
	else if(validateInput($('#stat_name').val()) == false){
		alert('Please Insert the Station Name correctly');
		$('#stat_name').val('');
		$('#stat_name').focus();
        return false;
	}
	else if(validateInput($('#vill').val()) == false){
		alert('Please Insert The Village correctly');
		$('#vill').val('');
		$('#vill').focus();
        return false;
	}
	else if(validateInput($('#uni').val()) == false){
		alert('Please Insert The Union correctly');
		$('#uni').val('');
		$('#uni').focus();
        return false;
	}
	else if(validateInput(l_lat) == false){
		alert('Please Insert The Latitude correctly');
		$('#l_lat').val('');
		$('#l_lat').focus();
        return false;
	}
	else if(validateInput(riv_dist) == false){
		alert('Please Insert The River Distance correctly');
		$('#riv_dist').val('');
		$('#riv_dist').focus();
        return false;
	}
	else if(validateInput(l_long) == false){
		alert('Please Insert The Longitude correctly');
		$('#l_long').val('');
		$('#l_long').focus();
        return false;
	}
	else if(validateInput(l_north) == false){
		alert('Please Insert The Northing correctly');
		$('#l_north').val('');
		$('#l_north').focus();
        return false;
	}
	else if(validateInput(l_east) == false){
		alert('Please Insert The Easting correctly');
		$('#l_east').val('');
		$('#l_east').focus();
        return false;
	}
	else if(validateInput(r_lat) == false){
		alert('Please Insert The Latitude correctly');
		$('#r_lat').val('');
		$('#r_lat').focus();
        return false;
	}
	else if(validateInput(r_long) == false){
		alert('Please Insert The Longitude correctly');
		$('#r_long').val('');
		$('#r_long').focus();
        return false;
	}
	else if(validateInput(r_north) == false){
		alert('Please Insert The Northing correctly');
		$('#r_north').val('');
		$('#r_north').focus();
        return false;
	}
	else if(validateInput(r_east) == false){
		alert('Please Insert The Easting correctly');
		$('#r_east').val('');
		$('#r_east').focus();
        return false;
	}
	else if(validateInput(dist) == false){
		alert('Please Insert The Distance correctly');
		$('#dist').val('');
		$('#dist').focus();
        return false;
	}
	else if(validateInput(note_val) == false){
		alert('Please Insert Note correctly');
		$('#note').val('');
		$('#note').focus();
        return false;
	}
	else if (note_val.match(/[$&+,:;=?[\]@#|{}'<>.^*()%!-/]/,"")){
		alert('Please Check The Note Format');
		$('#note').val('');
		$('#note').focus();
        return false;
	}
	else if(note_bytesize > 200){
		alert("Note Length Cannot Be More Than 200 Bytes");
		$('#note').val('');
		$('#note').focus();
        return false;
	}
	else{
		var datastr = "operation="+operation+"&si_no="+si_no+"&stat_id="+stat_id+"&stat_name="+stat_name+
		"&river_code="+river_code+"&l_upz_code="+l_upz_code+"&div_code="+div_code+	
		"&vill="+vill+"&uni="+uni+"&l_lat="+l_lat+"&riv_dist="+riv_dist+"&l_long="+l_long+
		"&l_north="+l_north+"&l_east="+l_east+"&r_lat="+r_lat+"&r_upz_code="+r_upz_code+	
		"&r_long="+r_long+"&r_north="+r_north+"&r_east="+r_east+"&dist="+dist+	
		"&note="+note;
	}

	//alert(datastr);
//	$('#cover-spin').show(0);
    $.ajax({
        url:"module/morphology/morph_station_ajax.php",
        datatype:'post',
		data: datastr,
        success:function(data){
		//	$('#cover-spin').hide();
			//alert(data);
			if(data==1){
				alert('Information has been updated successfully');
				$('#modal_station').modal('hide');
				load();
			}
			else{
				alert('error occurred');
			}
        }
    });
}

function update_morph_station(){
	var operation =  "update_morph_station_data";
	var e_si_no = $('#e_si_no').val();
	var e_old_stat_id =  $('#e_old_stat_id').val();
	var e_stat_id =  $('#e_stat_id').val();
	var e_stat_name =  encodeURIComponent($('#e_stat_name').val());
	var e_river_code =  $('#e_river_code').val();
	var e_l_upz_code =  $('#e_l_upz_code').val();
	var e_div_code =  $('#e_div_code').val();
	var e_vill =  encodeURIComponent($('#e_vill').val());
	var e_uni =  encodeURIComponent($('#e_uni').val());
	var e_l_lat =  $('#e_l_lat').val();
	var e_riv_dist =  $('#e_riv_dist').val();
	var e_l_long =  $('#e_l_long').val();
	var e_l_north =  $('#e_l_north').val();
	var e_l_east =  $('#e_l_east').val();
	
	var e_r_lat =  $('#e_r_lat').val();
	var e_r_upz_code =  $('#e_r_upz_code').val();
	var e_r_long =  $('#e_r_long').val();
	var e_r_north =  $('#e_r_north').val();
	var e_r_east =  $('#e_r_east').val();
	var e_dist =  $('#e_dist').val();
	var e_note =  encodeURIComponent($('#e_note').val());
	var note_val = $('#e_note').val();
	const note_bytesize = note_val.length;
	if(validateInput(e_si_no) == false){
		alert('Serial No. Should be a Number');
		$('#e_si_no').val('');
		$('#e_si_no').focus();
        return false;
	}
	else if(validateInput(e_stat_id) == false){
		alert('Please Insert The Station ID correctly');
		$('#e_stat_id').val('');
		$('#e_stat_id').focus();
        return false;
	}
	else if(validateInput($('#e_stat_name').val()) == false){
		alert('Please Insert the Station Name correctly');
		$('#e_stat_name').val('');
		$('#e_stat_name').focus();
        return false;
	}
	else if(validateInput($('#e_vill').val()) == false){
		alert('Please Insert The Village correctly');
		$('#e_vill').val('');
		$('#e_vill').focus();
        return false;
	}
	else if(validateInput($('#e_uni').val()) == false){
		alert('Please Insert The Union correctly');
		$('#e_uni').val('');
		$('#e_uni').focus();
        return false;
	}
	else if(validateInput(e_l_lat) == false){
		alert('Please Insert The Latitude correctly');
		$('#e_l_lat').val('');
		$('#e_l_lat').focus();
        return false;
	}
	else if(validateInput(e_riv_dist) == false){
		alert('Please Insert The River Distance correctly');
		$('#e_riv_dist').val('');
		$('#e_riv_dist').focus();
        return false;
	}
	else if(validateInput(e_l_long) == false){
		alert('Please Insert The Longitude correctly');
		$('#e_l_long').val('');
		$('#e_l_long').focus();
        return false;
	}
	else if(validateInput(e_l_north) == false){
		alert('Please Insert The Northing correctly');
		$('#e_l_north').val('');
		$('#e_l_north').focus();
        return false;
	}
	else if(validateInput(e_l_east) == false){
		alert('Please Insert The Easting correctly');
		$('#e_l_east').val('');
		$('#e_l_east').focus();
        return false;
	}
	else if(validateInput(e_r_lat) == false){
		alert('Please Insert The Latitude correctly');
		$('#e_r_lat').val('');
		$('#e_r_lat').focus();
        return false;
	}
	else if(validateInput(e_r_long) == false){
		alert('Please Insert The Longitude correctly');
		$('#e_r_long').val('');
		$('#e_r_long').focus();
        return false;
	}
	else if(validateInput(e_r_north) == false){
		alert('Please Insert The Northing correctly');
		$('#e_r_north').val('');
		$('#e_r_north').focus();
        return false;
	}
	else if(validateInput(e_r_east) == false){
		alert('Please Insert The Easting correctly');
		$('#e_r_east').val('');
		$('#e_r_east').focus();
        return false;
	}
	else if(validateInput(e_dist) == false){
		alert('Please Insert The Distance correctly');
		$('#e_dist').val('');
		$('#e_dist').focus();
        return false;
	}
	else if(validateInput(note_val) == false){
		alert('Please Insert Note correctly');
		$('#e_note').val('');
		$('#e_note').focus();
        return false;
	}
	else if (note_val.match(/[$&+,:;=?[\]@#|{}'<>.^*()%!-/]/,"")){
		alert('Please Check The Note Format');
		$('#e_note').val('');
		$('#e_note').focus();
        return false;
	}
	else if(note_bytesize > 200){
		alert("Note Length Cannot Be More Than 200 Bytes");
		$('#e_note').val('');
		$('#e_note').focus();
        return false;
	}
	else{
		var datastr = "operation="+operation+"&e_si_no="+e_si_no+"&e_stat_id="+e_stat_id+"&e_stat_name="+e_stat_name+
		"&e_river_code="+e_river_code+"&e_r_upz_code="+e_r_upz_code+"&e_l_upz_code="+e_l_upz_code+	
		"&e_r_lat="+e_r_lat+"&e_div_code="+e_div_code+"&e_r_long="+e_r_long+"&e_vill="+e_vill+	
		"&e_r_north="+e_r_north+"&e_uni="+e_uni+"&e_r_east="+e_r_east+"&e_l_lat="+e_l_lat+	
		"&e_dist="+e_dist+"&e_l_long="+e_l_long+"&e_l_north="+e_l_north+"&e_l_east="+e_l_east+	
		"&e_riv_dist="+e_riv_dist+"&e_note="+e_note+"&e_old_stat_id="+e_old_stat_id;
		
	}
	//alert(datastr);
	//$('#cover-spin').show(0);
    $.ajax({
        url:"module/morphology/morph_station_ajax.php",
        datatype:'post',
		data: datastr,
        success:function(data){
			//$('#cover-spin').hide();
			//alert(data);
			if(data==1){
				alert('Information has been updated successfully');
				$('#modal-stat-edit').modal('hide');
				load();
			}
			else{
				alert('error occurred');
			}
        }
    });  
}