function load_morphology_river_name_by_station_id(sel_river_id) {
    //alert('load_morphology_river_name_by_station_id');
    var station_arr = sel_river_id.split("#");
    var river_code = station_arr[0];
    var station_id = station_arr[1];

    var datastr = "sel_river_id=" + river_code + "&station_id=" + station_id;
    //alert(datastr);
    $.ajax({
        url: 'module/morphology/morphology_river_name_by_station_id.php',
        type: 'get',
        data: datastr,
        success: function (data) {
            var values = data.split("#");
            $("#river_name").val(values[0]);
            $("#station_name_holder").val(values[1]);
        }
    });
}


function loadDeForm() {
    //	alert('loadDeForm');
    $('#view_mp_data').html("");
    $('#curve_chart').html("");
    $('#act_tab_name').val('data_entry');
    $('.nav-tabs a[href="#data_list"]').tab('show');
}

function loadExcelData() {
    //alert('loadExcelData');
    $('#view_mp_data').html("");
    $('#curve_chart').html("");
    $('#act_tab_name').val('data_upload');
    $('.nav-tabs a[href="#data_list"]').tab('show');
}






function flushData() {
    $('#view_mp_data').html("");
}


//show data
function load_morphology_info() {
    // alert('load_morphology_info');
    var station = $('#mor_station').val();
    var station_arr = station.split("#");
    var river_code = station_arr[0];
    var station_id = station_arr[1];

    //alert(station_id );
    river_name = $('#river_name').val();
    //alert(river_name );
    year = $('#year').val();
    //alert(year );
    var datastr = "river_name=" + river_name + "&station=" + station_id + "&year=" + year;
    //alert(datastr);

    $('#cover-spin').show(0);
    $.ajax({
        url: 'module/morphology/morphology_upload_datatable.php',
        datatype: 'get',
        data: datastr,
        success: function (data) {
            // alert(data);
            $('#cover-spin').hide();
            //for hidden save all
            //$("#mp_save_btn").css({"display":"block"});
            $("#view_mp_data").html(data);
            $('#distance_1').select();

        }
    });


}

function morphology_delete(){
	//alert('morphology_delete');
    var station = $('#mor_station').val();
    var station_arr = station.split("#");
    var river_code = station_arr[0];
    var station_id = station_arr[1];
    var year = $('#year').val();
	var operation = "delete_all_data";
    var datastr = "station="+station_id+"&year="+year+"&operation="+operation;
    //alert(datastr);
	$('#cover-spin').show(0);
	$.ajax({
		url: 'module/morphology/morphology_information_ajax.php',
		type: 'post',
		data: datastr,
		cache: false,
		success: function (result) {
			//alert(result);
			if (result) {
				alert('Data has been deleted successfully');
				load_morphology_info();
			} else {
				alert('Fail to delete data');
			}
			$('#cover-spin').hide();
			// Invoke the callback function
		}
	});
}

function saveData(sel_day, max_loop_length, sv_count, callback) {
    if (sel_day <= max_loop_length) {
        var station = $('#station_' + sel_day).val();
        var startdt = $('#startdt_' + sel_day).val();
        var serialno = $('#serialno_' + sel_day).val();
        var distance = $('#distance_' + sel_day).val();
        var rl = $('#rl_' + sel_day).val();
        var note = $('#note_' + sel_day).val();
        var operation = "single_row_save";

        if (sel_day === 1) {
            operation = "w";
        } else {
            operation = "a";
        }

        var wr_datastr = "station_id=" + station + "&startdt=" + startdt + "&serialno=" + serialno + "&distance=" + distance +
            "&rl=" + rl + "&note=" + note + "&operation=" + operation;
        $('#cover-spin').show(0);
        $.ajax({
            url: 'module/morphology/morph_info_writer.php',
            type: 'post',
            data: wr_datastr,
            cache: false,
            success: function (result) {
                // AJAX request succeeded, you can handle the result here
                sv_count++;
                saveData(sel_day + 1, max_loop_length, sv_count, callback);
            },
            error: function () {
                // Handle AJAX error
                alert('Failed to save data');
            }
        });
    } else {
        // All data has been processed
        var operation = "single_row_save";
        var datastr = "operation=" + operation;
        $('#cover-spin').show(0);

        $.ajax({
            url: 'module/morphology/morphology_information_ajax.php',
            type: 'post',
            data: datastr,
            cache: false,
            success: function (result) {
                if (result) {
                    alert('Data has been saved successfully. Total data saved: ' + sv_count);
                } else {
                    alert('Fail to save data');
                }
                $('#cover-spin').hide();
                // Invoke the callback function
                if (typeof callback === 'function') {
                    callback(sv_count);
                }
            },
            error: function () {
                alert('Failed to save data');
                $('#cover-spin').hide();
            }
        });
    }
}

function morphology_save() {
  	var mor_station_id_list = $(".mor_station_id").map(function () {
        return $(this).val();
    }).get().join("#");
//	alert(mor_station_id_list);
	var mor_start_dt_list = $(".mor_start_dt").map(function () {
        return $(this).val();
    }).get().join("#");
//	alert(mor_start_dt_list);
	var mor_serial_no_list = $(".mor_serial_no").map(function () {
        return $(this).val();
    }).get().join("#");
//	alert(mor_serial_no_list);
	var mor_distance_list = $(".mor_distance").map(function () {
        return $(this).val();
    }).get().join("#");
//	alert(mor_distance_list);
	var mor_rl_val_list = $(".mor_rl_val").map(function () {
        return $(this).val();
    }).get().join("#");
//	alert(mor_rl_val_list);
	var mor_note_list = $(".mor_note").map(function () {
        return encodeURI($(this).val());
    }).get().join("#");
//	alert(mor_note_list);
	var operation = "approve_multiple_morph_value";
	var datastr = "mor_station_id_list="+mor_station_id_list+"&mor_start_dt_list="+mor_start_dt_list+
	"&mor_serial_no_list="+mor_serial_no_list+"&mor_distance_list="+mor_distance_list+
	"&mor_rl_val_list="+mor_rl_val_list+"&mor_note_list="+encodeURI(mor_note_list)+"&operation="+operation;
//	alert(datastr);
	$('#cover-spin').show(0);

	$.ajax({
		url: 'module/morphology/morphology_information_ajax.php',
		type: 'post',
		data: datastr,
		cache: false,
		success: function (result) {
			//alert(result);
			if (result) {
				alert('Data has been saved successfully. Total data saved: ' + result);
			} else {
				alert('Fail to save data');
			}
			$('#cover-spin').hide();
			// Invoke the callback function
		}
	});
}



function load_mph_graph() {
    var station = $('#mor_station').val();
    var station_arr = station.split("#");
    var station_id = station_arr[1];
    var year = $('#year').val();
    var river_name= $('#river_name').val();

    var to_year = $('#to_year').val();
    var datastr = "station=" + station_id + "&year=" + year + "&to_year=" + to_year;

    $.ajax({
        type: "post",
        url: "module/morphology/morphology_graph.php",
        data: datastr,
        success: function (str) {
            if ($.trim(str)) {
                console.log(str);
                $('#cover-spin').hide();

                var data = $.parseJSON(str);

                // Destroy existing chart instance if it exists
                let chartStatus = Chart.getChart("linechart"); // <canvas> id
                if (chartStatus !== undefined) {
                    chartStatus.destroy();
                }

                // Restructure data for Chart.js
                var chartData = {
                    labels: [], // Array to store x-axis labels (distances)
                    datasets: [],
                };

                // Extract dates from the data
                var dates = Object.keys(data);

                // Iterate through the dates in the data
                for (var i = 0; i < dates.length; i++) {
                    var date = dates[i];
                    var distances = data[date].map(function (item) {
                        return item[0]; // Extracting the first value (distance)
                    });

                    // Add distances to the labels array
                    chartData.labels = distances;

                    // Extract RL values for the current date
                    var rlValues = data[date].map(function (item) {
                        return item[1]; // Extracting the second value (RL value)
                    });

                    // Add a dataset for the current date
                    chartData.datasets.push({
                        label: date,
                        data: rlValues,
                        fill: false,
                        borderColor: getRandomColor(),
                        spanGaps: true,
                        // pointRadius: 5, // Adjust the point size as needed
                        // pointHoverRadius: 7, // Adjust the point size on hover as needed
                    });
                }

                // Chart configuration
                var ctx = document.getElementById("linechart").getContext("2d");
                lineChart = new Chart(ctx, {
                    type: "line",
                    data: chartData,
                    options: {
                        scales: {
                            x: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'Distance (m)', // x-axis label
                                },
                            },
                            y: {
                                display: true,
                                title: {
                                    display: true,
                                    text: 'RL (m)', // y-axis label
                                },
                            },
                        },
                        plugins: {
                            title: {
                                display: true,
                                text: 'Yearly Comparison Morphology From ' + year + ' to ' + to_year +                '    Station Id:'+station_id+     '   River Name:'+river_name,
                                font: {
                                    size: 18 // Adjust the font size as needed
                                },
                            },
                            tooltip: {
                                callbacks: {
                                    title: function (tooltipItems) {
                                        // Display distance in the tooltip title
                                        var dataIndex = tooltipItems[0].dataIndex;
                                        var dateLabel = chartData.labels[dataIndex];
                                        return 'Distance: ' + dateLabel;
                                    },
                                    label: function (context) {
                                        // Display line label, date, and RL value in the tooltip body with a line break
                                        var lineLabel = chartData.datasets[context.datasetIndex].label;
                                        return [lineLabel + ', RL: ' + context.parsed.y + ' m'];
                                    },
                                },
                            },

                        },
                        // Add custom footer
                        // afterDraw: function (chart) {
                        //     var ctx = chart.ctx;
                        //     ctx.fillStyle = 'black';
                        //     ctx.textAlign = 'center';
                        //     ctx.fillText('This is footer', chart.width / 2, chart.height - 10);
                        // }
                        // Your other chart options here
                    },
                });

            }
        }
    });

    // Function to generate a random color for the chart line
    function getRandomColor() {
        var letters = '0123456789ABCDEF';
        var color = '#';
        for (var i = 0; i < 6; i++) {
            color += letters[Math.floor(Math.random() * 16)];
        }
        return color;
    }
}


//print graph strat

// Function to download the chart as a JPEG image with a white background
function download_morphology_graph_chart() {
	//alert('download_morphology_graph_chart');
	var chartContainer = document.getElementById('linechart');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'Morphology Graph';
			link.click();
		});
	});
}
//print graph end