<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
extract($_POST);

$cond = " STATION_ID='$station' AND TO_CHAR(START_DT, 'YYYY') BETWEEN '$year' AND '$to_year' ORDER BY START_DT ASC";
$res = array();
$allDistances = array();

foreach ($obj->View_colmn_By_Cond("HYDROLOGY.CS_DATA@HYDRO10", "DISTANCE,RL_VAL, START_DT", $cond) as $morph_info) {
    $dis_val = $morph_info['DISTANCE'];
    $dis_rl = $morph_info['RL_VAL'];
    $date = date('Y-m-d', strtotime($morph_info['START_DT']));

    if (!isset($res[$date])) {
        $res[$date] = array();
    }

    $res[$date][] = array($dis_val, $dis_rl);
    $allDistances[] = $dis_val;
}

sort($allDistances);
$maxArrayLength = count($allDistances);

foreach ($res as &$dateData) {
    $currentDistances = array_column($dateData, 0); // Extract distances from dateData

    for ($i = 0; $i < $maxArrayLength; $i++) {
        $currentDistance = $allDistances[$i];

        if (!in_array($currentDistance, $currentDistances)) {
            $dateData[] = array($currentDistance, null); // Assign null to RL value
        }
    }

    usort($dateData, function ($a, $b) {
        return $a[0] - $b[0]; // Sort by distance
    });
}

if (count($res) > 0) {
    echo $datas = json_encode($res);
} else {
    $res[] = array('', '');
    echo $datas = json_encode($res);
}
?>
