<?php 
session_start();
//echo "hello" ;
?>

<style type="text/css">
    #map{
        width: 100%;
        height: 100vh;
    }
    .map-info-box {
        background-color: #fff;
        border: 1px solid #d3d3d3;
        width: 250px;
        padding: 10px;
        border-radius: 12px;
        z-index: 500;
        position: absolute;
        right: 8px;
        top: 8px;
        cursor: auto;
        display: none; /* Initially hide the info box */
    }
    .close {
        font-size: 25px;
        font-weight: 600;
        cursor: pointer;
        float: right;
    }
</style>

<link rel="stylesheet" href="http://cdn.leafletjs.com/leaflet-0.7.3/leaflet.css" />
<script src="http://cdn.leafletjs.com/leaflet-0.7.3/leaflet.js"></script>
<!-- <script src = "module/ground_water_ex/js/leaflet-providers.js"></script> -->

<div id="cover-spin"></div>

<div id="map" style="width: 100%; height: 600px">
   
    <div id="map-dis" class="map-info-box">
        <span class="close" onclick="closeMapInfoBox()">&times;</span>
        <div id="pointer"></div>
    </div>
</div>

<?php 
$district_name  ='Feni';
$lat            ='23.023231';
$lon            ='91.3840844';
$districts = [
	['name' => $district_name, 'lat' =>$lat, 'lon' =>$lon ],
     // ['name' => 'Dhaka', 'lat' => 23.023231, 'lon' => 90.4125],
     //['name' => 'Chittagong', 'lat' => 22.3569, 'lon' => 91.7832],
    // Add more districts with their respective coordinates here
    // ...
];
?>
<script>
    // Initialize the map
    //icon part
    var map = L.map('map').setView([23.8103, 90.4125], 7, {icon: greenIcon});
    var greenIcon = L.icon({
        iconUrl: 'http://www.hydrology.bwdb.gov.bd/map_icons/green.png',
        iconSize:     [15, 25], // size of the icon		
	});

    // Add the OpenStreetMap tile layer to the map
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        // attribution: 'Map data © OpenStreetMap contributors',
        maxZoom: 18
    }).addTo(map);

    // Common coordinates for the markers

    // Add markers for each district with popups on hover
    var districts = <?php echo json_encode($districts); ?>;
    var mapInfoBox = document.getElementById('map-dis');
    var pointer = document.getElementById('pointer');

    for (var i = 0; i < districts.length; i++) {
        var district = districts[i];
        var marker = L.marker([district.lat, district.lon], {icon: greenIcon}).addTo(map);

        // Create and bind a popup to the marker
        marker.bindPopup("<h4>"+district.name+"</h4><p> This is the trail Popup</p>", { autoPan: false });
        
        // Function to show the map-info-box on marker hover
        marker.on('mouseover', function(e) {
            mapInfoBox.style.display = 'block'; // Show the info box
            pointer.innerHTML = this.getPopup().getContent();
        });
        marker.off('click');
        marker.on('click', function() {return;});

    }
    
    // Function to close the map-info-box
    function closeMapInfoBox() {
        mapInfoBox.style.display = 'none';
    }
</script>

