<?php
session_start();
include ("../../php_crud/my_class.php");
$obj = new my_class();
extract($_REQUEST);
$mn_yr = $month . '-' . $year;

$rf_tbl = 'HYDROLOGY.RAIN_FALL_DATA@HYDRO10';
$rf_cond = "STATION_ID='$station_id' AND TO_CHAR(RF_DATE, 'MM-YYYY')='$mn_yr'";
$rf_col = "COUNT(*) AS TOT_RAIN_FALL";
$rf_info = $obj->View_column_details_By_Cond($rf_tbl, $rf_col, $rf_cond);
//echo $rf_info['TOT_RAIN_FALL']; 
$month_day = cal_days_in_month(CAL_GREGORIAN, $month, $year);
$curr_date = date('d-M-Y');
$curr_year = date('Y');
$curr_mon = date('m');

$sel_mon_year = $year . "" . $month . "01";
$sel_mon_year = date("Ym", strtotime($sel_mon_year));

$curr_mon_year = $curr_year . "" . $curr_mon;
$curr_mon_year = date("Ym", strtotime($curr_mon_year));

if ($sel_mon_year > $curr_mon_year) {
	echo "<h2 style='color: red; text-align: center;'>You can only see data till running month.</h2>";
} else {
	if ($rf_info['TOT_RAIN_FALL'] == 0) {
		echo "<h2 style='color: red; text-align: center;'>No record found for rainfall data. Please enter rainfall data first.</h2>";
	} else {

		?>

		<style>
			select,
			input[type="text"] {
				display: inline-block;
				height: 1px !important;
				padding: 8px 3px !important;
				margin-bottom: 2px !important;
				font-size: 13px !important;
				line-height: 23px !important;
				color: #555;
				vertical-align: middle;
				-webkit-border-radius: 4px;
				-moz-border-radius: 4px;
				border-radius: 4px;
			}

			.table th,
			.table td {
				padding: 2px !important;
				line-height: 20px;
				text-align: center;
				vertical-align: top;
				border-top: 1px solid #ddd;
			}

			.tbl_border {
				border: 1px solid #ddd;
			}
		</style>
		<div class="row-fluid" style="margin-bottom:10px; margin-top:-16px!important;">
			<div class="span4">
				<div class="control-group" style="float:right;">
					<div class="controls">
						<?php
						if ($_SESSION['delete'] == 'Y') {
							echo '<button id="evaporation_delete_btn" type="button" style="margin-right: 1px; font-size: 12px; float: right;" class="btn btn-small btn-danger" onclick="evaporation_delete_all()"><i class="icon-trash"></i><b>Delete All</b></button>';
						}
						?>
						<button id="hidden-btn" style="float: right; margin-right: 2px;" class="btn btn-small btn-success"
							type="button" onclick="multiple_save()"><i class="icon-save"></i> <b style="font-size: 12px;">Save
								All</b></button>
					</div>
				</div>
				<table id="ei_data_table" class="table table-bordered table-hover" style="margin-top: 40px;">
					<thead>
						<tr style="font-family: 'Open Sans';">
							<td style="width: 25%; text-align: center; border: 1px solid #ddd; font-size:13px;"
								class="table-header">Date</td>
							<td style="width: 30%; text-align: center; border: 1px solid #ddd; font-size:13px;"
								class="table-header">Cup Add/Remove</td>
							<td style="width: 25%; text-align: center; border: 1px solid #ddd; font-size:13px;"
								class="table-header">Rainfall (mm)</td>
							<td style="width: 45%; text-align: center; border: 1px solid #ddd; font-size:13px;"
								class="table-header">Evaporation (mm)</td>
						</tr>
					</thead>

					<tbody class="tbl_border">
						<?php
						$tot_add_cup = 0;
						$tot_rem_cup = 0;
						$month_day = cal_days_in_month(CAL_GREGORIAN, $month, $year);

						$is_readonly = "";
						$call_key_up_function = "";

						for ($d = 1; $d <= $month_day; $d++) {
							$time = mktime(12, 0, 0, $month, $d, $year);
							if (date('m', $time) == $month) {
								$show_date = date('d-M-Y', $time);
								$show_date = strtoupper($show_date);
								//echo $show_date;
								$table_name = 'HYDROLOGY.EVAPORATION_CUP_TBL@HYDRO10';
								$ei_cond = "STATION_ID='$station_id' AND TO_DATE(DT, 'DD-MON-RR')='$show_date'";
								$cup_col = "TO_DATE(DT, 'DD-MON-RR') AS EI_DATE, CUP_ADD_REMOVE";
								$ei_info = $obj->View_column_details_By_Cond($table_name, $cup_col, $ei_cond);

								$table2_name = 'HYDROLOGY.EVAPORATION_TBL@HYDRO10';
								$ei2_cond = "STATION_ID='$station_id' AND TO_DATE(DT, 'DD-MON-RR')='$show_date'";
								$evaporation_col = "TO_DATE(DT, 'DD-MON-RR') AS EI_DATE, EVAPORATION";
								$ei2_info = $obj->View_column_details_By_Cond($table2_name, $evaporation_col, $ei2_cond);

								//rainfall start
								$rf_cond = "STATION_ID='$station_id' AND TO_CHAR(RF_DATE, 'DD-MON-YYYY')='$show_date'";
								$rf_cols = "RAIN_FALL";
								$rf_info = $obj->View_column_details_By_Cond("HYDROLOGY.RAIN_FALL_DATA@HYDRO10", $rf_cols, $rf_cond);
								//echo $rf_info['RAIN_FALL'];
								//rainfall end
								if ($ei2_info['EVAPORATION'] != "") {
									$eva_val = number_format((float) $ei2_info['EVAPORATION'], 4, '.', '');
								} else {
									$eva_val = "";
								}
								$cup_add_cond = "STATION_ID='$station_id' AND TO_DATE(DT, 'DD-MON-RR')='$show_date' AND CUP_ADD_REMOVE >= 0";
								$cup_col = "TO_DATE(DT, 'DD-MON-RR') AS SUM_POSITIVE, CUP_ADD_REMOVE";
								$cup_add_info = $obj->View_column_details_By_Cond($table_name, $cup_col, $cup_add_cond);
								$tot_add_cup = $tot_add_cup + $cup_add_info['CUP_ADD_REMOVE'];

								$cup_remove_cond = "STATION_ID='$station_id' AND TO_DATE(DT, 'DD-MON-RR')='$show_date' AND CUP_ADD_REMOVE <= 0";
								$cup_col = "TO_DATE(DT, 'DD-MON-RR') AS SUM_NEGATIVE, CUP_ADD_REMOVE";
								$cup_remove_info = $obj->View_column_details_By_Cond($table_name, $cup_col, $cup_remove_cond);
								$tot_rem_cup = $tot_rem_cup + $cup_remove_info['CUP_ADD_REMOVE'];

								$tot_cup = $tot_add_cup + $tot_rem_cup;
								$tot_cup = number_format((float) $tot_cup, 2, '.', '');
								$date_id = "date_$d";
								$ci_col_id = "ci_$d";
								$ei_col_id = "ei_$d";
								$ra_col_id = "ra_$d";

								$next_row_val = $d + 1;
								$next_row_val = "ci_$next_row_val";

								if (strtotime($show_date) > strtotime($curr_date)) {
									$is_readonly = "readonly";
									$call_key_up_function = "show_alert(event)";
								} else {
									$is_readonly = "";
									$call_key_up_function = "ei_call_next_val_loader(event,'$ci_col_id','$next_row_val','$d')";
								}
								// if ($rf_info['RAIN_FALL'] == '0' && $ei_info['CUP_ADD_REMOVE'] < 0){
								// 	// if ($ei_info['CUP_ADD_REMOVE'] < 0) {
								// 		echo "Cannot provide a negative value for Cup Add Remove when Rainfall is 0.";	
								// 	// }
								// }
								?>
								<tr>
									<td style="text-align: center;" class="tbl_border">
										<input type="text" id="<?php echo $date_id; ?>" class="input-small month_date"
											style="text-align: center; font-weight: 700;" value="<?php echo $show_date; ?>" readonly>
									</td>

									<td style="text-align: center;" class="tbl_border">
										<input onkeypress="isNumericInput(event)" type="text" class="input-mini cup"
											style="text-align: center; font-weight: bold;" id="<?php echo $ci_col_id; ?>"
											value="<?php echo $ei_info['CUP_ADD_REMOVE']; ?>"
											onkeyup="<?php echo $call_key_up_function; ?>" <?php echo $is_readonly; ?>>
									</td>
									<td style="text-align: center;" class="tbl_border">
										<input type="text" class="input-small rainfall" style="text-align: center; font-weight: 700;"
											id="<?php echo $ra_col_id; ?>" value="<?php echo $rf_info['RAIN_FALL']; ?>" readonly>
									</td>
									<td style="text-align: center;" class="tbl_border">
										<input type="text" class="evaporation" style="text-align: center; font-weight: bold;"
											id="<?php echo $ei_col_id; ?>" value="<?php echo $eva_val; ?>" readonly>
									</td>
								</tr>
							<?php }
						} ?>
					</tbody>

					<tfoot>
						<tr class="tbl_border">
							<td style="text-align: center; border: 1px solid #ddd; font-size:13px;" class="table-header">Cup
								Added</td>
							<td style="text-align: center; border: 1px solid #ddd; font-size:13px;" class="table-header"><input
									type="text" class="input-mini" style="text-align: center; font-weight: bold;"
									id="tot_add_cup_in" value="<?php echo $tot_add_cup; ?>" readonly></td>
							<td style="border: 1px solid #ddd; font-size:13px;" class="table-header"></td>
							<td style="border: 1px solid #ddd; font-size:13px;" class="table-header"></td>
						</tr>
						<tr class="tbl_border">
							<td style="text-align: center; border: 1px solid #ddd; font-size:13px;" class="table-header">Cup
								Removed</td>
							<td style="text-align: center; border: 1px solid #ddd; font-size:13px;" class="table-header"><input
									type="text" class="input-mini" style="text-align: center; font-weight: bold;"
									id="tot_rem_cup_in" value="<?php echo $tot_rem_cup; ?>" readonly></td>
							<td style="border: 1px solid #ddd; font-size:13px;" class="table-header"></td>
							<td style="border: 1px solid #ddd; font-size:13px;" class="table-header"></td>
						</tr>
						<tr class="tbl_border">
							<td style="text-align: center; border: 1px solid #ddd; font-size:13px;" class="table-header">Total
								Cup</td>
							<td style="text-align: center; border: 1px solid #ddd; font-size:13px;" class="table-header"><input
									type="text" class="input-mini" style="text-align: center; font-weight: bold;"
									id="tot_cup_in" value="<?php echo $tot_cup; ?>" readonly></td>
							<td style="border: 1px solid #ddd; font-size:13px;" class="table-header"></td>
							<td style="border: 1px solid #ddd; font-size:13px;" class="table-header"></td>
						</tr>


					</tfoot>
				</table>

				<?php
				if ($_SESSION['delete'] == 'Y') {
					echo '<button id="evaporation_delete_btn" type="button" style="margin-right: 1px; font-size: 12px; float: right;" class="btn btn-small btn-danger" onclick="evaporation_delete_all()"><i class="icon-trash"></i><b>Delete All</b></button>';
				}
				?>
				<button id="hidden-btn" style="float: right; margin-right: 2px;" class="btn btn-small btn-success" type="button"
					onclick="multiple_save()"><i class="icon-save"></i> <b style="font-size: 12px;">Save All</b></button>
			</div>
			<div class="span4">

			</div>
			<div class="span4"></div>
		</div>
		<?php
	}
}
?>

<script>
	let inputReset = false; // Track whether input should be reset

	function isNumericInput(event) {
		const key = event.keyCode || event.which;
		const keyChar = String.fromCharCode(key)
			;

		const regex = /[0-9]|\.|\-/;

		// Only allow numeric, decimal, or minus sign input
		if (!regex.test(keyChar)) {
			event.preventDefault();
			return false;
		}

		const input = event.target;
		const currentValue = input.value;

		// If the input already contains a decimal point or minus sign, disallow another one
		if ((keyChar === "." && currentValue.indexOf(".") !== -1) ||
			(keyChar === "-" && currentValue.indexOf("-") !== -1)) {
			event.preventDefault();
			event.target.value = "";
			event.target.value += keyChar;
			return false;
		}

		// If the input would result in a value less than -99.99 or greater than 99.99, disallow it
		const newValue = parseFloat(currentValue + keyChar).toFixed(2);
		if (newValue < -999.99 || newValue > 999.99) {
			event.preventDefault();
			return false;
		}

		// If input should be reset, do so and allow new input
		if (inputReset) {
			input.value = "";
			inputReset = false;
		}

		// If the input would result in more than 2 decimal places, set inputReset flag
		const parts = currentValue.split(".");
		if (parts.length === 2 && parts[1].length >= 2 && keyChar !== "-") {
			event.preventDefault();
			event.target.value = "";
			event.target.value += keyChar;
			return false;
		}

		if (currentValue === "0" && keyChar !== "." && keyChar !== "-" && currentValue.indexOf(".") === -1) {
			event.preventDefault();
			return false;
		}

		return true;
	}
</script>


<script>
	function ei_call_next_val_loader(e, ci_col_id, next_col_id, sel_day) {
		//alert('calling');
		if (event.keyCode == 13 || event.keyCode == 'tab') {
			var curr_val = $("#" + ci_col_id).val();

			if (curr_val > Math.floor(curr_val)) {
				curr_val = parseFloat(curr_val).toFixed(2);
				//alert(curr_val);
			}
			$("#" + ci_col_id).val(curr_val);
			$("#" + next_col_id).select();
		}

		var pos_sum = 0;
		var neg_sum = 0;
		$(".cup").each(function () {
			//alert($(this).val()) ;
			var sel_cup_in = parseFloat($(this).val());
			if (!isNaN(sel_cup_in)) {
				if (sel_cup_in >= 0) {
					pos_sum += sel_cup_in;
				}
				else {
					neg_sum += sel_cup_in;
				}
			}
		});
		//  alert(sum);
		$('#tot_add_cup_in').val(pos_sum);
		$('#tot_rem_cup_in').val(neg_sum);

		$('#tot_cup_in').val(pos_sum + neg_sum);
		evaportation_calculation(ci_col_id, sel_day)
		//	  cup_info_single_save(ci_col_id,sel_day);
	}
	function show_alert() {
		alert('You cannot enter for any day after today');
	}
</script>
<!-- <script>
	function isNumericInput(event) {
		// Function to allow only numeric input
	}

	// Add an event listener to detect changes in the cup input
	document.getElementById("<?php echo $ci_col_id; ?>").addEventListener("input", function() {
		var rainfallValue = parseFloat(document.getElementById("<?php echo $ra_col_id; ?>").value);
		var cupValue = parseFloat(this.value);
		alert(rainfallValue);
		// Check if rainfall value is zero and cup value is negative
		if (rainfallValue === 0 && cupValue < 0) {
			// If condition is met, reset cup value to zero
			this.value = 0;
			alert("Cup value cannot be negative when rainfall value is zero.");
		}
	});
</script> -->
<!-- <script>
// Get all input fields with the class name 'positive-number-input'
var inputs           = document.getElementsByClassName('cup');
//alert(inputs);
var rainfall_value   = document.getElementsByClassName('rainfall');
//alert(rainfall_value);



// Loop through each input field and add event listener
for (var i = 0; i < inputs.length; i++) {
	inputs[i].onkeydown = function(e) {
		// Prevent the minus sign (-) key from being entered
		if (e.key === '-' || e.keyCode === 189) {
			e.preventDefault();
		}
	};
}
</script> -->
<script>
	let inputs = document.getElementsByClassName('cup');
	//alert(inputs);
	var rainfallElements = document.getElementsByClassName('rainfall');
	let rainfallValues = [];

	for (var i = 0; i < rainfallElements.length; i++) {
		var value = rainfallElements[i].value;
		rainfallValues.push(value);
	}
	//console.log(rainfallValues);
	for (var i = 0; i < rainfallValues.length; i++) {
    (function(index) {
        inputs[index].onkeydown = function(e) {
            if (rainfallValues[index] === "0" && (e.key === '-' || e.keyCode === 189)) {
                //console.log("Rainfall is zero. Negative input prevented.");
                e.preventDefault();
            }
        };
    })(i);
}

</script>