$(document).ready(function(){
	load_bm_pillar_info();
});

function load_bm_pillar_info(){
	//alert('load_bm_pillar_info');
	$('#cover-spin').show(0);
    $.ajax({
        url:"module/surface_water/bwdb_bm_pillar_datatable.php",
        datatype:'get',
       // data: datastr,
        success:function(data){
			$('#cover-spin').hide();
			$("#bm_pillar_datatbl_holder").html(data);
        }
    });  
}	

function load_bpi_add_form(){
	$("#bm_pillar_add_modal_body").html("");
	$("#bm_pillar_add_modal_body").load("module/surface_water/bwdb_bm_pillar_add_form.php");
}

function load_hydro_div_list(sel_stat_type){
	$('#stat_id').val('').trigger('liszt:updated');
	$('#stat_name').val('');
	$('#bm_pillar_id').val('');
	$("#river_list_holder").html("<input type='text' style='width: 93%;' readonly />");
	$('#bb_lat').val('');
	$('#bb_long').val('');
	if(sel_stat_type=="gw"){
		document.getElementById("gw_length_label").innerHTML = "Length: ";
		document.getElementById("bm_gw_length").style.display = "block";
	}
	else{
		document.getElementById("gw_length_label").innerHTML = "&nbsp;&nbsp;&nbsp;";
		document.getElementById("bm_gw_length").style.display = "none";
	}
	var datastr = "sel_stat_type="+sel_stat_type;
	$("#hydro_div_list_holder").load('module/surface_water/bwdb_bm_hydro_div_list_by_type.php',datastr);
}

function load_hydro_river_list(sel_hyd_div){
	var stat_type =  $('#stat_type').val();
	$('#stat_id').val('').trigger('liszt:updated');
	if(stat_type=="sw" || stat_type=="rm"){
		var datastr = "sel_hyd_div="+sel_hyd_div+"&stat_type="+stat_type;
		$("#river_list_holder").load('module/surface_water/bwdb_bm_river_list_by_hyd_div.php',datastr);
	}
	else{
		var sel_riv = 0;
		load_station_list(0);
		$("#river_list_holder").html("<input type='text' style='width: 93%;' readonly />");
	}
}

function load_station_list(sel_riv){
	var stat_type =  $('#stat_type').val();
	var hyd_div =  $('#hyd_div').val();
	var datastr = "stat_type="+stat_type+"&hyd_div="+hyd_div;
	if(stat_type=="sw" || stat_type=="rm"){
		datastr = datastr+"&sel_riv="+sel_riv;
	}
//	alert(datastr);
	$("#station_list_holder").load('module/surface_water/bwdb_bm_stat_list_by_type.php',datastr);
}

function load_stat_wise_info(sel_stat_id){
	var stat_type =  $('#stat_type').val();
	var datastr = "stat_type="+stat_type+"&sel_stat_id="+sel_stat_id;
	$.ajax({
		url:"module/surface_water/bwdb_bm_load_stat_info_by_id.php",
		datatype:'post',
		data: datastr,
		success:function(st){
			//alert(st);
			if(st==""){
				alert("Station information is not found.");
			}
			else{
				var data_arr=st.split("|");
				if(stat_type=="sw"){
					$('#stat_name').val(data_arr[0]);
					$('#bb_lat').val(data_arr[1]);
					$('#bb_long').val(data_arr[2]);
					$('#bm_pillar_id').val(data_arr[3]);
					check_bm_piller_id(data_arr[3]);
					$('#bb_loc').select();
				}
				if(stat_type=="gw"){
					$('#stat_name').val(data_arr[0]);
					$('#bb_lat').val(data_arr[1]);
					$('#bb_long').val(data_arr[2]);
					$('#bm_pillar_id').val(data_arr[3]);
					check_bm_piller_id(data_arr[3]);
					$('#bb_loc').select();
				}
				if(stat_type=="rm"){
					$('#bb_lat').val(data_arr[0]);
					$('#bb_long').val(data_arr[1]);
					$('#bm_pillar_id').val(data_arr[2]);
					check_bm_piller_id(data_arr[3]);
					$('#bb_loc').select();
				}
			}
		}
	});
}

function load_bm_pillar_vw_modal(sel_id,sel_bm_pillar_id){
	var datastr = "sel_id="+sel_id+"&sel_bm_pillar_id="+sel_bm_pillar_id;
//	alert(datastr);
	$("#bm_pillar_vw_modal_body").load('module/surface_water/bwdb_bm_pillar_view.php',datastr);
}

function load_bm_pillar_edit_modal(sel_id,sel_bm_pillar_id){
	var datastr = "sel_id="+sel_id+"&sel_bm_pillar_id="+sel_bm_pillar_id;
//	alert(datastr);
	$("#bm_pillar_edit_modal_body").load('module/surface_water/bwdb_bm_pillar_edit_form.php',datastr);
}

function add_bm_pillar_info(){
	var bm_pillar_id =  encodeURIComponent($.trim($('#bm_pillar_id').val()));
	var stat_type =  $('#stat_type').val();
	var stat_id =  $('#stat_id').val();
	var river_id =  $('#river_id').val();
	var bb_lat =  $.trim($('#bb_lat').val());
	var bb_long =  $.trim($('#bb_long').val());
	var bb_loc =  encodeURIComponent($.trim($("#bb_loc").val()));
	var bb_rl =  $.trim($('#bb_rl').val());
	var sob_bm_id_1 =  encodeURIComponent($.trim($('#sob_bm_id_1').val()));
	var sob_lat_1 =  $.trim($('#sob_lat_1').val());
	var sob_long_1 =  $.trim($('#sob_long_1').val());
	var sob_loc_1 =  encodeURIComponent($.trim($("#sob_loc_1").val()));
	var height_abv_ms_1 =   $.trim($('#height_abv_ms_1').val());
	var dist_id_1 =  encodeURIComponent($.trim($('#dist_id_1').val()));
	var sob_bm_id_2 =  encodeURIComponent($.trim($('#sob_bm_id_2').val()));
	var sob_lat_2 =  $.trim($('#sob_lat_2').val());
	var sob_long_2 =  $.trim($('#sob_long_2').val());
	var sob_loc_2 =  encodeURIComponent($.trim($("#sob_loc_2").val()));
	var height_abv_ms_2 =   $.trim($('#height_abv_ms_2').val());
	var dist_id_2 =  encodeURIComponent($.trim($('#dist_id_2').val()));
	var remarks =   encodeURIComponent($.trim($('#remarks').val()));
	var gw_length =   $.trim($('#bm_gw_length').val());
	var operation = "add_bm_pillar_info";
	
	var datastr = "operation="+operation+"&bm_pillar_id="+bm_pillar_id+"&stat_type="+stat_type+
	"&stat_id="+stat_id+"&river_id="+river_id+"&bb_lat="+bb_lat+"&bb_long="+bb_long+"&bb_rl="+bb_rl+"&bb_loc="+bb_loc+
	"&sob_bm_id_1="+sob_bm_id_1+"&sob_lat_1="+sob_lat_1+"&sob_long_1="+sob_long_1+"&sob_loc_1="+sob_loc_1+
	"&height_abv_ms_1="+height_abv_ms_1+"&dist_id_1="+dist_id_1+"&sob_bm_id_2="+sob_bm_id_2+"&sob_lat_2="+sob_lat_2+
	"&sob_long_2="+sob_long_2+"&sob_loc_2="+sob_loc_2+"&height_abv_ms_2="+height_abv_ms_2+"&dist_id_2="+dist_id_2+
	"&gw_length="+gw_length+"&remarks="+remarks;
	
	//alert(datastr);
	
	$.ajax({
		url: 'module/surface_water/bwdb_bm_pillar_ajax.php',
		type: 'post',
		data: datastr,
		cache: false,
		success: function (result) {
			//alert(result);
			if(result==1){
				$('#bm_pillar_add_modal').modal('hide');
				load_bm_pillar_info();
			}
			else{
				alert('error occurred');
			}
		}
	});
}


function update_bm_pillar_info(){
	var e_row_id =  $('#e_row_id').val();
	var e_bm_pillar_id =  $('#e_bm_pillar_id').val();
	var e_bb_lat =  $.trim($('#e_bb_lat').val());
	var e_bb_long =  $.trim($('#e_bb_long').val());
	var e_bb_loc =  encodeURIComponent($.trim($("#e_bb_loc").val()));
	var e_bb_rl =  $.trim($('#e_bb_rl').val());
	var e_sob_bm_id_1 =  encodeURIComponent($.trim($('#e_sob_bm_id_1').val()));
	var e_sob_lat_1 =  $.trim($('#e_sob_lat_1').val());
	var e_sob_long_1 =  $.trim($('#e_sob_long_1').val());
	var e_sob_loc_1 =  encodeURIComponent($.trim($("#e_sob_loc_1").val()));
	var e_height_abv_ms_1 =   $.trim($('#e_height_abv_ms_1').val());
	var e_dist_id_1 =  encodeURIComponent($.trim($('#e_dist_id_1').val()));
	var e_sob_bm_id_2 =  encodeURIComponent($.trim($('#e_sob_bm_id_2').val()));
	var e_sob_lat_2 =  $.trim($('#e_sob_lat_2').val());
	var e_sob_long_2 =  $.trim($('#e_sob_long_2').val());
	var e_sob_loc_2 =  encodeURIComponent($.trim($("#e_sob_loc_2").val()));
	var e_height_abv_ms_2 =   $.trim($('#e_height_abv_ms_2').val());
	var e_dist_id_2 =  encodeURIComponent($.trim($('#e_dist_id_2').val()));
	var e_remarks =   encodeURIComponent($.trim($('#e_remarks').val()));
	var e_gw_length =   $.trim($('#e_bm_gw_length').val());
	var operation = "update_bm_pillar_info";
	
	var datastr = "operation="+operation+"&e_row_id="+e_row_id+"&e_bm_pillar_id="+e_bm_pillar_id+
	"&e_bb_lat="+e_bb_lat+"&e_bb_long="+e_bb_long+"&e_bb_rl="+e_bb_rl+"&e_bb_loc="+e_bb_loc+
	"&e_sob_bm_id_1="+e_sob_bm_id_1+"&e_sob_lat_1="+e_sob_lat_1+"&e_sob_long_1="+e_sob_long_1+"&e_sob_loc_1="+e_sob_loc_1+
	"&e_height_abv_ms_1="+e_height_abv_ms_1+"&e_dist_id_1="+e_dist_id_1+"&e_sob_bm_id_2="+e_sob_bm_id_2+
	"&e_sob_lat_2="+e_sob_lat_2+"&e_sob_long_2="+e_sob_long_2+"&e_sob_loc_2="+e_sob_loc_2+
	"&e_height_abv_ms_2="+e_height_abv_ms_2+"&e_dist_id_2="+e_dist_id_2+"&e_gw_length="+e_gw_length+"&e_remarks="+e_remarks;
	
	//alert(datastr);
	
	$.ajax({
		url: 'module/surface_water/bwdb_bm_pillar_ajax.php',
		type: 'post',
		data: datastr,
		cache: false,
		success: function (result) {
			//alert(result);
			if(result==1){
				$('#bm_pillar_edit_modal').modal('hide');
				load_bm_pillar_info();
			}
			else{
				alert('error occurred');
			}
		}
	});
}

function delete_pillar_info(sel_row_id,sel_bm_pillar_id){
	var operation = "del_bm_pillar_info";
	var datastr = "operation="+operation+"&sel_row_id="+sel_row_id+"&sel_bm_pillar_id="+sel_bm_pillar_id;
	if (confirm("Are you sure want to delete the Selected Row?"))
	{
		$.ajax({
			url: 'module/surface_water/bwdb_bm_pillar_ajax.php',
			type: 'post',
			data: datastr,
			cache: false,
			success: function (result) {
				//alert(result);
				if(result==1){
					load_bm_pillar_info();
				}
				else{
					alert('error occurred');
				}
			}
		});
	}
}