function flush_data() {
	$("#odcyg_graph_holder").html("");
	$('#odcg_river').val('').trigger('liszt:updated');
	$('#odcg_river_sl').val('').trigger('liszt:updated');
	$('#odcg_yl_river').val('').trigger('liszt:updated');
	$('#od_station').val('').trigger('liszt:updated');
	$('#od_yl_station').val('').trigger('liszt:updated');
	$('#od_station_sl').val('').trigger('liszt:updated');
	$('#odcg_year_list').multipleSelect('uncheckAll');
	$('#odcg_from_year').val('');
	$('#odcg_to_year').val('');
	$('#odcg_from_year_sl').val('');
	$('#odcg_to_year_sl').val('');
}

function load_stat_for_odcg(sel_river_id, op_type) {
	$("#odcyg_graph_holder").html("");
	var datastr = "sel_river_id=" + sel_river_id;
	// alert(datastr);
	if (op_type == "year_range") {
		//alert('line 17');
		$("#odcg_stat_list_holder").load('module/surface_water/obs_discharge_station_list_by_river.php', datastr);
	} else if(op_type == "year_list") {
		//alert('line 20');
		$("#odcg_stat_list_yl_holder").load('module/surface_water/obs_discharge_yl_station_list_by_river.php', datastr);
	} else {
		//alert('line 20');
		$("#odcg_stat_list_holder_sl").load('module/surface_water/obs_discharge_station_list_by_river_single.php', datastr);
	}
}

function load_od_year_list_by_station(sel_station_id){
	var datastr = "sel_station_id=" + sel_station_id;
//	alert(datastr);
	$("#cover-spin").show();
	$.ajax({
		type: "get",
		url: "module/surface_water/od_year_list_by_station_id.php",
		data: datastr,
		success: function (str) {
		  $("#cover-spin").hide();
		  $("#odcg_year_list_holder").html(str);
		},
	});
}


function load_od_yearly_comp_graph_holder(search_type){
	$("#odcyg_graph_holder").html("");
	if (search_type == "year_range") {
		var station_id = $("#od_station").val();
		var from_year = $("#odcg_from_year").val();
		var to_year = $("#odcg_to_year").val();
		
		var datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year+"&search_type="+search_type;
		
		if (!station_id) {
			alert('Please Select Station');
			$("#od_station").focus();
			return false;
		}
		else if (!from_year) {
			alert('Please select From Year');
			$("#odcg_from_year").focus();
			return false;
		}
		else if (!to_year) {
			alert('Please select To Year');
			$("#odcg_to_year").focus();
			return false;
		}
		else{
			// alert(datastr);
			$("#odcyg_graph_holder").load('module/surface_water/obs_discharge_yearly_com_graph_holder.php', datastr);
		}
	}
	else if(search_type == 'year_list'){
		var station_id = $("#od_yl_station").val();
		var year_list = $("#odcg_year_list").val();
		var datastr = "station_id="+station_id+"&year_list="+year_list+"&search_type="+search_type;
		if (!station_id) {
			alert('Please Select Station');
			$("#od_yl_station").focus();
			return false;
		}
		else if (!year_list) {
			alert('Please select From Year');
			$("#odcg_year_list").focus();
			return false;
		}
		else{
			//alert(datastr);
			$("#odcyg_graph_holder").load('module/surface_water/obs_discharge_yearly_com_graph_holder.php', datastr);
		}
	}
	else {
		var station_id_sl = $("#od_station_sl").val();
		var from_year_sl = $("#odcg_from_year_sl").val();
		var to_year_sl = $("#odcg_to_year_sl").val();
		
		var datastr = "station_id="+station_id_sl+"&from_year="+from_year_sl+"&to_year="+to_year_sl+"&search_type="+search_type;
		if (!station_id_sl) {
			alert('Please Select Station');
			$("#od_station_sl").focus();
			return false;
		}
		else if (!from_year_sl) {
			alert('Please select From Year');
			$("#odcg_from_year_sl").focus();
			return false;
		}
		else if (!to_year_sl) {
			alert('Please select To Year');
			$("#odcg_to_year_sl").focus();
			return false;
		}
		else{
			// alert(datastr);
			$("#odcyg_graph_holder").load('module/surface_water/obs_discharge_yearly_com_graph_holder_sl.php', datastr);
		}
	}
}

function load_od_yearly_comp_graph() {
	var search_type = $("#od_grph_sel_search_type").val();
	var station_id = $("#od_grph_sel_station_id").val();
	var station_name = $("#od_grph_sel_station_name").val();
	var river = $("#od_grph_sel_river").val();
	var district_name = $("#od_grph_sel_district").val();
	var upzl_name = $("#od_grph_sel_upz").val();
	var datastr = "";
	var year_for_title = "";
	if (search_type == "year_range") {
		var from_year = $("#od_grph_sel_from_year").val();
		var to_year = $("#od_grph_sel_to_year").val();
		datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year+"&search_type="+search_type;
		year_for_title = "Time Period: " + from_year + " to " + to_year;
	} else {
		var year_list = $("#od_grph_sel_year_list").val();
		datastr = "station_id="+station_id+"&year_list="+year_list+"&search_type="+search_type;
		year_for_title = "Years: " + year_list;
	}
	//alert(datastr);
	
	$('#cover-spin').show();
	$.ajax({
		type: "post",
		url: "module/surface_water/obs_discharge_graph_year_wise.php",
		data: datastr,
		success: function (str) {
			//alert(str);
			if ($.trim(str)) {
				//console.log(str);
				$('#cover-spin').hide();
				var data = $.parseJSON(str);
				// Destroy existing chart instance if it exists
				let chartStatus = Chart.getChart("od_yr_comp_graph"); // <canvas> id
				if (chartStatus != undefined) {
					chartStatus.destroy();
				}
				// Restructure data for Chart.js
				var chartData = {
					labels: [], // Array to store x-axis labels (distances)
					datasets: [],
				};
				// Iterate through each year in the data
				for (var year in data) {
					if (data.hasOwnProperty(year)) {
						var yearlyData = data[year];

						// Extract distances from the first array (assuming all arrays have the same distances)
						if (chartData.labels.length === 0) {
							chartData.labels = yearlyData.map(function (item) {
								// Extracting only the month and date from the first value (date)
								return item[0];
							});
						}

						// Extract RL values for the current year
						var rlValues = yearlyData.map(function (item) {
							return item[1]; // Extracting the second value (RL value)
						});
						var sel_color = getRandomColor();
						// Add a dataset for the current year
						chartData.datasets.push({
							label: year,
							data: rlValues,
							fill: false,
							backgroundColor: sel_color,
							borderColor: sel_color,
							spanGaps: true,
						});
					}
				}
				//Assuming you have the necessary variables (statName, station_id, riverName) defined
				var ctx = document.getElementById("od_yr_comp_graph").getContext("2d");
				lineChart = new Chart(ctx, {
					type: "line",
					data: chartData,
					options: {
						scales: {
							x: {
								display: true,
								title: {
									display: true,
									text: 'Date (Month-Day)', // x-axis label
								},
							},
							y: {
								display: true,
								title: {
									display: true,
									text: 'Discharge (m3/s)', // y-axis label
								},
							},
						},
						plugins: {
							title: {
								display: true,
								text: ["Observed Discharge Yearly Comparision Graph for Station: "+station_id+" ("+station_name+"), "+year_for_title," River: "+river+" District: "+district_name+", Upazila: "+upzl_name],
								font: {
									size: 14, // Adjust the font size as needed
									lineHeight: 1.5
								},
								padding: {
									top: 5,
									bottom: 10
								},				
							},
						},
						// Your other chart options here
					},
				});
			}
		}
	});

	// Function to generate a random color for the chart line
	function getRandomColor() {
		var letters = '0123456789ABCDEF';
		var color = '#';

		// Generate a color
		for (var i = 0; i < 6; i++) {
			color += letters[Math.floor(Math.random() * 16)];
		}

		// Check if the color is whitish (lightness value greater than a threshold)
		if (isWhitish(color, 0.8)) {
			// If whitish, generate a different color
			var newColor = getRandomColor();

			// Return the different color
			return newColor;
		}

		// If not whitish, return the generated color
		return color;
	}

	// Function to check if a color is whitish based on its lightness value
	function isWhitish(hexColor, threshold) {
		// Convert hex to RGB
		var r = parseInt(hexColor.substring(1, 3), 16);
		var g = parseInt(hexColor.substring(3, 5), 16);
		var b = parseInt(hexColor.substring(5, 7), 16);

		// Calculate lightness value
		var lightness = (Math.max(r, g, b) + Math.min(r, g, b)) / 510;

		// Check if lightness is greater than the threshold
		return lightness > threshold;
	}
}

//print graph strat
function download_od_yearly_comp_graph() {
	//alert('download_rainfall_chart');
	var chartContainer = document.getElementById('od_yr_comp_graph');
	var canvas = document.createElement('canvas');
	canvas.width = chartContainer.offsetWidth;
	canvas.height = chartContainer.offsetHeight;
	//alert(chartContainer.offsetWidth);
	var ctx = canvas.getContext('2d');
	ctx.fillStyle = 'white';
	ctx.fillRect(0, 0, canvas.width, canvas.height);
	html2canvas(chartContainer).then(function(chartCanvas) {
		ctx.drawImage(chartCanvas, 0, 0);
		canvas.toBlob(function(blob) {
			var link = document.createElement('a');
			link.href = URL.createObjectURL(blob);
			link.download = 'Observed Discharge Yearly Comparison Graph';
			link.click();
		});
	});
}
//print graph end

function load_od_yearly_comp_graph_sl(){
	var station_id = $("#od_grph_sel_station_id").val();
	var station_name = $("#od_grph_sel_station_name").val();
	var river = $("#od_grph_sel_river").val();
	var district_name = $("#od_grph_sel_district").val();
	var upzl_name = $("#od_grph_sel_upz").val();
    var from_year = $("#od_grph_sel_from_year").val();
    var to_year = $("#od_grph_sel_to_year").val();
	
	var datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year;
	//alert(datastr);
	
	$("#cover-spin").show();
	$.ajax({
		type: "post",
		url: "module/surface_water/obs_discharge_graph_year_wise_single.php",
		data: datastr,
		success: function (str) {
			// alert(str);
			// console.log(str)
			if ($.trim(str)) {
				console.log(str);
				$('#cover-spin').hide();
				var data = $.parseJSON(str);
				
								
				var labeldata = [];

				var chrtdata = [];
				
				
				for(var i =0; i < data.length; i++){
					  labeldata.push(data[i][0]);
					  chrtdata.push(data[i][1]);
				}
				var ctx = document.getElementById("od_yr_comp_graph").getContext("2d");
				var myChart = new Chart(ctx, {
				  type: 'line',
				  data: {
					labels: labeldata,
					datasets: [{
						label: 'Discharge (m3/s)',
						data: chrtdata,
						backgroundColor: "rgba(51, 204, 255,0.6)",
						borderColor:"rgba(51, 204, 255,0.6)",
					}]
				  },
				  options: {
					   scales: {
					  x: {
						display: true,
						title: {
						  display: true,
						  text: 'Date-Time' // x-axis label
						}
					  },
					  y: {
						display: true,
						title: {
						  display: true,
						  text: 'Discharge (m3/s)' // y-axis label
						}
					  }
					},
					 plugins: {
						title: {
                display: true,
                text: [
                  "Observed Discharge Yearly Comparison Graph for Station: " +
                  station_id +
                  "(" +
                  station_name +
                  "), " +
                  from_year+'-'+to_year,
                  " River: " +
                  river +
                  ", District: " +
                  district_name +
                  ", Upazila: " +
                  upzl_name,
                ],
                font: {
                  size: 14, // Adjust the font size as needed
                  lineHeight: 1.5,
                },
                padding: {
                  top: 5,
                  bottom: 10,
                },
              },
            },  
				  }
				});
			}
		}
	});
}