function flush_data() {
	$("#wlcyg_graph_holder").html("");
	$('#wlcg_river').val('').trigger('liszt:updated');
	$('#wlcg_river1').val('').trigger('liszt:updated');
	$('#wlctg_river').val('').trigger('liszt:updated');
	$('#wl_station').val('').trigger('liszt:updated');
	$('#wl_station_yl').val('').trigger('liszt:updated');
	$('#wl_station_sl').val('').trigger('liszt:updated');
	$('#wlcg_year_list').multipleSelect('uncheckAll');
	$('#wlcg_from_year').val('');
	$('#wlcg_to_year').val('');
	$('#wlctg_from_year').val('');
	$('#wlctg_to_year').val('');
}

function load_stat_by_river_for_wlcg(sel_river_id, op_type) {
  $("#wlcyg_graph_holder").html("");
  var datastr = "sel_river_id=" + sel_river_id + "&op_type=" + op_type;
  //alert(datastr);
  if (op_type == "year_range") {
    $("#wlcg_stat_list_holder").load(
      "module/surface_water/wl_station_list_by_river.php",
      datastr
    );
  } else {
    $("#wlcg_stat_list_yl_holder").load(
      "module/surface_water/wl_station_list_yl_by_river.php",
      datastr
    );
  }
}

function load_stat_by_river_for_wlctg(sel_river_id) {
  $("#wlcyg_graph_holder").html("");
  var datastr = "sel_river_id="+sel_river_id;
  //alert(datastr);
  $("#wlctg_stat_list_holder").load("module/surface_water/wl_station_list_by_river_sl.php",datastr);
 
}

function load_year_list_by_station(sel_station_id) {
  //alert('load_year_list_by_station');
  var datastr = "sel_station_id=" + sel_station_id;
  //alert(datastr);
  $("#cover-spin").show();
  $.ajax({
    type: "get",
    url: "module/surface_water/wl_year_list_by_station_id.php",
    data: datastr,
    success: function (str) {
      $("#cover-spin").hide();
      $("#wlcg_year_list_holder").html(str);
    },
  });
}

function load_wl_yearly_comp_graph_holder(search_type) {
  //alert('load_wl_yearly_comp_graph_holder');
  $("#wlcyg_graph_holder").html("");
  var station_id = $("#wl_station").val();

  if (search_type == "year_range") {
    var from_year = $("#wlcg_from_year").val();
    var to_year = $("#wlcg_to_year").val();
    var datastr ="station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year+
      "&search_type="+search_type;
    //alert(datastr);
    if (!station_id) {
      alert("Please Select Station");
      $("#wl_station").focus();
      return false;
    } else if (!from_year) {
      alert("Please select From Year");
      $("#wlcg_from_year").focus();
      return false;
    } else if (!to_year) {
      alert("Please select To Year");
      $("#wlcg_to_year").focus();
      return false;
    } else {
      //alert(datastr);
      $("#wlcyg_graph_holder").load(
        "module/surface_water/wl_yearly_com_graph_holder.php",
        datastr
      );
    }
  } else {
    var station_id = $("#wl_station_yl").val();
    var year_list = $("#wlcg_year_list").val();
    var datastr =
      "station_id=" +
      station_id +
      "&year_list=" +
      year_list +
      "&search_type=" +
      search_type;
    //alert(datastr);
    if (!station_id) {
      alert("Please Select Station");
      $("#wl_station").focus();
      return false;
    } else if (!year_list) {
      alert("Please select Year");
      $("#wlcg_year_list").focus();
      return false;
    } else {
      //alert(datastr);
      $("#wlcyg_graph_holder").load(
        "module/surface_water/wl_yearly_com_graph_holder.php",
        datastr
      );
    }
  }
}

function load_wl_yearly_cont_graph_holder(){
	$("#wlcyg_graph_holder").html("");
	var station_id = $("#wl_station_sl").val();
	var from_year = $("#wlctg_from_year").val();
    var to_year = $("#wlctg_to_year").val();
	var fr_yr = parseInt(from_year);
	var to_yr = parseInt(to_year);
	var yr_diff = (to_yr-fr_yr);
	//alert(yr_diff);
	 if (!station_id) {
      alert("Please Select Station");
      $("#wl_station").focus();
      return false;
    } else if (!from_year) {
      alert("Please select From Year");
      $("#wlctg_from_year").focus();
      return false;
    } else if (!to_year) {
      alert("Please select To Year");
      $("#wlctg_to_year").focus();
      return false;
    } else if (fr_yr > to_yr){
		alert("From Year cannot be greater than To Year");
		$("#wlctg_from_year").focus();
		return false;
	} 
	else if (yr_diff > 10){
		alert("You can only load 10 years data at a time.");
		return false;
	}
	else {
		var datastr ="station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year;
	//	alert(datastr);
		$("#wlcyg_graph_holder").load("module/surface_water/wl_yearly_cont_graph_holder.php",datastr);
	}
}

function load_wl_yearly_comp_graph() {
  var search_type = $("#grph_sel_search_type").val();
  var station_id = $("#grph_sel_station_id").val();
  var station_name = $("#grph_sel_station_name").val();
  var river = $("#grph_sel_river").val();
  var district_name = $("#grph_sel_district").val();
  var upzl_name = $("#grph_sel_upz").val();
  var datastr = "";
  var year_for_title = "";
  if (search_type == "year_range") {
    var from_year = $("#grph_sel_from_year").val();
    var to_year = $("#grph_sel_to_year").val();
    datastr =
      "station_id=" +
      station_id +
      "&from_year=" +
      from_year +
      "&to_year=" +
      to_year +
      "&search_type=" +
      search_type;
    year_for_title = "Time Period: " + from_year + " to " + to_year;
  } else {
    var year_list = $("#grph_sel_year_list").val();
    datastr =
      "station_id=" +
      station_id +
      "&year_list=" +
      year_list +
      "&search_type=" +
      search_type;
    year_for_title = "Years: " + year_list;
  }
  //	alert(datastr);
  $("#cover-spin").show();
  // $.ajax({
  // 	type: "post",
  // 	url: "module/surface_water/wl_graph_year_wise.php",
  // 	data: datastr,
  // 	success: function (str) {
  // 		//	alert(str);
  // 		if ($.trim(str)) {
  // 			console.log(str);
  // 			$('#cover-spin').hide();
  // 			var data = $.parseJSON(str);

  // 			//console.log(data);
  // 			// Destroy existing chart instance if it exists
  // 			let chartStatus = Chart.getChart("wl_yr_comp_graph"); // <canvas> id
  // 			if (chartStatus != undefined) {
  // 				chartStatus.destroy();
  // 			}
  // 			// Restructure data for Chart.js
  // 			var chartData = {
  // 				labels: [], // Array to store x-axis labels (distances)
  // 				datasets: [],
  // 			};
  // 			// Iterate through each year in the data
  // 			for (var year in data) {
  // 				if (data.hasOwnProperty(year)) {
  // 					var yearlyData = data[year];

  // 					if (chartData.labels.length === 0) {
  // 						chartData.labels = yearlyData.map(function (item) {
  // 							// Extracting both the month, date, and time from the array
  // 							return item[0];
  // 						});
  // 					}

  // 					// Extract RL values for the current year
  // 					var rlValues = yearlyData.map(function (item) {
  // 						return item[1]; // Extracting the second value (RL value)
  // 					});

  // 					var labels = chartData.labels = yearlyData.map(function (item) {
  // 						// Extracting both the month, date, and time from the array
  // 						return item[0];
  // 					});
  // 					if(year == '2023'){
  // 						console.log(rlValues);
  // 						console.log(labels);
  // 					}
  // 					var sel_color = getRandomColor();
  // 					// Add a dataset for the current year
  // 					chartData.datasets.push({
  // 						label: year,
  // 						data: rlValues,
  // 						fill: false,
  // 						backgroundColor: sel_color,
  // 						borderColor: sel_color,
  // 						spanGaps: true,
  // 					});
  // 				}
  // 			}
  // 			//Assuming you have the necessary variables (statName, station_id, riverName) defined
  // 			var ctx = document.getElementById("wl_yr_comp_graph").getContext("2d");
  // 			lineChart = new Chart(ctx, {
  // 				type: "line",
  // 				data: chartData,
  // 				options: {
  // 					scales: {
  // 						x: {
  // 							display: true,
  // 							title: {
  // 								display: true,
  // 								text: 'Date (Month-Day)', // x-axis label
  // 							},
  // 						},
  // 						y: {
  // 							display: true,
  // 							title: {
  // 								display: true,
  // 								text: 'Water Level (m SOB)', // y-axis label
  // 							},
  // 						},
  // 					},
  // 					plugins: {
  // 						title: {
  // 							display: true,
  // 							text: ["Water Level Yearly Comparision Graph for Station: " + station_id + "(" + station_name + "), " + year_for_title, "River: " + river + ", District: " + district_name + ", Upazila: " + upzl_name],
  // 							font: {
  // 								size: 14, // Adjust the font size as needed
  // 								lineHeight: 1.5
  // 							},
  // 							padding: {
  // 								top: 5,
  // 								bottom: 10
  // 							},
  // 						},
  // 					},
  // 					// Your other chart options here
  // 				},
  // 			});
  // 		}
  // 	}
  // });

  //   $.ajax({
  //     type: "post",
  //     url: "module/surface_water/wl_graph_year_wise.php",
  //     data: datastr,
  //     success: function (str) {
  //       if ($.trim(str)) {
  //         console.log(str);
  //         $("#cover-spin").hide();
  //         var data = $.parseJSON(str);

  //         // Destroy existing chart instance if it exists
  //         let chartStatus = Chart.getChart("wl_yr_comp_graph"); // <canvas> id
  //         if (chartStatus != undefined) {
  //           chartStatus.destroy();
  //         }

  //         // Restructure data for Chart.js
  //         var chartData = {
  //           labels: [], // Array to store x-axis labels (dates)
  //           datasets: [],
  //         };

  //         // Find the longest array length among all years
  //         var longestLength = 0;
  //         for (var year in data) {
  //           if (data.hasOwnProperty(year)) {
  //             longestLength = Math.max(longestLength, data[year].length);
  //           }
  //         }

  //         // Iterate through each year in the data
  //         for (var year in data) {
  //           if (data.hasOwnProperty(year)) {
  //             var yearlyData = data[year];
  //             var filledData = [];

  //             // Fill missing dates with null values to match the longest array length
  //             for (var i = 0; i < longestLength; i++) {
  //               var date = yearlyData[i] ? yearlyData[i][0] : null;
  //               var value = yearlyData[i] ? yearlyData[i][1] : null;
  //               filledData.push([date, value]);
  //             }

  //             // Extract labels and RL values
  //             var labels = filledData.map(function (item) {
  //               return item[0]; // Extracting the date (first value)
  //             });
  //             var rlValues = filledData.map(function (item) {
  //               return item[1]; // Extracting the RL value (second value)
  //             });

  //             // Add a dataset for the current year
  //             var sel_color = getRandomColor();
  //             chartData.datasets.push({
  //               label: year,
  //               data: rlValues,
  //               fill: false,
  //               backgroundColor: sel_color,
  //               borderColor: sel_color,
  //               spanGaps: true,
  //             });

  //             // Store labels (dates) if not already set
  //             if (chartData.labels.length === 0) {
  //               chartData.labels = labels;
  //             }
  //           }
  //         }

  //         // Create the Chart.js chart
  //         var ctx = document.getElementById("wl_yr_comp_graph").getContext("2d");
  //         var lineChart = new Chart(ctx, {
  //           type: "line",
  //           data: chartData,
  //           options: {
  //             scales: {
  //               x: {
  //                 display: true,
  //                 title: {
  //                   display: true,
  //                   text: "Date (Month-Day)", // x-axis label
  //                 },
  //               },
  //               y: {
  //                 display: true,
  //                 title: {
  //                   display: true,
  //                   text: "Water Level (m SOB)", // y-axis label
  //                 },
  //               },
  //             },
  //             plugins: {
  //               title: {
  //                 display: true,
  //                 text: [
  //                   "Water Level Yearly Comparison Graph for Station: " +
  //                     station_id +
  //                     "(" +
  //                     station_name +
  //                     "), " +
  //                     year_for_title,
  //                   "River: " +
  //                     river +
  //                     ", District: " +
  //                     district_name +
  //                     ", Upazila: " +
  //                     upzl_name,
  //                 ],
  //                 font: {
  //                   size: 14, // Adjust the font size as needed
  //                   lineHeight: 1.5,
  //                 },
  //                 padding: {
  //                   top: 5,
  //                   bottom: 10,
  //                 },
  //               },
  //             },
  //             // Your other chart options here
  //           },
  //         });
  //       }
  //     },
  //   });

  $.ajax({
    type: "post",
    url: "module/surface_water/wl_graph_year_wise.php",
    data: datastr,
    success: function (str) {
      if ($.trim(str)) {
      //  console.log(str);
        $('#cover-spin').hide();
        var data = $.parseJSON(str);

        // Extract unique date-time values from all year objects
        var uniqueDateTimeValues = [];
        for (var year in data) {
          if (data.hasOwnProperty(year)) {
            data[year].forEach(function (item) {
              var dateTime = item[0];
              if (!uniqueDateTimeValues.includes(dateTime)) {
                uniqueDateTimeValues.push(dateTime);
              }
            });
          }
        }

        // // Sort the array of unique date-time values
        // uniqueDateTimeValues.sort(function (a, b) {
        //   return new Date(a) - new Date(b);
        // });

        // Sort the array of unique date-time values
        uniqueDateTimeValues.sort(function (a, b) {
          // Extract month, date, and time parts
          var monthA = a.substring(3, 6); // Extract month from '20-Feb 06:00:00'
          var dateA = a.substring(0, 2); // Extract date from '20-Feb 06:00:00'
          var timeA = a.substring(7); // Extract time from '20-Feb 06:00:00'
          var monthB = b.substring(3, 6); // Extract month from '20-Feb 06:00:00'
          var dateB = b.substring(0, 2); // Extract date from '20-Feb 06:00:00'
          var timeB = b.substring(7); // Extract time from '20-Feb 06:00:00'

          // Convert month names to month numbers for comparison
          var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
          var monthIndexA = months.indexOf(monthA);
          var monthIndexB = months.indexOf(monthB);

          // Compare month parts first
          if (monthIndexA !== monthIndexB) {
            return monthIndexA - monthIndexB;
          } else {
            // If months are equal, compare date parts
            if (dateA !== dateB) {
              return dateA - dateB;
            } else {
              // If dates are equal, compare time parts
              return timeA.localeCompare(timeB);
            }
          }
        });



        // Construct the final chart data with sorted date-time labels and corresponding RL values
        var chartData = {
          labels: uniqueDateTimeValues,
          datasets: []
        };

        //console.log(chartData);

        // Populate datasets for each year
        for (var year in data) {
          if (data.hasOwnProperty(year)) {
            var rlValues = [];
            uniqueDateTimeValues.forEach(function (dateTime) {
              var rlValue = null; // Default RL value if not found
              data[year].forEach(function (item) {
                if (item[0] === dateTime) {
                  rlValue = parseFloat(item[1]);
                }
              });
              rlValues.push(rlValue);
            });
            var sel_color = getRandomColor();
            chartData.datasets.push({
              label: year,
              data: rlValues.map(function (rlValue, index) {
                return {
                  x: uniqueDateTimeValues[index], // Date-time value
                  y: rlValue // RL value
                };
              }),
              // fill: true,
							backgroundColor: sel_color,
							borderColor: sel_color,
							// spanGaps: true
              //fill: true
            });
          }
        }

      //  console.log(chartData);

        // Create the Chart.js chart
        var ctx = document.getElementById("wl_yr_comp_graph").getContext("2d");
        var lineChart = new Chart(ctx, {
          type: "line",
          data: chartData,
          options: {
            // Your chart options here
            scales: {
              x: {
                display: true,
                title: {
                  display: true,
                  text: 'Date-Time' // x-axis label
                }
              },
              y: {
                display: true,
                title: {
                  display: true,
                  text: 'Water Level (m SOB)' // y-axis label
                }
              }
            },
            plugins: {
              title: {
                display: true,
                text: [
                  "Water Level Yearly Comparison Graph for Station: " +
                  station_id +
                  "(" +
                  station_name +
                  "), " +
                  year_for_title,
                  "River: " +
                  river +
                  ", District: " +
                  district_name +
                  ", Upazila: " +
                  upzl_name,
                ],
                font: {
                  size: 14, // Adjust the font size as needed
                  lineHeight: 1.5,
                },
                padding: {
                  top: 5,
                  bottom: 10,
                },
              },
            },
          }
        });
      }
    }
  });






  // $.ajax({
  //   type: "post",
  //   url: "module/surface_water/wl_graph_year_wise.php",
  //   data: datastr,
  //   success: function (str) {
  //     if ($.trim(str)) {
  //       //console.log(str);
  //       $("#cover-spin").hide();
  //       var data = $.parseJSON(str);

  //       // Destroy existing chart instance if it exists
  //       let chartStatus = Chart.getChart("wl_yr_comp_graph"); // <canvas> id
  //       if (chartStatus != undefined) {
  //         chartStatus.destroy();
  //       }

  //       // Extract unique date-time values from all objects
  //       var uniqueDateTimeValues = [];
  //       for (var year in data) {
  //         if (data.hasOwnProperty(year)) {
  //           data[year].forEach(function (item) {
  //             var dateTime = item[0];
  //             if (!uniqueDateTimeValues.includes(dateTime)) {
  //               uniqueDateTimeValues.push(dateTime);
  //             }
  //           });
  //         }
  //       }

  //       // Iterate over each object and ensure it contains all unique date-time values
  //       for (var year in data) {
  //         if (data.hasOwnProperty(year)) {
  //           var yearlyData = data[year];

  //           // Ensure each object contains all unique date-time values
  //           uniqueDateTimeValues.forEach(function (dateTime) {
  //             // Check if current object contains current unique date-time value
  //             var found = yearlyData.some(function (item) {
  //               return item[0] === dateTime;
  //             });

  //             // If not found, add the date-time value with a null RL value
  //             if (!found) {
  //               yearlyData.push([dateTime, null]);
  //             }
  //           });

  //           // Sort objects by date-time value
  //           yearlyData.sort(function (a, b) {
  //             return new Date(a[0]) - new Date(b[0]);
  //           });
  //         }
  //       }

  // 	console.log(uniqueDateTimeValues);

  //       // Create the Chart.js chart with modified data
  //       var chartData = {
  //         labels: uniqueDateTimeValues,
  //         datasets: [],
  //       };

  //       for (var year in data) {
  //         if (data.hasOwnProperty(year)) {
  //           var yearlyData = data[year].map(function (item) {
  //             return item[1]; // Extract RL value
  //           });

  //           var sel_color = getRandomColor();
  //           chartData.datasets.push({
  //             label: year,
  //             data: yearlyData,
  //             fill: false,
  //             backgroundColor: sel_color,
  //             borderColor: sel_color,
  //             spanGaps: true,
  //           });
  //         }
  //       }

  //       // Create the Chart.js chart
  //       var ctx = document.getElementById("wl_yr_comp_graph").getContext("2d");
  //       var lineChart = new Chart(ctx, {
  //         type: "line",
  //         data: chartData,
  //         options: {
  //           scales: {
  //             x: {
  //               display: true,
  //               title: {
  //                 display: true,
  //                 text: "Date-Time", // x-axis label
  //               },
  //             },
  //             y: {
  //               display: true,
  //               title: {
  //                 display: true,
  //                 text: "Water Level (m SOB)", // y-axis label
  //               },
  //             },
  //           },
  //           plugins: {
  //             title: {
  //               display: true,
  //               text: [
  //                 "Water Level Yearly Comparison Graph for Station: " +
  //                   station_id +
  //                   "(" +
  //                   station_name +
  //                   "), " +
  //                   year_for_title,
  //                 "River: " +
  //                   river +
  //                   ", District: " +
  //                   district_name +
  //                   ", Upazila: " +
  //                   upzl_name,
  //               ],
  //               font: {
  //                 size: 14, // Adjust the font size as needed
  //                 lineHeight: 1.5,
  //               },
  //               padding: {
  //                 top: 5,
  //                 bottom: 10,
  //               },
  //             },
  //           },
  //           // Your other chart options here
  //         },
  //       });
  //     }
  //   },
  // });

  function getRandomColor() {
    var letters = "0123456789ABCDEF";
    var color = "#";

    // Generate a color
    for (var i = 0; i < 6; i++) {
      color += letters[Math.floor(Math.random() * 16)];
    }

    // Check if the color is whitish (lightness value greater than a threshold)
    if (isWhitish(color, 0.8)) {
      // If whitish, generate a different color
      var newColor = getRandomColor();

      // Return the different color
      return newColor;
    }

    // If not whitish, return the generated color
    return color;
  }

  // Function to check if a color is whitish based on its lightness value
  function isWhitish(hexColor, threshold) {
    // Convert hex to RGB
    var r = parseInt(hexColor.substring(1, 3), 16);
    var g = parseInt(hexColor.substring(3, 5), 16);
    var b = parseInt(hexColor.substring(5, 7), 16);

    // Calculate lightness value
    var lightness = (Math.max(r, g, b) + Math.min(r, g, b)) / 510;

    // Check if lightness is greater than the threshold
    return lightness > threshold;
  }
}

//print graph strat
function download_wl_yearly_comp_graph() {
  //alert('download_rainfall_chart');
  var chartContainer = document.getElementById("wl_yr_comp_graph");
  var canvas = document.createElement("canvas");
  canvas.width = chartContainer.offsetWidth;
  canvas.height = chartContainer.offsetHeight;
  //alert(chartContainer.offsetWidth);
  var ctx = canvas.getContext("2d");
  ctx.fillStyle = "white";
  ctx.fillRect(0, 0, canvas.width, canvas.height);
  html2canvas(chartContainer).then(function (chartCanvas) {
    ctx.drawImage(chartCanvas, 0, 0);
    canvas.toBlob(function (blob) {
      var link = document.createElement("a");
      link.href = URL.createObjectURL(blob);
      link.download = "Water Level Yearly Comparison Graph";
      link.click();
    });
  });
}
//print graph end


function load_wl_yearly_cont_graph(){
	var station_id = $("#cont_grph_sel_station_id").val();
	var station_name = $("#cont_grph_sel_station_name").val();
	var river = $("#cont_grph_sel_river").val();
	var district_name = $("#cont_grph_sel_district").val();
	var upzl_name = $("#cont_grph_sel_upz").val();
    var from_year = $("#cont_grph_sel_from_year").val();
    var to_year = $("#cont_grph_sel_to_year").val();
	
	var datastr = "station_id="+station_id+"&from_year="+from_year+"&to_year="+to_year;
	//alert(datastr);
	
	$("#cover-spin").show();
	$.ajax({
		type: "post",
		url: "module/surface_water/wl_cont_graph_year_wise.php",
		data: datastr,
		success: function (str) {
			//alert(str);
			if ($.trim(str)) {
				console.log(str);
				$('#cover-spin').hide();
				var data = $.parseJSON(str);
				
								
				var labeldata = [];

				var chrtdata = [];
				
				
				for(var i =0; i < data.length; i++){
					  labeldata.push(data[i][0]);
					  chrtdata.push(data[i][1]);
				}
				var ctx = document.getElementById("wl_yr_cont_graph").getContext("2d");
				var myChart = new Chart(ctx, {
				  type: 'line',
				  data: {
					labels: labeldata,
					datasets: [{
						label: 'Water Level (m SOB)',
						data: chrtdata,
						backgroundColor: "rgba(51, 204, 255,0.6)",
						borderColor:"rgba(51, 204, 255,0.6)",
					}]
				  },
				  options: {
					   scales: {
					  x: {
						display: true,
						title: {
						  display: true,
						  text: 'Date-Time' // x-axis label
						}
					  },
					  y: {
						display: true,
						title: {
						  display: true,
						  text: 'Water Level (m SOB)' // y-axis label
						}
					  }
					},
					 plugins: {
						title: {
                display: true,
                text: [
                  "Water Level Yearly Comparison Graph for Station: " +
                  station_id +
                  "(" +
                  station_name +
                  "), " +
                  from_year+'-'+to_year,
                  "River: " +
                  river +
                  ", District: " +
                  district_name +
                  ", Upazila: " +
                  upzl_name,
                ],
                font: {
                  size: 14, // Adjust the font size as needed
                  lineHeight: 1.5,
                },
                padding: {
                  top: 5,
                  bottom: 10,
                },
              },
            },  
				  }
				});
			}
		}
	});
}

//print graph strat
function download_wl_yearly_cont_graph() {
  //alert('download_rainfall_chart');
  var chartContainer = document.getElementById("wl_yr_cont_graph");
  var canvas = document.createElement("canvas");
  canvas.width = chartContainer.offsetWidth;
  canvas.height = chartContainer.offsetHeight;
  //alert(chartContainer.offsetWidth);
  var ctx = canvas.getContext("2d");
  ctx.fillStyle = "white";
  ctx.fillRect(0, 0, canvas.width, canvas.height);
  html2canvas(chartContainer).then(function (chartCanvas) {
    ctx.drawImage(chartCanvas, 0, 0);
    canvas.toBlob(function (blob) {
      var link = document.createElement("a");
      link.href = URL.createObjectURL(blob);
      link.download = "Water Level Yearly Graph";
      link.click();
    });
  });
}
//print graph end