<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
extract($_REQUEST);

$month_day = cal_days_in_month(CAL_GREGORIAN, $month, $year);

$data = array(
    'Title' => '',
    'Readings' => array() 
);

$stat_cols = "STATION_ID,STATION_NAME,RIVER_NAME,DISTRICT_NAME,UPZL_NAME";
$stat_info = $obj->View_column_details_By_Cond("SW_STATION_AUTO_MANUAL", $stat_cols, "STATION_ID='$station_id'");

$data['Title'] = "Station Name: ".$stat_info['STATION_NAME']." (".$stat_info['STATION_ID'].
"), River: ".$stat_info['RIVER_NAME'].", District: ".$stat_info['DISTRICT_NAME'].
", Upazila: ".$stat_info['UPZL_NAME'];

$wl_cols = "WL, TO_CHAR(SWL_DATE, 'DD-MM-RRRR HH24:MI:SS') AS READ_DATE, DATA_TYPE";
// $wl_cond = "STATION_ID='$station_id' AND TO_DATE(SWL_DATE, 'DD-MON-RRRR') BETWEEN TO_DATE('$year-$month-01', 'YYYY-MM-DD') AND TO_DATE('$year-$month-$month_day', 'YYYY-MM-DD') ORDER BY SWL_DATE ASC";
$wl_cond = "STATION_ID='$station_id' AND SWL_DATE BETWEEN TO_DATE('$year-$month-01', 'YYYY-MM-DD') AND TO_DATE('$year-$month-$month_day', 'YYYY-MM-DD') ORDER BY SWL_DATE ASC";

$wl_data = $obj->View_colmn_By_Cond("HYDROLOGY.SWL_DATA@HYDRO10", $wl_cols, $wl_cond);

$readings_by_date = array();
$high_data = array();  
$low_data = array();   

foreach ($wl_data as $wl_reads) {
    $read_date = $wl_reads['READ_DATE'];
    $date_only = substr($read_date, 0, 10);  

    if (!isset($readings_by_date[$read_date])) {
        $readings_by_date[$read_date] = array(
            'DateTime' => $read_date,
            'Regular' => null,
            'High' => null,
            'HighDateTime' => null,  
            'Low' => null,
            'LowDateTime' => null  
        );
    }

   
    if ($wl_reads['DATA_TYPE'] == 'R') {
        $readings_by_date[$read_date]['Regular'] = $wl_reads['WL'];
    }
    if ($wl_reads['DATA_TYPE'] == 'H') {
        if (!isset($high_data[$date_only]) || $wl_reads['WL'] > $high_data[$date_only]['High']) {
            $high_data[$date_only] = array(
                'High' => $wl_reads['WL'],
                'HighDateTime' => $read_date 
            );
        }
    }
    if ($wl_reads['DATA_TYPE'] == 'L') {
        if (!isset($low_data[$date_only]) || $wl_reads['WL'] < $low_data[$date_only]['Low']) {
            $low_data[$date_only] = array(
                'Low' => $wl_reads['WL'],
                'LowDateTime' => $read_date 
            );
        }
    }
}


foreach ($readings_by_date as &$reading) {
    $date_only = substr($reading['DateTime'], 0, 10); 
    
    if (isset($high_data[$date_only])) {
        $reading['High'] = $high_data[$date_only]['High']; 
        $reading['HighDateTime'] = $high_data[$date_only]['HighDateTime']; 
    }
    if (isset($low_data[$date_only])) {
        $reading['Low'] = $low_data[$date_only]['Low'];  
        $reading['LowDateTime'] = $low_data[$date_only]['LowDateTime'];  
    }
}

$data['Readings'] = array_values($readings_by_date);

$graph_data = json_encode($data);
echo $graph_data;
?>
