<?php
	session_start();
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	extract($_GET);
	
	$from_date = date('d-M-y', strtotime($from_date));
	$from_date = strtoupper($from_date);
	
	$to_date = date('d-M-y', strtotime($to_date));
	$to_date = strtoupper($to_date);

	$sw_info = $obj->Details_By_Cond("SW_STATION_AUTO_MANUAL","STATION_ID='$station_id'");
	$data_type_info = $obj->Details_By_Cond("ORACLE_USER.PARAMETER@G2RAW","ID='$c_data_type'");
	
	$mu_name = "";
	if($c_data_type=="451"){
		$mu_name = "Meter";
	}
	else if($c_data_type=="479"){
		$mu_name = "Decibel";
	}
	else if($c_data_type=="476"){
		$mu_name = "Metre per Second";
	}
	else if($c_data_type=="480"){
		$mu_name = "Decibel";
	}
	else if($c_data_type=="475"){
		$mu_name = "Cubic Metre per Second";
	}
	else if($c_data_type=="477"){
		$mu_name = "Degree Celcius";
	}
	else{
		$mu_name="";
	}
	
	echo '<input type="hidden" id="grph_sel_station_id" value="'.$station_id.'"/>';
	echo '<input type="hidden" id="grph_sel_station_name" value="'.$sw_info['STATION_NAME'].'"/>';
	echo '<input type="hidden" id="grph_sel_station_dist" value="'.$sw_info['DISTRICT_NAME'].'"/>';
	echo '<input type="hidden" id="grph_sel_station_upz" value="'.$sw_info['UPZL_NAME'].'"/>';
	echo '<input type="hidden" id="grph_sel_from_date" value="'.$from_date.'"/>';
	echo '<input type="hidden" id="grph_sel_to_date" value="'.$to_date.'"/>';
	echo '<input type="hidden" id="grph_sel_data_type_id" value="'.$c_data_type.'"/>';
	echo '<input type="hidden" id="grph_sel_data_type" value="'.$data_type_info['NAME'].'"/>';
	echo '<input type="hidden" id="grph_sel_mu_name" value="'.$mu_name.'"/>';
	echo '<input type="hidden" id="grph_sel_mon_name" value="'.$month_name.'"/>';
	
	$coast_data_summ_info = $obj->coastal_data_time_period_high_low($station_id,$c_data_type,$from_date,$to_date);
?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<!--graph print link start-->
<script type="text/javascript" src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
<!--graph print link end-->
<div>
<button type="button" class="btn btn-small btn-success" style="float:right;" onclick="download_coast_data_graph_chart()"><i class="icon-download"></i> Graph</button>	 
<canvas id="coast_data_line_chart"></canvas>   
</div>
<hr>

<div id="data_sum_holder" style="margin-top: 10px;">
	<h4 style="text-align: center; font-weight: bold; margin-top: 10px;color: #3333cc !important;">Highest and Lowest Data Read for the Time Period <?php echo "$from_date to $to_date"; ?></h4>
	<table class="table table-bordered table-striped table-hover" style="width: 100%;">
		<thead>
			<tr>
				<th style="text-align: center;">Highest Data Read Date-Time</th>
				<th style="text-align: center;">Highest Value</th>
				<th style="text-align: center;">Lowest Data Read Date-Time</th>
				<th style="text-align: center;">Lowest Value</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td style="text-align: center;"><?php echo $coast_data_summ_info['MAX_DATE'];?></td>
				<td style="text-align: center;"><?php echo number_format((float)$coast_data_summ_info['MAX_VALUE'], 3, '.', '');?></td>
				<td style="text-align: center;"><?php echo $coast_data_summ_info['MIN_DATE'];?></td>
				<td style="text-align: center;"><?php echo number_format((float)$coast_data_summ_info['MIN_VALUE'], 3, '.', '');?></td>
			</tr>
		</tbody>
	</table>
	<hr>
	<h4 style="text-align: center; font-weight: bold; margin-top: 10px;color: #3333cc !important;">Daily Highest and Lowest Data Read for the Time Period <?php echo "$from_date to $to_date"; ?></h4>
	<table id="coast_daily_data_summ_tbl" class="table table-bordered table-striped table-hover" style="width: 100%;">
		<thead>
		<tr>
			<th style="text-align: center;">Date</th>
			<th style="text-align: center;">Highest Data Read Time</th>
			<th style="text-align: center;">Highest Value</th>
			<th style="text-align: center;">Lowest Data Read Time</th>
			<th style="text-align: center;">Lowest Value</th>
		</tr>
		</thead>
		<tbody>
		<?php
			foreach($obj->coastal_data_daily_high_low($station_id,$c_data_type,$from_date,$to_date) as $coast_daily_sum){
				$sel_max_date_arr = explode(" ",$coast_daily_sum['MAX_DATE']);
				$sel_min_date_arr = explode(" ",$coast_daily_sum['MIN_DATE']);
				$sel_date = $sel_max_date_arr[0]; 
				$sel_max_time = $sel_max_date_arr[1]; 
				$sel_min_time = $sel_min_date_arr[1]; 
		?>
			<tr>
				<td style="text-align: center;"><?php echo $sel_date;?></td>
				<td style="text-align: center;"><?php echo $sel_max_time;?></td>
				<td style="text-align: center;"><?php echo number_format((float)$coast_daily_sum['MAX_VALUE'], 3, '.', '');?></td>
				<td style="text-align: center;"><?php echo $sel_min_time;?></td>
				<td style="text-align: center;"><?php echo number_format((float)$coast_daily_sum['MIN_VALUE'], 3, '.', '');?></td>
			</tr>
			<?php } ?>
		</tbody>
	</table>
</div>

<script type="text/javascript">
	show_coast_data_graph();
	var oTable2 = $('#coast_daily_data_summ_tbl').dataTable( {
	"aoColumns": [
	  { "bSortable": true },
	  null,null,null,
	  { "bSortable": true }
	],
	"iDisplayLength": 10});		
</script>