<?php
	include("../../php_crud/my_class.php");
	$obj = new my_class();
	session_start();
	extract($_REQUEST);
	$stat_type_info = $obj->Details_By_Cond("SW_AUTO_STATION_TYPE","ID='$station_type'");
	$desc_val = $stat_type_info['STATION_TYPE'];
	$raw_param_id = 0;
	$station_type_name = "";
	/*station type and parameter setting*/
	if($station_type==1){
		$raw_param_id = 22;
		$station_type_name = "<b><font color='#0040ff'>Water Level</font></b>";
	}
	else if($station_type==2){
		$raw_param_id = 62;
		$station_type_name = "<b><font color='#0040ff'>Rainfall</font></b>";
	}
	else if($station_type==3){
		$raw_param_id = 62;
		$station_type_name = "<b><font color='#0040ff'>Weather</font></b>";
	}
	else{
		$raw_param_id = 451;
		$station_type_name = "<b><font color='#0040ff'>Water Level (Costal)</font></b>";
	}
	/*station type and parameter setting*/
	$where = "STAT.DATA_READ_TYPE IN ('AUTO','BOTH') AND STAT.DESCRIPTION='$desc_val' 
AND STATUS_TBL.STATION_TYPE='AUTO' AND STATUS_TBL.RAW_PARAMETER_ID='$raw_param_id'";
	$label = "";
	
	/*Label and Condition setting based on location filter*/
	if($hydro_div=="all"){
		$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' 
AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='$raw_param_id'";
		$label = "$station_type_name Stations Status Information for all Hydro-Division";
	}else{
		if ($hydro_div!="" && $hydro_sub_div=="all" && $district=="") {
			$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10","HYDDIVCODE='$hydro_div'");
			$hydro_div_name = "<b><font color='#3d0099'>".$hydro_div_info['DIVISION_NAME']."</font></b>";
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' 
AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='$raw_param_id' AND HYDDIVCODE='$hydro_div'";
			$label = "$station_type_name Stations Status Information for Hydro-Division: $hydro_div_name";
		}
		else if($hydro_div!="" && $hydro_sub_div=="all" && $district!=""){
			$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10","HYDDIVCODE='$hydro_div'");
			$hydro_div_name = "<b><font color='#3d0099'>".$hydro_div_info['DIVISION_NAME']."</font></b>";
			$dist_info = $obj->Details_By_Cond("HYDROLOGY.DISTRICT_TBL@HYDRO10","DISTRICT_NO='$district'"); 
			$dist_name = "<b><font color='#3d0099'>".$dist_info['DISTRICT_NAME']."</font></b>"; 
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' AND STATION_TYPE='AUTO' 
			AND RAW_PARAMETER_ID='$raw_param_id' AND HYDDIVCODE='$hydro_div' AND DISTRICT_NO='$district'";
			$label = "$station_type_name Stations Status Information for Hydro-Division: $hydro_div_name and District: $dist_name";
		}
		else if($hydro_div!="" && $hydro_sub_div!="" && $district==""){
			$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10","HYDDIVCODE='$hydro_div'");
			$hydro_div_name = "<b><font color='#3d0099'>".$hydro_div_info['DIVISION_NAME']."</font></b>";
			$hydro_sub_div_info = $obj->Details_By_Cond("HYDROLOGY.SUBDIVCODE_TBL@HYDRO10","HYDSUBDIVCODE='$hydro_sub_div'");
			$hydro_sub_div_name = "<b><font color='#3d0099'>".$hydro_sub_div_info['SUBDIVISION_NAME']."</font></b>";
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' AND STATION_TYPE='AUTO' 
			AND RAW_PARAMETER_ID='$raw_param_id' AND HYDDIVCODE='$hydro_div' AND HYDSUBDIVCODE='$hydro_sub_div'";
			$label = "$station_type_name Stations Status Information for Hydro-Division: $hydro_div_name and Hydro-Subdivision: $hydro_sub_div_name";
		}
		else if($hydro_div!="" && $hydro_sub_div!="" && $district!=""){
			$hydro_div_info = $obj->Details_By_Cond("HYDROLOGY.DIVCODE_TBL@HYDRO10","HYDDIVCODE='$hydro_div'");
			$hydro_div_name = "<b><font color='#3d0099'>".$hydro_div_info['DIVISION_NAME']."</font></b>";
			$hydro_sub_div_info = $obj->Details_By_Cond("HYDROLOGY.SUBDIVCODE_TBL@HYDRO10","HYDSUBDIVCODE='$hydro_sub_div'");
			$hydro_sub_div_name = "<b><font color='#3d0099'>".$hydro_sub_div_info['SUBDIVISION_NAME']."</font></b>";
			$dist_info = $obj->Details_By_Cond("HYDROLOGY.DISTRICT_TBL@HYDRO10","DISTRICT_NO='$district'"); 
			$dist_name = "<b><font color='#3d0099'>".$dist_info['DISTRICT_NAME']."</font></b>"; 
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' AND STATION_TYPE='AUTO' 
			AND RAW_PARAMETER_ID='$raw_param_id' AND HYDDIVCODE='$hydro_div' AND HYDSUBDIVCODE='$hydro_sub_div' 
			AND DISTRICT_NO='$district'";
			$label = "$station_type_name Stations Status Information for Hydro-Division: $hydro_div_name, Hydro-Subdivision: $hydro_sub_div_name and District: $dist_name";
		}
		else{
			$label = "$station_type_name Stations Status Information";
			$where = "DATA_READ_TYPE IN ('AUTO','BOTH') AND DESCRIPTION='$desc_val' AND STATION_TYPE='AUTO' AND RAW_PARAMETER_ID='$raw_param_id'";
		}
		
	}
	/*Label and Condition setting based on location filter*/
	
	/*Condition Setting based on status filter*/
	$status_label = "Status type: ";
	if($sw_status==1){
		$where = $where."";
		$status_label .= "<b><font color='#8B008B'>Active & Inactive</font></b>";
	}
	else if($sw_status==2){
		$where = $where." AND STATION_STATUS='ACTIVE'";
		$status_label .= "<b><font color='#228B22'>Active</font></b>";
	}
	else if($sw_status==3){
		$where = $where." AND STATION_STATUS='INACTIVE' AND DIFF_HOURS<='72' AND DIFF_HOURS>='24'";
		$status_label .= "<b><font color='#000080'>Inactive for 24-72 Hours</font></b>";
	}
	else if($sw_status==4){
		$where = $where." AND STATION_STATUS='INACTIVE' AND DIFF_HOURS>'72'";
		$status_label .= "<b><font color='#FF0000'>Inactive for more than 72 Hours</font></b>";
	}
	else if($sw_status==5){
		$diff_hours_input = $inactive_days * 24;
		$where = $where." AND STATION_STATUS='INACTIVE' AND DIFF_HOURS>'$diff_hours_input'";
		$status_label .= "<b><font color='#b30000'>Inactive for more than $inactive_days days</font></b>";
	}
	else if($sw_status==6){
		$where = $where." AND STATION_STATUS='INACTIVE'";
		$status_label .= "<b><font color='#FF0000'>Inactive</font></b>";
	}
	else{
		$where = $where."";
		$status_label .= "<b><font color='#8B008B'>Active & Inactive</font></b>";
	}
	/*Condition Setting based on status filter*/
	//echo $where;
?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.8.1/css/all.css" rel="stylesheet" media="all" type="text/css" />
<div style="margin-top: 20px;">
	<h4><?php echo "$label, $status_label"; ?></h4>
	<h6 style="font-style: italic; font-weight: bold;"><font style='color: #228B22;'>* Active or inactive for 24 hours</font>, 
	<font style='color: #000080;'>* Inactive for 24-72 hours</font>, 
	<font style='color: #ff3300;'>* Inactive for more than 72 hours,</font>
	<font style='color: #ff0066;'>* The Last Received Date is in the future</font>
	</h6>
	 <table id="sw_station_status_det_datatbl" class="table table-striped table-bordered table-hover">
		<thead>
			<th style="text-align: center;">Sl.</th>
            <th style="text-align: center;">Station ID</th>
			<th style="text-align: center;">Station Name</th>
			
			<th style="text-align: center;">District</th>
			<th style="text-align: center;">Upazila</th>
			<th style="text-align: center;">River Name</th>
			
			<th style="text-align: center;">Latitude</th>
            <th style="text-align: center;">Longitude</th>
            <th style="text-align: center;">First Received Date</th>
			
            <th style="text-align: center;">Last Received Date</th>
            <!--<th style="text-align: center;">Status</th>-->
            <th style="text-align: center;">Action</th>
		</thead>
		<tbody>
			<?php
			$sl = 0;
			foreach($obj->surface_water_auto_station_status_details($where) as $value){
				$sl++;
				$stat_id = $value['STATION_ID'];
				$stat_name = $value['STATION_NAME'];
				$dist_name = $value['DISTRICT_NAME'];
				$upzl_name = $value['UPZL_NAME'];
				$riv_name = $value['RIVER_NAME'];
				$latitude = $value['AUTO_LAT'];
				$longitude = $value['AUTO_LON'];
                $first_date = $value['FIRSTRECEIVE_DATE'];
                $last_date = $value['LASTRECEIVE_DATE'];
				
				
				$database_date_obj = DateTime::createFromFormat('d-M-y', $last_date);
				$database_date_obj->setTime(0, 0, 0);
				$current_date_obj = new DateTime();
				$current_date_obj->setTime(0, 0, 0);

				
				$color_status = "";
				if($value['DIFF_HOURS']>72){
					$color_status = "color: #ff3300;";
				} else if($value['DIFF_HOURS']<=72 && $value['DIFF_HOURS']>24){
					$color_status = "color: #000080;";
				} else if($value['DIFF_HOURS']<=24 ){
					$color_status = "color: #228B22;";
				} 
				$font_weight = "";
				if ($database_date_obj > $current_date_obj) {
					$color_status = "color: #ff0066;";
					$font_weight = "font-weight: bold;";
				}
				
				if($station_type==1){
					$function_name = "show_graph('$stat_id', '$last_date')";
				}
				else if($station_type==2 || $station_type==3){
					$function_name = "show_rf_graph('$stat_id', '$last_date')";
				}
				else{
					$function_name = "show_graph('$stat_id', '$last_date')";
				}
				//$show_status ="<font color='$color_status'>".$value['STATION_STATUS']."</font>";
			?>	
				<tr>
					<td style='text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $sl; ?></td>
					<td style='text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $stat_id; ?></td>
					<td style='<?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $stat_name; ?></td>
					
					<td style='<?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $dist_name; ?></td>
					<td style='<?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $upzl_name; ?></td>
					<td style='<?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $riv_name; ?></td>
					
                    <td style='text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $latitude; ?></td>
                    <td style='text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $longitude; ?></td>
					<td style='text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $first_date; ?></td>
					
                    <td style='text-align: center; <?php echo $color_status; ?> <?php echo $font_weight; ?>'><?php echo $last_date; ?></td>
					<!--<td><?php //echo $show_status; ?></td>-->
					<td>
						<a class="btn btn-primary btn-small " onclick="<?php echo $function_name; ?>"><i class="icon-bar-chart"></i> Show Graph</a> 
					</td>
				</tr>
		<?php	} ?>
		</tbody>
	</table>
</div>

<script type="text/javascript">
var oTable2 = $('#sw_station_status_det_datatbl').dataTable( {
	"aoColumns": [
	  { "bSortable": true },
	  null,null,null, null,null,null, null,null,null,
	  { "bSortable": true }
	],
	"iDisplayLength": 50
});	
</script>